/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

public record ETag(String tag, boolean weak) {
    private static final Log logger = LogFactory.getLog(ETag.class);
    private static final ETag WILDCARD = new ETag("*", false);

    public boolean isWildcard() {
        return this == WILDCARD;
    }

    public String formattedTag() {
        if (this.isWildcard()) {
            return "*";
        }
        return (this.weak ? "W/" : "") + "\"" + this.tag + "\"";
    }

    @Override
    public String toString() {
        return this.formattedTag();
    }

    public static List<ETag> parse(String source2) {
        ArrayList<ETag> result2 = new ArrayList<ETag>();
        State state2 = State.BEFORE_QUOTES;
        int startIndex = -1;
        boolean weak = false;
        for (int i2 = 0; i2 < source2.length(); ++i2) {
            char c = source2.charAt(i2);
            if (state2 == State.IN_QUOTES) {
                if (c != '\"') continue;
                String tag2 = source2.substring(startIndex, i2);
                if (StringUtils.hasText(tag2)) {
                    result2.add(new ETag(tag2, weak));
                }
                state2 = State.AFTER_QUOTES;
                startIndex = -1;
                weak = false;
                continue;
            }
            if (Character.isWhitespace(c)) continue;
            if (c == ',') {
                state2 = State.BEFORE_QUOTES;
                continue;
            }
            if (state2 == State.BEFORE_QUOTES) {
                if (c == '*') {
                    result2.add(WILDCARD);
                    state2 = State.AFTER_QUOTES;
                    continue;
                }
                if (c == '\"') {
                    state2 = State.IN_QUOTES;
                    startIndex = i2 + 1;
                    continue;
                }
                if (c == 'W' && source2.length() > i2 + 2 && source2.charAt(i2 + 1) == '/' && source2.charAt(i2 + 2) == '\"') {
                    state2 = State.IN_QUOTES;
                    startIndex = (i2 += 2) + 1;
                    weak = true;
                    continue;
                }
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug("Unexpected char at index " + i2);
        }
        if (state2 != State.IN_QUOTES && logger.isDebugEnabled()) {
            logger.debug("Expected closing '\"'");
        }
        return result2;
    }

    private static enum State {
        BEFORE_QUOTES,
        IN_QUOTES,
        AFTER_QUOTES;

    }
}

