/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.support;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.reflect.KClass;
import kotlin.reflect.KMutableProperty;
import kotlin.reflect.KProperty;
import kotlin.reflect.full.KClasses;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.springframework.asm.MethodVisitor;
import org.springframework.core.KotlinDetector;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.Property;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.CodeFlow;
import org.springframework.expression.spel.CompilablePropertyAccessor;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class ReflectivePropertyAccessor
implements PropertyAccessor {
    private static final Set<Class<?>> ANY_TYPES = Collections.emptySet();
    private static final Set<Class<?>> BOOLEAN_TYPES = Set.of(Boolean.class, Boolean.TYPE);
    private final boolean allowWrite;
    private final Map<PropertyCacheKey, InvokerPair> readerCache = new ConcurrentHashMap<PropertyCacheKey, InvokerPair>(64);
    private final Map<PropertyCacheKey, Member> writerCache = new ConcurrentHashMap<PropertyCacheKey, Member>(64);
    private final Map<PropertyCacheKey, TypeDescriptor> typeDescriptorCache = new ConcurrentHashMap<PropertyCacheKey, TypeDescriptor>(64);
    private final Map<Class<?>, Method[]> sortedMethodsCache = new ConcurrentHashMap(64);
    @Nullable
    private volatile InvokerPair lastReadInvokerPair;

    public ReflectivePropertyAccessor() {
        this.allowWrite = true;
    }

    public ReflectivePropertyAccessor(boolean allowWrite) {
        this.allowWrite = allowWrite;
    }

    @Override
    @Nullable
    public Class<?>[] getSpecificTargetClasses() {
        return null;
    }

    @Override
    public boolean canRead(EvaluationContext context, @Nullable Object target2, String name2) throws AccessException {
        Class clazz;
        Class type2;
        if (target2 == null) {
            return false;
        }
        Class clazz2 = type2 = target2 instanceof Class ? (clazz = (Class)target2) : target2.getClass();
        if (type2.isArray() && name2.equals("length")) {
            return true;
        }
        PropertyCacheKey cacheKey = new PropertyCacheKey(type2, name2, target2 instanceof Class);
        if (this.readerCache.containsKey(cacheKey)) {
            return true;
        }
        Method method2 = this.findGetterForProperty(name2, type2, target2);
        if (method2 != null) {
            Property property = new Property(type2, method2, null);
            TypeDescriptor typeDescriptor = new TypeDescriptor(property);
            method2 = ClassUtils.getInterfaceMethodIfPossible(method2, type2);
            this.readerCache.put(cacheKey, new InvokerPair(method2, typeDescriptor));
            this.typeDescriptorCache.put(cacheKey, typeDescriptor);
            return true;
        }
        Field field = this.findField(name2, type2, target2);
        if (field != null) {
            TypeDescriptor typeDescriptor = new TypeDescriptor(field);
            this.readerCache.put(cacheKey, new InvokerPair(field, typeDescriptor));
            this.typeDescriptorCache.put(cacheKey, typeDescriptor);
            return true;
        }
        return false;
    }

    @Override
    public TypedValue read(EvaluationContext context, @Nullable Object target2, String name2) throws AccessException {
        Object value2;
        InvokerPair invoker;
        Class clazz;
        Class type2;
        Assert.state(target2 != null, "Target must not be null");
        Class clazz2 = type2 = target2 instanceof Class ? (clazz = (Class)target2) : target2.getClass();
        if (type2.isArray() && name2.equals("length")) {
            if (target2 instanceof Class) {
                throw new AccessException("Cannot access length on array class itself");
            }
            return new TypedValue(Array.getLength(target2));
        }
        PropertyCacheKey cacheKey = new PropertyCacheKey(type2, name2, target2 instanceof Class);
        this.lastReadInvokerPair = invoker = this.readerCache.get(cacheKey);
        if (invoker == null || invoker.member instanceof Method) {
            Method method2 = (Method)(invoker != null ? invoker.member : null);
            if (method2 == null && (method2 = this.findGetterForProperty(name2, type2, target2)) != null) {
                Property property = new Property(type2, method2, null);
                TypeDescriptor typeDescriptor = new TypeDescriptor(property);
                method2 = ClassUtils.getInterfaceMethodIfPossible(method2, type2);
                this.lastReadInvokerPair = invoker = new InvokerPair(method2, typeDescriptor);
                this.readerCache.put(cacheKey, invoker);
            }
            if (method2 != null) {
                try {
                    ReflectionUtils.makeAccessible(method2);
                    value2 = method2.invoke(target2, new Object[0]);
                    return new TypedValue(value2, invoker.typeDescriptor.narrow(value2));
                }
                catch (Exception ex) {
                    throw new AccessException("Unable to access property '" + name2 + "' through getter method", ex);
                }
            }
        }
        if (invoker == null || invoker.member instanceof Field) {
            Field field = (Field)(invoker == null ? null : invoker.member);
            if (field == null && (field = this.findField(name2, type2, target2)) != null) {
                this.lastReadInvokerPair = invoker = new InvokerPair(field, new TypeDescriptor(field));
                this.readerCache.put(cacheKey, invoker);
            }
            if (field != null) {
                try {
                    ReflectionUtils.makeAccessible(field);
                    value2 = field.get(target2);
                    return new TypedValue(value2, invoker.typeDescriptor.narrow(value2));
                }
                catch (Exception ex) {
                    throw new AccessException("Unable to access field '" + name2 + "'", ex);
                }
            }
        }
        throw new AccessException("Neither getter method nor field found for property '" + name2 + "'");
    }

    @Override
    public boolean canWrite(EvaluationContext context, @Nullable Object target2, String name2) throws AccessException {
        Class clazz;
        if (!this.allowWrite || target2 == null) {
            return false;
        }
        Class type2 = target2 instanceof Class ? (clazz = (Class)target2) : target2.getClass();
        PropertyCacheKey cacheKey = new PropertyCacheKey(type2, name2, target2 instanceof Class);
        if (this.writerCache.containsKey(cacheKey)) {
            return true;
        }
        Method method2 = this.findSetterForProperty(name2, type2, target2);
        if (method2 != null) {
            Property property = new Property(type2, null, method2);
            TypeDescriptor typeDescriptor = new TypeDescriptor(property);
            method2 = ClassUtils.getInterfaceMethodIfPossible(method2, type2);
            this.writerCache.put(cacheKey, method2);
            this.typeDescriptorCache.put(cacheKey, typeDescriptor);
            return true;
        }
        Field field = this.findField(name2, type2, target2);
        if (field != null) {
            this.writerCache.put(cacheKey, field);
            this.typeDescriptorCache.put(cacheKey, new TypeDescriptor(field));
            return true;
        }
        return false;
    }

    @Override
    public void write(EvaluationContext context, @Nullable Object target2, String name2, @Nullable Object newValue) throws AccessException {
        PropertyCacheKey cacheKey;
        Member cachedMember;
        Class clazz;
        if (!this.allowWrite) {
            throw new AccessException("PropertyAccessor for property '" + name2 + "' on target [" + target2 + "] does not allow write operations");
        }
        Assert.state(target2 != null, "Target must not be null");
        Class type2 = target2 instanceof Class ? (clazz = (Class)target2) : target2.getClass();
        Object possiblyConvertedNewValue = newValue;
        TypeDescriptor typeDescriptor = this.getTypeDescriptor(context, target2, name2);
        if (typeDescriptor != null) {
            try {
                possiblyConvertedNewValue = context.getTypeConverter().convertValue(newValue, TypeDescriptor.forObject(newValue), typeDescriptor);
            }
            catch (EvaluationException evaluationException) {
                throw new AccessException("Type conversion failure", evaluationException);
            }
        }
        if ((cachedMember = this.writerCache.get(cacheKey = new PropertyCacheKey(type2, name2, target2 instanceof Class))) == null || cachedMember instanceof Method) {
            Method method2 = (Method)cachedMember;
            if (method2 == null && (method2 = this.findSetterForProperty(name2, type2, target2)) != null) {
                method2 = ClassUtils.getInterfaceMethodIfPossible(method2, type2);
                cachedMember = method2;
                this.writerCache.put(cacheKey, cachedMember);
            }
            if (method2 != null) {
                try {
                    ReflectionUtils.makeAccessible(method2);
                    method2.invoke(target2, possiblyConvertedNewValue);
                    return;
                }
                catch (Exception ex) {
                    throw new AccessException("Unable to access property '" + name2 + "' through setter method", ex);
                }
            }
        }
        if (cachedMember == null || cachedMember instanceof Field) {
            Field field = (Field)cachedMember;
            if (field == null && (field = this.findField(name2, type2, target2)) != null) {
                cachedMember = field;
                this.writerCache.put(cacheKey, cachedMember);
            }
            if (field != null) {
                try {
                    ReflectionUtils.makeAccessible(field);
                    field.set(target2, possiblyConvertedNewValue);
                    return;
                }
                catch (Exception ex) {
                    throw new AccessException("Unable to access field '" + name2 + "'", ex);
                }
            }
        }
        throw new AccessException("Neither setter method nor field found for property '" + name2 + "'");
    }

    @Nullable
    private TypeDescriptor getTypeDescriptor(EvaluationContext context, Object target2, String name2) {
        Class clazz;
        Class type2;
        Class clazz2 = type2 = target2 instanceof Class ? (clazz = (Class)target2) : target2.getClass();
        if (type2.isArray() && name2.equals("length")) {
            return TypeDescriptor.valueOf(Integer.TYPE);
        }
        PropertyCacheKey cacheKey = new PropertyCacheKey(type2, name2, target2 instanceof Class);
        TypeDescriptor typeDescriptor = this.typeDescriptorCache.get(cacheKey);
        if (typeDescriptor == null) {
            try {
                if (this.canRead(context, target2, name2) || this.canWrite(context, target2, name2)) {
                    typeDescriptor = this.typeDescriptorCache.get(cacheKey);
                }
            }
            catch (AccessException accessException) {
                // empty catch block
            }
        }
        return typeDescriptor;
    }

    @Nullable
    private Method findGetterForProperty(String propertyName, Class<?> clazz, Object target2) {
        boolean targetIsAClass = target2 instanceof Class;
        Method method2 = this.findGetterForProperty(propertyName, clazz, targetIsAClass);
        if (method2 == null && targetIsAClass) {
            method2 = this.findGetterForProperty(propertyName, Class.class, false);
        }
        return method2;
    }

    @Nullable
    private Method findSetterForProperty(String propertyName, Class<?> clazz, Object target2) {
        Method method2 = this.findSetterForProperty(propertyName, clazz, target2 instanceof Class);
        return method2;
    }

    @Nullable
    protected Method findGetterForProperty(String propertyName, Class<?> clazz, boolean mustBeStatic) {
        Method method2 = this.findMethodForProperty(this.getPropertyMethodSuffixes(propertyName), "get", clazz, mustBeStatic, 0, ANY_TYPES);
        if (method2 == null && (method2 = this.findMethodForProperty(this.getPropertyMethodSuffixes(propertyName), "is", clazz, mustBeStatic, 0, BOOLEAN_TYPES)) == null) {
            method2 = this.findMethodForProperty(new String[]{propertyName}, "", clazz, mustBeStatic, 0, ANY_TYPES);
        }
        return method2;
    }

    @Nullable
    protected Method findSetterForProperty(String propertyName, Class<?> clazz, boolean mustBeStatic) {
        return this.findMethodForProperty(this.getPropertyMethodSuffixes(propertyName), "set", clazz, mustBeStatic, 1, ANY_TYPES);
    }

    @Nullable
    private Method findMethodForProperty(String[] methodSuffixes, String prefix, Class<?> clazz, boolean mustBeStatic, int numberOfParams, Set<Class<?>> requiredReturnTypes) {
        Method[] methods2 = this.getSortedMethods(clazz);
        for (String methodSuffix : methodSuffixes) {
            for (Method method2 : methods2) {
                if (!this.isCandidateForProperty(method2, clazz) || !method2.getName().equals(prefix + methodSuffix) && !ReflectivePropertyAccessor.isKotlinProperty(method2, methodSuffix) || method2.getParameterCount() != numberOfParams || mustBeStatic && !Modifier.isStatic(method2.getModifiers()) || !requiredReturnTypes.isEmpty() && !requiredReturnTypes.contains(method2.getReturnType())) continue;
                return method2;
            }
        }
        return null;
    }

    private Method[] getSortedMethods(Class<?> clazz) {
        return this.sortedMethodsCache.computeIfAbsent(clazz, key2 -> {
            Method[] methods2 = key2.getMethods();
            Arrays.sort(methods2, (o1, o2) -> o1.isBridge() == o2.isBridge() ? 0 : (o1.isBridge() ? 1 : -1));
            return methods2;
        });
    }

    protected boolean isCandidateForProperty(Method method2, Class<?> targetClass) {
        return true;
    }

    protected String[] getPropertyMethodSuffixes(String propertyName) {
        String suffix = this.getPropertyMethodSuffix(propertyName);
        if (suffix.length() > 0 && Character.isUpperCase(suffix.charAt(0))) {
            return new String[]{suffix};
        }
        return new String[]{suffix, StringUtils.capitalize(suffix)};
    }

    protected String getPropertyMethodSuffix(String propertyName) {
        if (propertyName.length() > 1 && Character.isUpperCase(propertyName.charAt(1))) {
            return propertyName;
        }
        return StringUtils.capitalize(propertyName);
    }

    @Nullable
    private Field findField(String name2, Class<?> clazz, Object target2) {
        Field field = this.findField(name2, clazz, target2 instanceof Class);
        if (field == null && target2 instanceof Class) {
            field = this.findField(name2, target2.getClass(), false);
        }
        return field;
    }

    @Nullable
    protected Field findField(String name2, Class<?> clazz, boolean mustBeStatic) {
        Field field;
        Field[] fields2 = clazz.getFields();
        for (Field field2 : fields2) {
            if (!field2.getName().equals(name2) || mustBeStatic && !Modifier.isStatic(field2.getModifiers())) continue;
            return field2;
        }
        if (clazz.getSuperclass() != null && (field = this.findField(name2, clazz.getSuperclass(), mustBeStatic)) != null) {
            return field;
        }
        for (AnnotatedElement annotatedElement : clazz.getInterfaces()) {
            Field field3 = this.findField(name2, (Class<?>)annotatedElement, mustBeStatic);
            if (field3 == null) continue;
            return field3;
        }
        return null;
    }

    public PropertyAccessor createOptimalAccessor(EvaluationContext context, @Nullable Object target2, String name2) {
        Class clazz;
        Class type2;
        if (target2 == null) {
            return this;
        }
        Class clazz2 = type2 = target2 instanceof Class ? (clazz = (Class)target2) : target2.getClass();
        if (type2.isArray()) {
            return this;
        }
        PropertyCacheKey cacheKey = new PropertyCacheKey(type2, name2, target2 instanceof Class);
        InvokerPair invocationTarget = this.readerCache.get(cacheKey);
        if (invocationTarget == null || invocationTarget.member instanceof Method) {
            Method method2 = (Method)(invocationTarget != null ? invocationTarget.member : null);
            if (method2 == null && (method2 = this.findGetterForProperty(name2, type2, target2)) != null) {
                TypeDescriptor typeDescriptor = new TypeDescriptor(new MethodParameter(method2, -1));
                method2 = ClassUtils.getInterfaceMethodIfPossible(method2, type2);
                invocationTarget = new InvokerPair(method2, typeDescriptor);
                ReflectionUtils.makeAccessible(method2);
                this.readerCache.put(cacheKey, invocationTarget);
            }
            if (method2 != null) {
                return new OptimalPropertyAccessor(invocationTarget);
            }
        }
        if (invocationTarget == null || invocationTarget.member instanceof Field) {
            Field field;
            Field field2 = field = invocationTarget != null ? (Field)invocationTarget.member : null;
            if (field == null && (field = this.findField(name2, type2, target2 instanceof Class)) != null) {
                invocationTarget = new InvokerPair(field, new TypeDescriptor(field));
                ReflectionUtils.makeAccessible(field);
                this.readerCache.put(cacheKey, invocationTarget);
            }
            if (field != null) {
                return new OptimalPropertyAccessor(invocationTarget);
            }
        }
        return this;
    }

    private static boolean isKotlinProperty(Method method2, String methodSuffix) {
        Class<?> clazz = method2.getDeclaringClass();
        return KotlinDetector.isKotlinReflectPresent() && KotlinDetector.isKotlinType(clazz) && KotlinDelegate.isKotlinProperty(method2, methodSuffix);
    }

    private static final class PropertyCacheKey
    implements Comparable<PropertyCacheKey> {
        private final Class<?> clazz;
        private final String property;
        private final boolean targetIsClass;

        public PropertyCacheKey(Class<?> clazz, String name2, boolean targetIsClass) {
            this.clazz = clazz;
            this.property = name2;
            this.targetIsClass = targetIsClass;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(@Nullable Object other) {
            if (this == other) return true;
            if (!(other instanceof PropertyCacheKey)) return false;
            PropertyCacheKey that = (PropertyCacheKey)other;
            if (this.clazz != that.clazz) return false;
            if (!this.property.equals(that.property)) return false;
            if (this.targetIsClass != that.targetIsClass) return false;
            return true;
        }

        public int hashCode() {
            return this.clazz.hashCode() * 29 + this.property.hashCode();
        }

        public String toString() {
            return "PropertyCacheKey [clazz=" + this.clazz.getName() + ", property=" + this.property + ", targetIsClass=" + this.targetIsClass + "]";
        }

        @Override
        public int compareTo(PropertyCacheKey other) {
            int result2 = this.clazz.getName().compareTo(other.clazz.getName());
            if (result2 == 0) {
                result2 = this.property.compareTo(other.property);
            }
            return result2;
        }
    }

    private record InvokerPair(Member member, TypeDescriptor typeDescriptor) {
    }

    public static class OptimalPropertyAccessor
    implements CompilablePropertyAccessor {
        public final Member member;
        private final TypeDescriptor typeDescriptor;

        OptimalPropertyAccessor(InvokerPair target2) {
            this.member = target2.member;
            this.typeDescriptor = target2.typeDescriptor;
        }

        @Override
        @Nullable
        public Class<?>[] getSpecificTargetClasses() {
            throw new UnsupportedOperationException("Should not be called on an OptimalPropertyAccessor");
        }

        @Override
        public boolean canRead(EvaluationContext context, @Nullable Object target2, String name2) throws AccessException {
            Class clazz;
            Class type2;
            if (target2 == null) {
                return false;
            }
            Class clazz2 = type2 = target2 instanceof Class ? (clazz = (Class)target2) : target2.getClass();
            if (type2.isArray()) {
                return false;
            }
            Member member = this.member;
            if (member instanceof Method) {
                Method method2 = (Method)member;
                String getterName = "get" + StringUtils.capitalize(name2);
                if (getterName.equals(method2.getName())) {
                    return true;
                }
                getterName = "is" + StringUtils.capitalize(name2);
                if (getterName.equals(method2.getName())) {
                    return true;
                }
            }
            return this.member.getName().equals(name2);
        }

        @Override
        public TypedValue read(EvaluationContext context, @Nullable Object target2, String name2) throws AccessException {
            Member member = this.member;
            if (member instanceof Method) {
                Method method2 = (Method)member;
                try {
                    ReflectionUtils.makeAccessible(method2);
                    Object value2 = method2.invoke(target2, new Object[0]);
                    return new TypedValue(value2, this.typeDescriptor.narrow(value2));
                }
                catch (Exception ex) {
                    throw new AccessException("Unable to access property '" + name2 + "' through getter method", ex);
                }
            }
            Field field = (Field)this.member;
            try {
                ReflectionUtils.makeAccessible(field);
                Object value3 = field.get(target2);
                return new TypedValue(value3, this.typeDescriptor.narrow(value3));
            }
            catch (Exception ex) {
                throw new AccessException("Unable to access field '" + name2 + "'", ex);
            }
        }

        @Override
        public boolean canWrite(EvaluationContext context, @Nullable Object target2, String name2) {
            throw new UnsupportedOperationException("Should not be called on an OptimalPropertyAccessor");
        }

        @Override
        public void write(EvaluationContext context, @Nullable Object target2, String name2, @Nullable Object newValue) {
            throw new UnsupportedOperationException("Should not be called on an OptimalPropertyAccessor");
        }

        @Override
        public boolean isCompilable() {
            return Modifier.isPublic(this.member.getModifiers()) && Modifier.isPublic(this.member.getDeclaringClass().getModifiers());
        }

        @Override
        public Class<?> getPropertyType() {
            Member member = this.member;
            if (member instanceof Method) {
                Method method2 = (Method)member;
                return method2.getReturnType();
            }
            return ((Field)this.member).getType();
        }

        @Override
        public void generateCode(String propertyName, MethodVisitor mv, CodeFlow cf) {
            Member member;
            boolean isStatic = Modifier.isStatic(this.member.getModifiers());
            String descriptor = cf.lastDescriptor();
            String classDesc = this.member.getDeclaringClass().getName().replace('.', '/');
            if (!isStatic) {
                if (descriptor == null) {
                    cf.loadTarget(mv);
                }
                if (descriptor == null || !classDesc.equals(descriptor.substring(1))) {
                    mv.visitTypeInsn(192, classDesc);
                }
            } else if (descriptor != null) {
                mv.visitInsn(87);
            }
            if ((member = this.member) instanceof Method) {
                Method method2 = (Method)member;
                boolean isInterface = method2.getDeclaringClass().isInterface();
                int opcode = isStatic ? 184 : (isInterface ? 185 : 182);
                mv.visitMethodInsn(opcode, classDesc, method2.getName(), CodeFlow.createSignatureDescriptor(method2), isInterface);
            } else {
                mv.visitFieldInsn(isStatic ? 178 : 180, classDesc, this.member.getName(), CodeFlow.toJvmDescriptor(((Field)this.member).getType()));
            }
        }
    }

    private static class KotlinDelegate {
        private KotlinDelegate() {
        }

        public static boolean isKotlinProperty(Method method2, String methodSuffix) {
            KClass kClass = JvmClassMappingKt.getKotlinClass(method2.getDeclaringClass());
            for (KProperty property : KClasses.getMemberProperties((KClass)kClass)) {
                KMutableProperty mutableProperty;
                if (!methodSuffix.equalsIgnoreCase(property.getName()) || !method2.equals(ReflectJvmMapping.getJavaGetter((KProperty)property)) && (!(property instanceof KMutableProperty) || !method2.equals(ReflectJvmMapping.getJavaSetter((KMutableProperty)(mutableProperty = (KMutableProperty)property))))) continue;
                return true;
            }
            return false;
        }
    }
}

