/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.support;

import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.MethodExecutor;
import org.springframework.expression.MethodFilter;
import org.springframework.expression.MethodResolver;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelMessage;
import org.springframework.expression.spel.support.ReflectionHelper;
import org.springframework.expression.spel.support.ReflectiveMethodExecutor;
import org.springframework.lang.Nullable;

public class ReflectiveMethodResolver
implements MethodResolver {
    private final boolean useDistance;
    @Nullable
    private Map<Class<?>, MethodFilter> filters;

    public ReflectiveMethodResolver() {
        this(true);
    }

    public ReflectiveMethodResolver(boolean useDistance) {
        this.useDistance = useDistance;
    }

    public void registerMethodFilter(Class<?> type2, @Nullable MethodFilter filter2) {
        if (this.filters == null) {
            this.filters = new HashMap();
        }
        if (filter2 != null) {
            this.filters.put(type2, filter2);
        } else {
            this.filters.remove(type2);
        }
    }

    @Override
    @Nullable
    public MethodExecutor resolve(EvaluationContext context, Object targetObject, String name2, List<TypeDescriptor> argumentTypes) throws AccessException {
        try {
            MethodFilter filter2;
            Class clazz;
            TypeConverter typeConverter = context.getTypeConverter();
            Class type2 = targetObject instanceof Class ? (clazz = (Class)targetObject) : targetObject.getClass();
            ArrayList<Method> methods2 = new ArrayList<Method>(this.getMethods(type2, targetObject));
            methods2.removeIf(method2 -> !method2.getName().equals(name2));
            MethodFilter methodFilter = filter2 = this.filters != null ? this.filters.get(type2) : null;
            if (filter2 != null) {
                List<Method> filtered = filter2.filter(methods2);
                if (filtered instanceof ArrayList) {
                    ArrayList arrayList = (ArrayList)filtered;
                    v1 = arrayList;
                } else {
                    v1 = methods2 = new ArrayList<Method>(filtered);
                }
            }
            if (methods2.size() > 1) {
                methods2.sort((m1, m2) -> {
                    int m2pl;
                    int m1pl = m1.getParameterCount();
                    if (m1pl == (m2pl = m2.getParameterCount())) {
                        if (!m1.isVarArgs() && m2.isVarArgs()) {
                            return -1;
                        }
                        if (m1.isVarArgs() && !m2.isVarArgs()) {
                            return 1;
                        }
                        return 0;
                    }
                    return Integer.compare(m1pl, m2pl);
                });
            }
            for (int i2 = 0; i2 < methods2.size(); ++i2) {
                methods2.set(i2, BridgeMethodResolver.findBridgedMethod(methods2.get(i2)));
            }
            LinkedHashSet<Method> methodsToIterate = new LinkedHashSet<Method>(methods2);
            Method closeMatch = null;
            int closeMatchDistance = Integer.MAX_VALUE;
            Method matchRequiringConversion = null;
            boolean multipleOptions = false;
            for (Method method3 : methodsToIterate) {
                int paramCount = method3.getParameterCount();
                ArrayList<TypeDescriptor> paramDescriptors = new ArrayList<TypeDescriptor>(paramCount);
                for (int i3 = 0; i3 < paramCount; ++i3) {
                    paramDescriptors.add(new TypeDescriptor(new MethodParameter(method3, i3)));
                }
                ReflectionHelper.ArgumentsMatchInfo matchInfo = null;
                if (method3.isVarArgs() && argumentTypes.size() >= paramCount - 1) {
                    matchInfo = ReflectionHelper.compareArgumentsVarargs(paramDescriptors, argumentTypes, typeConverter);
                } else if (paramCount == argumentTypes.size()) {
                    matchInfo = ReflectionHelper.compareArguments(paramDescriptors, argumentTypes, typeConverter);
                }
                if (matchInfo == null) continue;
                if (matchInfo.isExactMatch()) {
                    return new ReflectiveMethodExecutor(method3, type2);
                }
                if (matchInfo.isCloseMatch()) {
                    if (this.useDistance) {
                        int matchDistance = ReflectionHelper.getTypeDifferenceWeight(paramDescriptors, argumentTypes);
                        if (closeMatch != null && matchDistance >= closeMatchDistance) continue;
                        closeMatch = method3;
                        closeMatchDistance = matchDistance;
                        continue;
                    }
                    if (closeMatch != null) continue;
                    closeMatch = method3;
                    continue;
                }
                if (!matchInfo.isMatchRequiringConversion()) continue;
                if (matchRequiringConversion != null) {
                    multipleOptions = true;
                }
                matchRequiringConversion = method3;
            }
            if (closeMatch != null) {
                return new ReflectiveMethodExecutor(closeMatch, type2);
            }
            if (matchRequiringConversion != null) {
                if (multipleOptions) {
                    throw new SpelEvaluationException(SpelMessage.MULTIPLE_POSSIBLE_METHODS, name2);
                }
                return new ReflectiveMethodExecutor(matchRequiringConversion, type2);
            }
            return null;
        }
        catch (EvaluationException ex) {
            throw new AccessException("Failed to resolve method", ex);
        }
    }

    private Set<Method> getMethods(Class<?> type2, Object targetObject) {
        if (targetObject instanceof Class) {
            LinkedHashSet<Method> result2 = new LinkedHashSet<Method>();
            for (Method method2 : this.getMethods(type2)) {
                if (!Modifier.isStatic(method2.getModifiers())) continue;
                result2.add(method2);
            }
            Collections.addAll(result2, this.getMethods(Class.class));
            return result2;
        }
        if (Proxy.isProxyClass(type2)) {
            LinkedHashSet<Method> result3 = new LinkedHashSet<Method>();
            for (Class<?> clazz : type2.getInterfaces()) {
                for (Method method3 : this.getMethods(clazz)) {
                    if (!this.isCandidateForInvocation(method3, type2)) continue;
                    result3.add(method3);
                }
            }
            for (GenericDeclaration genericDeclaration : this.getMethods(Object.class)) {
                if (!this.isCandidateForInvocation((Method)genericDeclaration, type2)) continue;
                result3.add((Method)genericDeclaration);
            }
            return result3;
        }
        LinkedHashSet<Method> result4 = new LinkedHashSet<Method>();
        for (Method method3 : this.getMethods(type2)) {
            if (!this.isCandidateForInvocation(method3, type2)) continue;
            result4.add(method3);
        }
        return result4;
    }

    protected Method[] getMethods(Class<?> type2) {
        return type2.getMethods();
    }

    protected boolean isCandidateForInvocation(Method method2, Class<?> targetClass) {
        return true;
    }
}

