/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import java.lang.reflect.Modifier;
import java.util.function.Supplier;
import org.springframework.asm.MethodVisitor;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.CodeFlow;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.ast.SpelNodeImpl;
import org.springframework.expression.spel.ast.ValueRef;
import org.springframework.lang.Nullable;

public class VariableReference
extends SpelNodeImpl {
    private static final String THIS = "this";
    private static final String ROOT = "root";
    private final String name;

    public VariableReference(String variableName, int startPos, int endPos) {
        super(startPos, endPos, new SpelNodeImpl[0]);
        this.name = variableName;
    }

    @Override
    public ValueRef getValueRef(ExpressionState state2) throws SpelEvaluationException {
        if (THIS.equals(this.name)) {
            return new ValueRef.TypedValueHolderValueRef(state2.getActiveContextObject(), this);
        }
        if (ROOT.equals(this.name)) {
            return new ValueRef.TypedValueHolderValueRef(state2.getRootContextObject(), this);
        }
        TypedValue result2 = state2.lookupVariable(this.name);
        return new VariableRef(this.name, result2, state2.getEvaluationContext());
    }

    @Override
    public TypedValue getValueInternal(ExpressionState state2) throws SpelEvaluationException {
        TypedValue result2;
        if (THIS.equals(this.name)) {
            result2 = state2.getActiveContextObject();
            if (result2 != state2.getRootContextObject()) {
                return result2;
            }
        } else {
            result2 = ROOT.equals(this.name) ? state2.getRootContextObject() : state2.lookupVariable(this.name);
        }
        this.setExitTypeDescriptor(result2.getValue());
        return result2;
    }

    private void setExitTypeDescriptor(@Nullable Object value2) {
        this.exitTypeDescriptor = value2 == null || !Modifier.isPublic(value2.getClass().getModifiers()) ? "Ljava/lang/Object" : CodeFlow.toDescriptorFromObject(value2);
    }

    @Override
    public TypedValue setValueInternal(ExpressionState state2, Supplier<TypedValue> valueSupplier) throws EvaluationException {
        return state2.assignVariable(this.name, valueSupplier);
    }

    @Override
    public String toStringAST() {
        return "#" + this.name;
    }

    @Override
    public boolean isWritable(ExpressionState expressionState) throws SpelEvaluationException {
        return !THIS.equals(this.name) && !ROOT.equals(this.name);
    }

    @Override
    public boolean isCompilable() {
        return this.exitTypeDescriptor != null;
    }

    @Override
    public void generateCode(MethodVisitor mv, CodeFlow cf) {
        if (THIS.equals(this.name) || ROOT.equals(this.name)) {
            mv.visitVarInsn(25, 1);
        } else {
            mv.visitVarInsn(25, 2);
            mv.visitLdcInsn(this.name);
            mv.visitMethodInsn(185, "org/springframework/expression/EvaluationContext", "lookupVariable", "(Ljava/lang/String;)Ljava/lang/Object;", true);
        }
        CodeFlow.insertCheckCast(mv, this.exitTypeDescriptor);
        cf.pushDescriptor(this.exitTypeDescriptor);
    }

    private static class VariableRef
    implements ValueRef {
        private final String name;
        private final TypedValue value;
        private final EvaluationContext evaluationContext;

        public VariableRef(String name2, TypedValue value2, EvaluationContext evaluationContext) {
            this.name = name2;
            this.value = value2;
            this.evaluationContext = evaluationContext;
        }

        @Override
        public TypedValue getValue() {
            return this.value;
        }

        @Override
        public void setValue(@Nullable Object newValue) {
            this.evaluationContext.setVariable(this.name, newValue);
        }

        @Override
        public boolean isWritable() {
            return true;
        }
    }
}

