/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelMessage;
import org.springframework.expression.spel.ast.SpelNodeImpl;
import org.springframework.expression.spel.ast.ValueRef;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

public class Selection
extends SpelNodeImpl {
    public static final int ALL = 0;
    public static final int FIRST = 1;
    public static final int LAST = 2;
    private final int variant;
    private final boolean nullSafe;

    public Selection(boolean nullSafe, int variant, int startPos, int endPos, SpelNodeImpl expression) {
        super(startPos, endPos, expression);
        this.nullSafe = nullSafe;
        this.variant = variant;
    }

    @Override
    public final boolean isNullSafe() {
        return this.nullSafe;
    }

    @Override
    public TypedValue getValueInternal(ExpressionState state2) throws EvaluationException {
        return this.getValueRef(state2).getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ValueRef getValueRef(ExpressionState state2) throws EvaluationException {
        TypedValue op = state2.getActiveContextObject();
        Object operand = op.getValue();
        SpelNodeImpl selectionCriteria = this.children[0];
        if (operand instanceof Map) {
            Map mapdata = (Map)operand;
            HashMap result2 = new HashMap();
            Object lastKey = null;
            for (Map.Entry entry : mapdata.entrySet()) {
                try {
                    TypedValue kvPair = new TypedValue(entry);
                    state2.pushActiveContextObject(kvPair);
                    state2.enterScope();
                    Object val = selectionCriteria.getValueInternal(state2).getValue();
                    if (val instanceof Boolean) {
                        Boolean b2 = (Boolean)val;
                        if (!b2.booleanValue()) continue;
                        result2.put(entry.getKey(), entry.getValue());
                        if (this.variant == 1) {
                            ValueRef.TypedValueHolderValueRef typedValueHolderValueRef = new ValueRef.TypedValueHolderValueRef(new TypedValue(result2), this);
                            return typedValueHolderValueRef;
                        }
                        lastKey = entry.getKey();
                        continue;
                    }
                    throw new SpelEvaluationException(selectionCriteria.getStartPosition(), SpelMessage.RESULT_OF_SELECTION_CRITERIA_IS_NOT_BOOLEAN, new Object[0]);
                }
                finally {
                    state2.popActiveContextObject();
                    state2.exitScope();
                }
            }
            if ((this.variant == 1 || this.variant == 2) && result2.isEmpty()) {
                return new ValueRef.TypedValueHolderValueRef(TypedValue.NULL, this);
            }
            if (this.variant == 2) {
                HashMap resultMap = new HashMap();
                Object lastValue = result2.get(lastKey);
                resultMap.put(lastKey, lastValue);
                return new ValueRef.TypedValueHolderValueRef(new TypedValue(resultMap), this);
            }
            return new ValueRef.TypedValueHolderValueRef(new TypedValue(result2), this);
        }
        if (operand instanceof Iterable || ObjectUtils.isArray(operand)) {
            TypeDescriptor elementTypeDesc;
            Iterable<Object> iterable;
            if (operand instanceof Iterable) {
                Iterable iterable2 = (Iterable)operand;
                iterable = iterable2;
            } else {
                iterable = Arrays.asList(ObjectUtils.toObjectArray(operand));
            }
            Iterable<Object> data2 = iterable;
            ArrayList<Object> result3 = new ArrayList<Object>();
            int index2 = 0;
            for (Object element : data2) {
                try {
                    state2.pushActiveContextObject(new TypedValue(element));
                    state2.enterScope("index", index2);
                    Object val = selectionCriteria.getValueInternal(state2).getValue();
                    if (val instanceof Boolean) {
                        Boolean b3 = (Boolean)val;
                        if (b3.booleanValue()) {
                            if (this.variant == 1) {
                                ValueRef.TypedValueHolderValueRef typedValueHolderValueRef = new ValueRef.TypedValueHolderValueRef(new TypedValue(element), this);
                                return typedValueHolderValueRef;
                            }
                            result3.add(element);
                        }
                    } else {
                        throw new SpelEvaluationException(selectionCriteria.getStartPosition(), SpelMessage.RESULT_OF_SELECTION_CRITERIA_IS_NOT_BOOLEAN, new Object[0]);
                    }
                    ++index2;
                }
                finally {
                    state2.exitScope();
                    state2.popActiveContextObject();
                }
            }
            if ((this.variant == 1 || this.variant == 2) && result3.isEmpty()) {
                return ValueRef.NullValueRef.INSTANCE;
            }
            if (this.variant == 2) {
                return new ValueRef.TypedValueHolderValueRef(new TypedValue(CollectionUtils.lastElement(result3)), this);
            }
            if (operand instanceof Iterable) {
                return new ValueRef.TypedValueHolderValueRef(new TypedValue(result3), this);
            }
            Class<?> elementType = null;
            TypeDescriptor typeDesc = op.getTypeDescriptor();
            if (typeDesc != null && (elementTypeDesc = typeDesc.getElementTypeDescriptor()) != null) {
                elementType = ClassUtils.resolvePrimitiveIfNecessary(elementTypeDesc.getType());
            }
            Assert.state(elementType != null, "Unresolvable element type");
            Object resultArray = Array.newInstance(elementType, result3.size());
            System.arraycopy(result3.toArray(), 0, resultArray, 0, result3.size());
            return new ValueRef.TypedValueHolderValueRef(new TypedValue(resultArray), this);
        }
        if (operand == null) {
            if (this.nullSafe) {
                return ValueRef.NullValueRef.INSTANCE;
            }
            throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.INVALID_TYPE_FOR_SELECTION, "null");
        }
        throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.INVALID_TYPE_FOR_SELECTION, operand.getClass().getName());
    }

    @Override
    public String toStringAST() {
        return this.prefix() + this.getChild(0).toStringAST() + "]";
    }

    private String prefix() {
        return switch (this.variant) {
            case 0 -> "?[";
            case 1 -> "^[";
            case 2 -> "$[";
            default -> "";
        };
    }
}

