/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelMessage;
import org.springframework.expression.spel.ast.SpelNodeImpl;
import org.springframework.expression.spel.ast.ValueRef;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public class Projection
extends SpelNodeImpl {
    private final boolean nullSafe;

    public Projection(boolean nullSafe, int startPos, int endPos, SpelNodeImpl expression) {
        super(startPos, endPos, expression);
        this.nullSafe = nullSafe;
    }

    @Override
    public final boolean isNullSafe() {
        return this.nullSafe;
    }

    @Override
    public TypedValue getValueInternal(ExpressionState state2) throws EvaluationException {
        return this.getValueRef(state2).getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ValueRef getValueRef(ExpressionState state2) throws EvaluationException {
        TypedValue op = state2.getActiveContextObject();
        Object operand = op.getValue();
        if (operand instanceof Map) {
            Map mapData = (Map)operand;
            ArrayList<Object> result2 = new ArrayList<Object>();
            for (Map.Entry entry : mapData.entrySet()) {
                try {
                    state2.pushActiveContextObject(new TypedValue(entry));
                    state2.enterScope();
                    result2.add(this.children[0].getValueInternal(state2).getValue());
                }
                finally {
                    state2.popActiveContextObject();
                    state2.exitScope();
                }
            }
            return new ValueRef.TypedValueHolderValueRef(new TypedValue(result2), this);
        }
        boolean operandIsArray = ObjectUtils.isArray(operand);
        if (operand instanceof Iterable || operandIsArray) {
            Iterable<Object> iterable;
            if (operand instanceof Iterable) {
                Iterable iterable2 = (Iterable)operand;
                iterable = iterable2;
            } else {
                iterable = Arrays.asList(ObjectUtils.toObjectArray(operand));
            }
            Iterable<Object> data2 = iterable;
            ArrayList<Object> result3 = new ArrayList<Object>();
            Class arrayElementType = null;
            for (Object element : data2) {
                try {
                    state2.pushActiveContextObject(new TypedValue(element));
                    state2.enterScope("index", result3.size());
                    Object value2 = this.children[0].getValueInternal(state2).getValue();
                    if (value2 != null && operandIsArray) {
                        arrayElementType = this.determineCommonType(arrayElementType, value2.getClass());
                    }
                    result3.add(value2);
                }
                finally {
                    state2.exitScope();
                    state2.popActiveContextObject();
                }
            }
            if (operandIsArray) {
                if (arrayElementType == null) {
                    arrayElementType = Object.class;
                }
                Object resultArray = Array.newInstance(arrayElementType, result3.size());
                System.arraycopy(result3.toArray(), 0, resultArray, 0, result3.size());
                return new ValueRef.TypedValueHolderValueRef(new TypedValue(resultArray), this);
            }
            return new ValueRef.TypedValueHolderValueRef(new TypedValue(result3), this);
        }
        if (operand == null) {
            if (this.nullSafe) {
                return ValueRef.NullValueRef.INSTANCE;
            }
            throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.PROJECTION_NOT_SUPPORTED_ON_TYPE, "null");
        }
        throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.PROJECTION_NOT_SUPPORTED_ON_TYPE, operand.getClass().getName());
    }

    @Override
    public String toStringAST() {
        return "![" + this.getChild(0).toStringAST() + "]";
    }

    private Class<?> determineCommonType(@Nullable Class<?> oldType, Class<?> newType) {
        if (oldType == null) {
            return newType;
        }
        if (oldType.isAssignableFrom(newType)) {
            return oldType;
        }
        for (Class<?> nextType = newType; nextType != Object.class; nextType = nextType.getSuperclass()) {
            if (!nextType.isAssignableFrom(oldType)) continue;
            return nextType;
        }
        for (Class<?> nextInterface : ClassUtils.getAllInterfacesForClassAsSet(newType)) {
            if (!nextInterface.isAssignableFrom(oldType)) continue;
            return nextInterface;
        }
        return Object.class;
    }
}

