/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import java.util.List;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.TypeComparator;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelMessage;
import org.springframework.expression.spel.ast.Operator;
import org.springframework.expression.spel.ast.SpelNodeImpl;
import org.springframework.expression.spel.support.BooleanTypedValue;

public class OperatorBetween
extends Operator {
    public OperatorBetween(int startPos, int endPos, SpelNodeImpl ... operands) {
        super("between", startPos, endPos, operands);
    }

    @Override
    public BooleanTypedValue getValueInternal(ExpressionState state2) throws EvaluationException {
        List list2;
        Object left2 = this.getLeftOperand().getValueInternal(state2).getValue();
        Object right = this.getRightOperand().getValueInternal(state2).getValue();
        if (!(right instanceof List) || (list2 = (List)right).size() != 2) {
            throw new SpelEvaluationException(this.getRightOperand().getStartPosition(), SpelMessage.BETWEEN_RIGHT_OPERAND_MUST_BE_TWO_ELEMENT_LIST, new Object[0]);
        }
        Object low = list2.get(0);
        Object high = list2.get(1);
        TypeComparator comp = state2.getTypeComparator();
        try {
            return BooleanTypedValue.forValue(comp.compare(left2, low) >= 0 && comp.compare(left2, high) <= 0);
        }
        catch (SpelEvaluationException ex) {
            ex.setPosition(this.getStartPosition());
            throw ex;
        }
    }
}

