/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.springframework.asm.MethodVisitor;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.Operation;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.CodeFlow;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.ast.Literal;
import org.springframework.expression.spel.ast.Operator;
import org.springframework.expression.spel.ast.SpelNodeImpl;
import org.springframework.util.Assert;
import org.springframework.util.NumberUtils;

public class OpMinus
extends Operator {
    public OpMinus(int startPos, int endPos, SpelNodeImpl ... operands) {
        super("-", startPos, endPos, operands);
    }

    public boolean isNegativeNumberLiteral() {
        Literal literal;
        SpelNodeImpl spelNodeImpl;
        return this.children.length == 1 && (spelNodeImpl = this.children[0]) instanceof Literal && (literal = (Literal)spelNodeImpl).isNumberLiteral();
    }

    @Override
    public TypedValue getValueInternal(ExpressionState state2) throws EvaluationException {
        SpelNodeImpl leftOp = this.getLeftOperand();
        if (this.children.length < 2) {
            Object operand = leftOp.getValueInternal(state2).getValue();
            if (operand instanceof Number) {
                Number number = (Number)operand;
                if (number instanceof BigDecimal) {
                    BigDecimal bigDecimal = (BigDecimal)number;
                    return new TypedValue(bigDecimal.negate());
                }
                if (number instanceof BigInteger) {
                    BigInteger bigInteger = (BigInteger)number;
                    return new TypedValue(bigInteger.negate());
                }
                if (number instanceof Double) {
                    this.exitTypeDescriptor = "D";
                    return new TypedValue(0.0 - number.doubleValue());
                }
                if (number instanceof Float) {
                    this.exitTypeDescriptor = "F";
                    return new TypedValue(Float.valueOf(0.0f - number.floatValue()));
                }
                if (number instanceof Long) {
                    this.exitTypeDescriptor = "J";
                    return new TypedValue(0L - number.longValue());
                }
                if (number instanceof Integer) {
                    this.exitTypeDescriptor = "I";
                    return new TypedValue(0 - number.intValue());
                }
                if (number instanceof Short) {
                    return new TypedValue(0 - number.shortValue());
                }
                if (number instanceof Byte) {
                    return new TypedValue(0 - number.byteValue());
                }
                return new TypedValue(0.0 - number.doubleValue());
            }
            return state2.operate(Operation.SUBTRACT, operand, null);
        }
        Object left2 = leftOp.getValueInternal(state2).getValue();
        Object right = this.getRightOperand().getValueInternal(state2).getValue();
        if (left2 instanceof Number) {
            Number leftNumber = (Number)left2;
            if (right instanceof Number) {
                Number rightNumber = (Number)right;
                if (leftNumber instanceof BigDecimal || rightNumber instanceof BigDecimal) {
                    BigDecimal leftBigDecimal = NumberUtils.convertNumberToTargetClass(leftNumber, BigDecimal.class);
                    BigDecimal rightBigDecimal = NumberUtils.convertNumberToTargetClass(rightNumber, BigDecimal.class);
                    return new TypedValue(leftBigDecimal.subtract(rightBigDecimal));
                }
                if (leftNumber instanceof Double || rightNumber instanceof Double) {
                    this.exitTypeDescriptor = "D";
                    return new TypedValue(leftNumber.doubleValue() - rightNumber.doubleValue());
                }
                if (leftNumber instanceof Float || rightNumber instanceof Float) {
                    this.exitTypeDescriptor = "F";
                    return new TypedValue(Float.valueOf(leftNumber.floatValue() - rightNumber.floatValue()));
                }
                if (leftNumber instanceof BigInteger || rightNumber instanceof BigInteger) {
                    BigInteger leftBigInteger = NumberUtils.convertNumberToTargetClass(leftNumber, BigInteger.class);
                    BigInteger rightBigInteger = NumberUtils.convertNumberToTargetClass(rightNumber, BigInteger.class);
                    return new TypedValue(leftBigInteger.subtract(rightBigInteger));
                }
                if (leftNumber instanceof Long || rightNumber instanceof Long) {
                    this.exitTypeDescriptor = "J";
                    return new TypedValue(leftNumber.longValue() - rightNumber.longValue());
                }
                if (CodeFlow.isIntegerForNumericOp(leftNumber) || CodeFlow.isIntegerForNumericOp(rightNumber)) {
                    this.exitTypeDescriptor = "I";
                    return new TypedValue(leftNumber.intValue() - rightNumber.intValue());
                }
                return new TypedValue(leftNumber.doubleValue() - rightNumber.doubleValue());
            }
        }
        if (left2 instanceof String) {
            String theString = (String)left2;
            if (right instanceof Integer) {
                Integer theInteger = (Integer)right;
                if (theString.length() == 1) {
                    return new TypedValue(Character.toString((char)(theString.charAt(0) - theInteger)));
                }
            }
        }
        return state2.operate(Operation.SUBTRACT, left2, right);
    }

    @Override
    public String toStringAST() {
        if (this.children.length < 2) {
            return "-" + this.getLeftOperand().toStringAST();
        }
        return super.toStringAST();
    }

    @Override
    public SpelNodeImpl getRightOperand() {
        if (this.children.length < 2) {
            throw new IllegalStateException("No right operand");
        }
        return this.children[1];
    }

    @Override
    public boolean isCompilable() {
        if (!this.getLeftOperand().isCompilable()) {
            return false;
        }
        if (this.children.length > 1 && !this.getRightOperand().isCompilable()) {
            return false;
        }
        return this.exitTypeDescriptor != null;
    }

    @Override
    public void generateCode(MethodVisitor mv, CodeFlow cf) {
        this.getLeftOperand().generateCode(mv, cf);
        String leftDesc = this.getLeftOperand().exitTypeDescriptor;
        String exitDesc = this.exitTypeDescriptor;
        Assert.state(exitDesc != null, "No exit type descriptor");
        char targetDesc = exitDesc.charAt(0);
        CodeFlow.insertNumericUnboxOrPrimitiveTypeCoercion(mv, leftDesc, targetDesc);
        if (this.children.length > 1) {
            cf.enterCompilationScope();
            this.getRightOperand().generateCode(mv, cf);
            String rightDesc = this.getRightOperand().exitTypeDescriptor;
            cf.exitCompilationScope();
            CodeFlow.insertNumericUnboxOrPrimitiveTypeCoercion(mv, rightDesc, targetDesc);
            switch (targetDesc) {
                case 'I': {
                    mv.visitInsn(100);
                    break;
                }
                case 'J': {
                    mv.visitInsn(101);
                    break;
                }
                case 'F': {
                    mv.visitInsn(102);
                    break;
                }
                case 'D': {
                    mv.visitInsn(103);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unrecognized exit type descriptor: '" + this.exitTypeDescriptor + "'");
                }
            }
        } else {
            switch (targetDesc) {
                case 'I': {
                    mv.visitInsn(116);
                    break;
                }
                case 'J': {
                    mv.visitInsn(117);
                    break;
                }
                case 'F': {
                    mv.visitInsn(118);
                    break;
                }
                case 'D': {
                    mv.visitInsn(119);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unrecognized exit type descriptor: '" + this.exitTypeDescriptor + "'");
                }
            }
        }
        cf.pushDescriptor(this.exitTypeDescriptor);
    }
}

