/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import org.springframework.asm.MethodVisitor;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.spel.CodeFlow;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.ast.Operator;
import org.springframework.expression.spel.ast.SpelNodeImpl;
import org.springframework.expression.spel.support.BooleanTypedValue;

public class OpEQ
extends Operator {
    public OpEQ(int startPos, int endPos, SpelNodeImpl ... operands) {
        super("==", startPos, endPos, operands);
        this.exitTypeDescriptor = "Z";
    }

    @Override
    public BooleanTypedValue getValueInternal(ExpressionState state2) throws EvaluationException {
        Object left2 = this.getLeftOperand().getValueInternal(state2).getValue();
        Object right = this.getRightOperand().getValueInternal(state2).getValue();
        this.leftActualDescriptor = CodeFlow.toDescriptorFromObject(left2);
        this.rightActualDescriptor = CodeFlow.toDescriptorFromObject(right);
        return BooleanTypedValue.forValue(OpEQ.equalityCheck(state2.getEvaluationContext(), left2, right));
    }

    @Override
    public boolean isCompilable() {
        SpelNodeImpl left2 = this.getLeftOperand();
        SpelNodeImpl right = this.getRightOperand();
        if (!left2.isCompilable() || !right.isCompilable()) {
            return false;
        }
        String leftDesc = left2.exitTypeDescriptor;
        String rightDesc = right.exitTypeDescriptor;
        Operator.DescriptorComparison dc = Operator.DescriptorComparison.checkNumericCompatibility(leftDesc, rightDesc, this.leftActualDescriptor, this.rightActualDescriptor);
        return !dc.areNumbers || dc.areCompatible;
    }

    @Override
    public void generateCode(MethodVisitor mv, CodeFlow cf) {
        cf.loadEvaluationContext(mv);
        String leftDesc = this.getLeftOperand().exitTypeDescriptor;
        String rightDesc = this.getRightOperand().exitTypeDescriptor;
        boolean leftPrim = CodeFlow.isPrimitive(leftDesc);
        boolean rightPrim = CodeFlow.isPrimitive(rightDesc);
        cf.enterCompilationScope();
        this.getLeftOperand().generateCode(mv, cf);
        cf.exitCompilationScope();
        if (leftPrim) {
            CodeFlow.insertBoxIfNecessary(mv, leftDesc.charAt(0));
        }
        cf.enterCompilationScope();
        this.getRightOperand().generateCode(mv, cf);
        cf.exitCompilationScope();
        if (rightPrim) {
            CodeFlow.insertBoxIfNecessary(mv, rightDesc.charAt(0));
        }
        String operatorClassName = Operator.class.getName().replace('.', '/');
        String evaluationContextClassName = EvaluationContext.class.getName().replace('.', '/');
        mv.visitMethodInsn(184, operatorClassName, "equalityCheck", "(L" + evaluationContextClassName + ";Ljava/lang/Object;Ljava/lang/Object;)Z", false);
        cf.pushDescriptor("Z");
    }
}

