/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.springframework.asm.MethodVisitor;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.CodeFlow;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelMessage;
import org.springframework.expression.spel.ast.AstUtils;
import org.springframework.expression.spel.ast.PropertyOrFieldReference;
import org.springframework.expression.spel.ast.SpelNodeImpl;
import org.springframework.expression.spel.ast.StringLiteral;
import org.springframework.expression.spel.ast.ValueRef;
import org.springframework.expression.spel.support.ReflectivePropertyAccessor;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class Indexer
extends SpelNodeImpl {
    @Nullable
    private String cachedReadName;
    @Nullable
    private Class<?> cachedReadTargetType;
    @Nullable
    private PropertyAccessor cachedReadAccessor;
    @Nullable
    private String cachedWriteName;
    @Nullable
    private Class<?> cachedWriteTargetType;
    @Nullable
    private PropertyAccessor cachedWriteAccessor;
    @Nullable
    private IndexedType indexedType;

    public Indexer(int startPos, int endPos, SpelNodeImpl expr) {
        super(startPos, endPos, expr);
    }

    @Override
    public TypedValue getValueInternal(ExpressionState state2) throws EvaluationException {
        return this.getValueRef(state2).getValue();
    }

    @Override
    public TypedValue setValueInternal(ExpressionState state2, Supplier<TypedValue> valueSupplier) throws EvaluationException {
        TypedValue typedValue = valueSupplier.get();
        this.getValueRef(state2).setValue(typedValue.getValue());
        return typedValue;
    }

    @Override
    public boolean isWritable(ExpressionState expressionState) throws SpelEvaluationException {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ValueRef getValueRef(ExpressionState state2) throws EvaluationException {
        TypedValue indexValue;
        Object index2;
        SpelNodeImpl spelNodeImpl;
        TypedValue context = state2.getActiveContextObject();
        Object target2 = context.getValue();
        TypeDescriptor targetDescriptor = context.getTypeDescriptor();
        if (target2 instanceof Map && (spelNodeImpl = this.children[0]) instanceof PropertyOrFieldReference) {
            PropertyOrFieldReference reference2 = (PropertyOrFieldReference)spelNodeImpl;
            index2 = reference2.getName();
            indexValue = new TypedValue(index2);
        } else {
            try {
                state2.pushActiveContextObject(state2.getRootContextObject());
                indexValue = this.children[0].getValueInternal(state2);
                index2 = indexValue.getValue();
                Assert.state(index2 != null, "No index");
            }
            finally {
                state2.popActiveContextObject();
            }
        }
        if (target2 == null) {
            throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.CANNOT_INDEX_INTO_NULL_VALUE, new Object[0]);
        }
        Assert.state(targetDescriptor != null, "No type descriptor");
        if (target2 instanceof Map) {
            Map map2 = (Map)target2;
            Object key2 = index2;
            if (targetDescriptor.getMapKeyTypeDescriptor() != null) {
                key2 = state2.convertValue(key2, targetDescriptor.getMapKeyTypeDescriptor());
            }
            this.indexedType = IndexedType.MAP;
            return new MapIndexingValueRef(state2.getTypeConverter(), map2, key2, targetDescriptor);
        }
        if (target2.getClass().isArray() || target2 instanceof Collection || target2 instanceof String) {
            int idx = (Integer)state2.convertValue(index2, TypeDescriptor.valueOf(Integer.class));
            if (target2.getClass().isArray()) {
                this.indexedType = IndexedType.ARRAY;
                return new ArrayIndexingValueRef(state2.getTypeConverter(), target2, idx, targetDescriptor);
            }
            if (target2 instanceof Collection) {
                Collection collection = (Collection)target2;
                if (target2 instanceof List) {
                    this.indexedType = IndexedType.LIST;
                }
                return new CollectionIndexingValueRef(collection, idx, targetDescriptor, state2.getTypeConverter(), state2.getConfiguration().isAutoGrowCollections(), state2.getConfiguration().getMaximumAutoGrowSize());
            }
            this.indexedType = IndexedType.STRING;
            return new StringIndexingValueRef((String)target2, idx, targetDescriptor);
        }
        TypeDescriptor valueType = indexValue.getTypeDescriptor();
        if (valueType != null && String.class == valueType.getType()) {
            this.indexedType = IndexedType.OBJECT;
            return new PropertyIndexingValueRef(target2, (String)index2, state2.getEvaluationContext(), targetDescriptor);
        }
        throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.INDEXING_NOT_SUPPORTED_FOR_TYPE, targetDescriptor);
    }

    @Override
    public boolean isCompilable() {
        if (this.indexedType == IndexedType.ARRAY) {
            return this.exitTypeDescriptor != null;
        }
        if (this.indexedType == IndexedType.LIST) {
            return this.children[0].isCompilable();
        }
        if (this.indexedType == IndexedType.MAP) {
            return this.children[0] instanceof PropertyOrFieldReference || this.children[0].isCompilable();
        }
        if (this.indexedType == IndexedType.OBJECT) {
            return this.cachedReadAccessor != null && this.cachedReadAccessor instanceof ReflectivePropertyAccessor.OptimalPropertyAccessor && this.getChild(0) instanceof StringLiteral;
        }
        return false;
    }

    @Override
    public void generateCode(MethodVisitor mv, CodeFlow cf) {
        String descriptor = cf.lastDescriptor();
        if (descriptor == null) {
            cf.loadTarget(mv);
        }
        SpelNodeImpl index2 = this.children[0];
        if (this.indexedType == IndexedType.ARRAY) {
            String exitTypeDescriptor = this.exitTypeDescriptor;
            Assert.state(exitTypeDescriptor != null, "Array not compilable without descriptor");
            int insn = switch (exitTypeDescriptor) {
                case "D" -> {
                    mv.visitTypeInsn(192, "[D");
                    yield 49;
                }
                case "F" -> {
                    mv.visitTypeInsn(192, "[F");
                    yield 48;
                }
                case "J" -> {
                    mv.visitTypeInsn(192, "[J");
                    yield 47;
                }
                case "I" -> {
                    mv.visitTypeInsn(192, "[I");
                    yield 46;
                }
                case "S" -> {
                    mv.visitTypeInsn(192, "[S");
                    yield 53;
                }
                case "B" -> {
                    mv.visitTypeInsn(192, "[B");
                    yield 51;
                }
                case "Z" -> {
                    mv.visitTypeInsn(192, "[Z");
                    yield 51;
                }
                case "C" -> {
                    mv.visitTypeInsn(192, "[C");
                    yield 52;
                }
                default -> {
                    mv.visitTypeInsn(192, "[" + exitTypeDescriptor + (CodeFlow.isPrimitiveArray(exitTypeDescriptor) ? "" : ";"));
                    yield 50;
                }
            };
            this.generateIndexCode(mv, cf, index2, Integer.TYPE);
            mv.visitInsn(insn);
        } else if (this.indexedType == IndexedType.LIST) {
            mv.visitTypeInsn(192, "java/util/List");
            this.generateIndexCode(mv, cf, index2, Integer.TYPE);
            mv.visitMethodInsn(185, "java/util/List", "get", "(I)Ljava/lang/Object;", true);
        } else if (this.indexedType == IndexedType.MAP) {
            mv.visitTypeInsn(192, "java/util/Map");
            if (index2 instanceof PropertyOrFieldReference) {
                PropertyOrFieldReference reference2 = (PropertyOrFieldReference)index2;
                String mapKeyName = reference2.getName();
                mv.visitLdcInsn(mapKeyName);
            } else {
                this.generateIndexCode(mv, cf, index2, Object.class);
            }
            mv.visitMethodInsn(185, "java/util/Map", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", true);
        } else if (this.indexedType == IndexedType.OBJECT) {
            ReflectivePropertyAccessor.OptimalPropertyAccessor accessor = (ReflectivePropertyAccessor.OptimalPropertyAccessor)this.cachedReadAccessor;
            Assert.state(accessor != null, "No cached read accessor");
            Member member = accessor.member;
            boolean isStatic = Modifier.isStatic(member.getModifiers());
            String classDesc = member.getDeclaringClass().getName().replace('.', '/');
            if (!isStatic) {
                if (descriptor == null) {
                    cf.loadTarget(mv);
                }
                if (descriptor == null || !classDesc.equals(descriptor.substring(1))) {
                    mv.visitTypeInsn(192, classDesc);
                }
            }
            if (member instanceof Method) {
                Method method2 = (Method)member;
                mv.visitMethodInsn(isStatic ? 184 : 182, classDesc, member.getName(), CodeFlow.createSignatureDescriptor(method2), false);
            } else {
                mv.visitFieldInsn(isStatic ? 178 : 180, classDesc, member.getName(), CodeFlow.toJvmDescriptor(((Field)member).getType()));
            }
        }
        cf.pushDescriptor(this.exitTypeDescriptor);
    }

    private void generateIndexCode(MethodVisitor mv, CodeFlow cf, SpelNodeImpl indexNode, Class<?> indexType) {
        String indexDesc = CodeFlow.toDescriptor(indexType);
        Indexer.generateCodeForArgument(mv, cf, indexNode, indexDesc);
    }

    @Override
    public String toStringAST() {
        return "[" + this.getChild(0).toStringAST() + "]";
    }

    private void setArrayElement(TypeConverter converter, Object ctx, int idx, @Nullable Object newValue, Class<?> arrayComponentType) throws EvaluationException {
        if (arrayComponentType == Boolean.TYPE) {
            boolean[] array2 = (boolean[])ctx;
            this.checkAccess(array2.length, idx);
            array2[idx] = this.convertValue(converter, newValue, Boolean.TYPE);
        } else if (arrayComponentType == Byte.TYPE) {
            byte[] array3 = (byte[])ctx;
            this.checkAccess(array3.length, idx);
            array3[idx] = this.convertValue(converter, newValue, Byte.TYPE);
        } else if (arrayComponentType == Character.TYPE) {
            char[] array4 = (char[])ctx;
            this.checkAccess(array4.length, idx);
            array4[idx] = this.convertValue(converter, newValue, Character.TYPE).charValue();
        } else if (arrayComponentType == Double.TYPE) {
            double[] array5 = (double[])ctx;
            this.checkAccess(array5.length, idx);
            array5[idx] = this.convertValue(converter, newValue, Double.TYPE);
        } else if (arrayComponentType == Float.TYPE) {
            float[] array6 = (float[])ctx;
            this.checkAccess(array6.length, idx);
            array6[idx] = this.convertValue(converter, newValue, Float.TYPE).floatValue();
        } else if (arrayComponentType == Integer.TYPE) {
            int[] array7 = (int[])ctx;
            this.checkAccess(array7.length, idx);
            array7[idx] = this.convertValue(converter, newValue, Integer.TYPE);
        } else if (arrayComponentType == Long.TYPE) {
            long[] array8 = (long[])ctx;
            this.checkAccess(array8.length, idx);
            array8[idx] = this.convertValue(converter, newValue, Long.TYPE);
        } else if (arrayComponentType == Short.TYPE) {
            short[] array9 = (short[])ctx;
            this.checkAccess(array9.length, idx);
            array9[idx] = this.convertValue(converter, newValue, Short.TYPE);
        } else {
            Object[] array10 = (Object[])ctx;
            this.checkAccess(array10.length, idx);
            array10[idx] = this.convertValue(converter, newValue, arrayComponentType);
        }
    }

    private Object accessArrayElement(Object ctx, int idx) throws SpelEvaluationException {
        TypeDescriptor.OfField arrayComponentType = ctx.getClass().componentType();
        if (arrayComponentType == Boolean.TYPE) {
            boolean[] array2 = (boolean[])ctx;
            this.checkAccess(array2.length, idx);
            this.exitTypeDescriptor = "Z";
            return array2[idx];
        }
        if (arrayComponentType == Byte.TYPE) {
            byte[] array3 = (byte[])ctx;
            this.checkAccess(array3.length, idx);
            this.exitTypeDescriptor = "B";
            return array3[idx];
        }
        if (arrayComponentType == Character.TYPE) {
            char[] array4 = (char[])ctx;
            this.checkAccess(array4.length, idx);
            this.exitTypeDescriptor = "C";
            return Character.valueOf(array4[idx]);
        }
        if (arrayComponentType == Double.TYPE) {
            double[] array5 = (double[])ctx;
            this.checkAccess(array5.length, idx);
            this.exitTypeDescriptor = "D";
            return array5[idx];
        }
        if (arrayComponentType == Float.TYPE) {
            float[] array6 = (float[])ctx;
            this.checkAccess(array6.length, idx);
            this.exitTypeDescriptor = "F";
            return Float.valueOf(array6[idx]);
        }
        if (arrayComponentType == Integer.TYPE) {
            int[] array7 = (int[])ctx;
            this.checkAccess(array7.length, idx);
            this.exitTypeDescriptor = "I";
            return array7[idx];
        }
        if (arrayComponentType == Long.TYPE) {
            long[] array8 = (long[])ctx;
            this.checkAccess(array8.length, idx);
            this.exitTypeDescriptor = "J";
            return array8[idx];
        }
        if (arrayComponentType == Short.TYPE) {
            short[] array9 = (short[])ctx;
            this.checkAccess(array9.length, idx);
            this.exitTypeDescriptor = "S";
            return array9[idx];
        }
        Object[] array10 = (Object[])ctx;
        this.checkAccess(array10.length, idx);
        Object retValue = array10[idx];
        this.exitTypeDescriptor = CodeFlow.toDescriptor(arrayComponentType);
        return retValue;
    }

    private void checkAccess(int arrayLength, int index2) throws SpelEvaluationException {
        if (index2 >= arrayLength) {
            throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.ARRAY_INDEX_OUT_OF_BOUNDS, arrayLength, index2);
        }
    }

    private <T> T convertValue(TypeConverter converter, @Nullable Object value2, Class<T> targetType) {
        Object result2 = converter.convertValue(value2, TypeDescriptor.forObject(value2), TypeDescriptor.valueOf(targetType));
        if (result2 == null) {
            throw new IllegalStateException("Null conversion result for index [" + value2 + "]");
        }
        return (T)result2;
    }

    private static enum IndexedType {
        ARRAY,
        LIST,
        MAP,
        STRING,
        OBJECT;

    }

    private class MapIndexingValueRef
    implements ValueRef {
        private final TypeConverter typeConverter;
        private final Map map;
        @Nullable
        private final Object key;
        private final TypeDescriptor mapEntryDescriptor;

        public MapIndexingValueRef(TypeConverter typeConverter, @Nullable Map map2, Object key2, TypeDescriptor mapEntryDescriptor) {
            this.typeConverter = typeConverter;
            this.map = map2;
            this.key = key2;
            this.mapEntryDescriptor = mapEntryDescriptor;
        }

        @Override
        public TypedValue getValue() {
            Object value2 = this.map.get(this.key);
            Indexer.this.exitTypeDescriptor = CodeFlow.toDescriptor(Object.class);
            return new TypedValue(value2, this.mapEntryDescriptor.getMapValueTypeDescriptor(value2));
        }

        @Override
        public void setValue(@Nullable Object newValue) {
            if (this.mapEntryDescriptor.getMapValueTypeDescriptor() != null) {
                newValue = this.typeConverter.convertValue(newValue, TypeDescriptor.forObject(newValue), this.mapEntryDescriptor.getMapValueTypeDescriptor());
            }
            this.map.put(this.key, newValue);
        }

        @Override
        public boolean isWritable() {
            return true;
        }
    }

    private class ArrayIndexingValueRef
    implements ValueRef {
        private final TypeConverter typeConverter;
        private final Object array;
        private final int index;
        private final TypeDescriptor typeDescriptor;

        ArrayIndexingValueRef(TypeConverter typeConverter, Object array2, int index2, TypeDescriptor typeDescriptor) {
            this.typeConverter = typeConverter;
            this.array = array2;
            this.index = index2;
            this.typeDescriptor = typeDescriptor;
        }

        @Override
        public TypedValue getValue() {
            Object arrayElement = Indexer.this.accessArrayElement(this.array, this.index);
            return new TypedValue(arrayElement, this.typeDescriptor.elementTypeDescriptor(arrayElement));
        }

        @Override
        public void setValue(@Nullable Object newValue) {
            TypeDescriptor elementType = this.typeDescriptor.getElementTypeDescriptor();
            Assert.state(elementType != null, "No element type");
            Indexer.this.setArrayElement(this.typeConverter, this.array, this.index, newValue, elementType.getType());
        }

        @Override
        public boolean isWritable() {
            return true;
        }
    }

    private class CollectionIndexingValueRef
    implements ValueRef {
        private final Collection collection;
        private final int index;
        private final TypeDescriptor collectionEntryDescriptor;
        private final TypeConverter typeConverter;
        private final boolean growCollection;
        private final int maximumSize;

        public CollectionIndexingValueRef(Collection collection, int index2, TypeDescriptor collectionEntryDescriptor, TypeConverter typeConverter, boolean growCollection, int maximumSize) {
            this.collection = collection;
            this.index = index2;
            this.collectionEntryDescriptor = collectionEntryDescriptor;
            this.typeConverter = typeConverter;
            this.growCollection = growCollection;
            this.maximumSize = maximumSize;
        }

        @Override
        public TypedValue getValue() {
            this.growCollectionIfNecessary();
            Collection collection = this.collection;
            if (collection instanceof List) {
                List list2 = (List)collection;
                Object o = list2.get(this.index);
                Indexer.this.exitTypeDescriptor = CodeFlow.toDescriptor(Object.class);
                return new TypedValue(o, this.collectionEntryDescriptor.elementTypeDescriptor(o));
            }
            int pos2 = 0;
            for (Object o : this.collection) {
                if (pos2 == this.index) {
                    return new TypedValue(o, this.collectionEntryDescriptor.elementTypeDescriptor(o));
                }
                ++pos2;
            }
            throw new IllegalStateException("Failed to find indexed element " + this.index + ": " + this.collection);
        }

        @Override
        public void setValue(@Nullable Object newValue) {
            List list2;
            this.growCollectionIfNecessary();
            Collection collection = this.collection;
            if (collection instanceof List) {
                list2 = (List)collection;
                if (this.collectionEntryDescriptor.getElementTypeDescriptor() != null) {
                    newValue = this.typeConverter.convertValue(newValue, TypeDescriptor.forObject(newValue), this.collectionEntryDescriptor.getElementTypeDescriptor());
                }
            } else {
                throw new SpelEvaluationException(Indexer.this.getStartPosition(), SpelMessage.INDEXING_NOT_SUPPORTED_FOR_TYPE, this.collectionEntryDescriptor.toString());
            }
            list2.set(this.index, newValue);
        }

        private void growCollectionIfNecessary() {
            if (this.index >= this.collection.size()) {
                if (!this.growCollection) {
                    throw new SpelEvaluationException(Indexer.this.getStartPosition(), SpelMessage.COLLECTION_INDEX_OUT_OF_BOUNDS, this.collection.size(), this.index);
                }
                if (this.index >= this.maximumSize) {
                    throw new SpelEvaluationException(Indexer.this.getStartPosition(), SpelMessage.UNABLE_TO_GROW_COLLECTION, new Object[0]);
                }
                if (this.collectionEntryDescriptor.getElementTypeDescriptor() == null) {
                    throw new SpelEvaluationException(Indexer.this.getStartPosition(), SpelMessage.UNABLE_TO_GROW_COLLECTION_UNKNOWN_ELEMENT_TYPE, new Object[0]);
                }
                TypeDescriptor elementType = this.collectionEntryDescriptor.getElementTypeDescriptor();
                try {
                    Constructor<?> ctor = this.getDefaultConstructor(elementType.getType());
                    for (int newElements = this.index - this.collection.size(); newElements >= 0; --newElements) {
                        this.collection.add(ctor != null ? (Object)ctor.newInstance(new Object[0]) : null);
                    }
                }
                catch (Throwable ex) {
                    throw new SpelEvaluationException(Indexer.this.getStartPosition(), ex, SpelMessage.UNABLE_TO_GROW_COLLECTION, new Object[0]);
                }
            }
        }

        @Nullable
        private Constructor<?> getDefaultConstructor(Class<?> type2) {
            try {
                return ReflectionUtils.accessibleConstructor(type2, new Class[0]);
            }
            catch (Throwable ex) {
                return null;
            }
        }

        @Override
        public boolean isWritable() {
            return true;
        }
    }

    private class StringIndexingValueRef
    implements ValueRef {
        private final String target;
        private final int index;
        private final TypeDescriptor typeDescriptor;

        public StringIndexingValueRef(String target2, int index2, TypeDescriptor typeDescriptor) {
            this.target = target2;
            this.index = index2;
            this.typeDescriptor = typeDescriptor;
        }

        @Override
        public TypedValue getValue() {
            if (this.index >= this.target.length()) {
                throw new SpelEvaluationException(Indexer.this.getStartPosition(), SpelMessage.STRING_INDEX_OUT_OF_BOUNDS, this.target.length(), this.index);
            }
            return new TypedValue(String.valueOf(this.target.charAt(this.index)));
        }

        @Override
        public void setValue(@Nullable Object newValue) {
            throw new SpelEvaluationException(Indexer.this.getStartPosition(), SpelMessage.INDEXING_NOT_SUPPORTED_FOR_TYPE, this.typeDescriptor.toString());
        }

        @Override
        public boolean isWritable() {
            return true;
        }
    }

    private class PropertyIndexingValueRef
    implements ValueRef {
        private final Object targetObject;
        private final String name;
        private final EvaluationContext evaluationContext;
        private final TypeDescriptor targetObjectTypeDescriptor;

        public PropertyIndexingValueRef(Object targetObject, String value2, EvaluationContext evaluationContext, TypeDescriptor targetObjectTypeDescriptor) {
            this.targetObject = targetObject;
            this.name = value2;
            this.evaluationContext = evaluationContext;
            this.targetObjectTypeDescriptor = targetObjectTypeDescriptor;
        }

        @Override
        public TypedValue getValue() {
            Class<?> targetObjectRuntimeClass = Indexer.this.getObjectClass(this.targetObject);
            try {
                if (Indexer.this.cachedReadName != null && Indexer.this.cachedReadName.equals(this.name) && Indexer.this.cachedReadTargetType != null && Indexer.this.cachedReadTargetType.equals(targetObjectRuntimeClass)) {
                    PropertyAccessor accessor = Indexer.this.cachedReadAccessor;
                    Assert.state(accessor != null, "No cached read accessor");
                    return accessor.read(this.evaluationContext, this.targetObject, this.name);
                }
                List<PropertyAccessor> accessorsToTry = AstUtils.getPropertyAccessorsToTry(targetObjectRuntimeClass, this.evaluationContext.getPropertyAccessors());
                for (PropertyAccessor accessor : accessorsToTry) {
                    if (!accessor.canRead(this.evaluationContext, this.targetObject, this.name)) continue;
                    if (accessor instanceof ReflectivePropertyAccessor) {
                        ReflectivePropertyAccessor reflectivePropertyAccessor = (ReflectivePropertyAccessor)accessor;
                        accessor = reflectivePropertyAccessor.createOptimalAccessor(this.evaluationContext, this.targetObject, this.name);
                    }
                    Indexer.this.cachedReadAccessor = accessor;
                    Indexer.this.cachedReadName = this.name;
                    Indexer.this.cachedReadTargetType = targetObjectRuntimeClass;
                    if (accessor instanceof ReflectivePropertyAccessor.OptimalPropertyAccessor) {
                        Class<?> clazz;
                        ReflectivePropertyAccessor.OptimalPropertyAccessor optimalAccessor = (ReflectivePropertyAccessor.OptimalPropertyAccessor)accessor;
                        Member member = optimalAccessor.member;
                        if (member instanceof Method) {
                            Method method2 = (Method)member;
                            clazz = method2.getReturnType();
                        } else {
                            clazz = ((Field)member).getType();
                        }
                        Indexer.this.exitTypeDescriptor = CodeFlow.toDescriptor(clazz);
                    }
                    return accessor.read(this.evaluationContext, this.targetObject, this.name);
                }
            }
            catch (AccessException ex) {
                throw new SpelEvaluationException(Indexer.this.getStartPosition(), (Throwable)ex, SpelMessage.INDEXING_NOT_SUPPORTED_FOR_TYPE, this.targetObjectTypeDescriptor.toString());
            }
            throw new SpelEvaluationException(Indexer.this.getStartPosition(), SpelMessage.INDEXING_NOT_SUPPORTED_FOR_TYPE, this.targetObjectTypeDescriptor.toString());
        }

        @Override
        public void setValue(@Nullable Object newValue) {
            Class<?> contextObjectClass = Indexer.this.getObjectClass(this.targetObject);
            try {
                if (Indexer.this.cachedWriteName != null && Indexer.this.cachedWriteName.equals(this.name) && Indexer.this.cachedWriteTargetType != null && Indexer.this.cachedWriteTargetType.equals(contextObjectClass)) {
                    PropertyAccessor accessor = Indexer.this.cachedWriteAccessor;
                    Assert.state(accessor != null, "No cached write accessor");
                    accessor.write(this.evaluationContext, this.targetObject, this.name, newValue);
                    return;
                }
                List<PropertyAccessor> accessorsToTry = AstUtils.getPropertyAccessorsToTry(contextObjectClass, this.evaluationContext.getPropertyAccessors());
                for (PropertyAccessor accessor : accessorsToTry) {
                    if (!accessor.canWrite(this.evaluationContext, this.targetObject, this.name)) continue;
                    Indexer.this.cachedWriteName = this.name;
                    Indexer.this.cachedWriteTargetType = contextObjectClass;
                    Indexer.this.cachedWriteAccessor = accessor;
                    accessor.write(this.evaluationContext, this.targetObject, this.name, newValue);
                    return;
                }
            }
            catch (AccessException ex) {
                throw new SpelEvaluationException(Indexer.this.getStartPosition(), (Throwable)ex, SpelMessage.EXCEPTION_DURING_PROPERTY_WRITE, this.name, ex.getMessage());
            }
            throw new SpelEvaluationException(Indexer.this.getStartPosition(), SpelMessage.INDEXING_NOT_SUPPORTED_FOR_TYPE, this.targetObjectTypeDescriptor.toString());
        }

        @Override
        public boolean isWritable() {
            return true;
        }
    }
}

