/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.StringJoiner;
import org.springframework.asm.MethodVisitor;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.CodeFlow;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelMessage;
import org.springframework.expression.spel.ast.SpelNodeImpl;
import org.springframework.expression.spel.support.ReflectionHelper;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class FunctionReference
extends SpelNodeImpl {
    private final String name;
    @Nullable
    private volatile Method method;

    public FunctionReference(String functionName, int startPos, int endPos, SpelNodeImpl ... arguments) {
        super(startPos, endPos, arguments);
        this.name = functionName;
    }

    @Override
    public TypedValue getValueInternal(ExpressionState state2) throws EvaluationException {
        TypedValue value2 = state2.lookupVariable(this.name);
        if (value2 == TypedValue.NULL) {
            throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.FUNCTION_NOT_DEFINED, this.name);
        }
        Object function = value2.getValue();
        if (function instanceof Method) {
            Method javaMethod = (Method)function;
            try {
                return this.executeFunctionViaMethod(state2, javaMethod);
            }
            catch (SpelEvaluationException ex) {
                ex.setPosition(this.getStartPosition());
                throw ex;
            }
        }
        if (function instanceof MethodHandle) {
            MethodHandle methodHandle = (MethodHandle)function;
            try {
                return this.executeFunctionViaMethodHandle(state2, methodHandle);
            }
            catch (SpelEvaluationException ex) {
                ex.setPosition(this.getStartPosition());
                throw ex;
            }
        }
        throw new SpelEvaluationException(SpelMessage.FUNCTION_REFERENCE_CANNOT_BE_INVOKED, this.name, value2.getClass());
    }

    private TypedValue executeFunctionViaMethod(ExpressionState state2, Method method2) throws EvaluationException {
        int declaredParamCount;
        Object[] functionArgs = this.getArguments(state2);
        if (!method2.isVarArgs() && (declaredParamCount = method2.getParameterCount()) != functionArgs.length) {
            throw new SpelEvaluationException(SpelMessage.INCORRECT_NUMBER_OF_ARGUMENTS_TO_FUNCTION, this.name, functionArgs.length, declaredParamCount);
        }
        if (!Modifier.isStatic(method2.getModifiers())) {
            throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.FUNCTION_MUST_BE_STATIC, ClassUtils.getQualifiedMethodName(method2), this.name);
        }
        TypeConverter converter = state2.getEvaluationContext().getTypeConverter();
        boolean argumentConversionOccurred = ReflectionHelper.convertAllArguments(converter, functionArgs, method2);
        if (method2.isVarArgs()) {
            functionArgs = ReflectionHelper.setupArgumentsForVarargsInvocation(method2.getParameterTypes(), functionArgs);
        }
        boolean compilable = false;
        try {
            ReflectionUtils.makeAccessible(method2);
            Object result2 = method2.invoke(method2.getClass(), functionArgs);
            compilable = !argumentConversionOccurred;
            TypedValue typedValue = new TypedValue(result2, new TypeDescriptor(new MethodParameter(method2, -1)).narrow(result2));
            return typedValue;
        }
        catch (Exception ex) {
            throw new SpelEvaluationException(this.getStartPosition(), (Throwable)ex, SpelMessage.EXCEPTION_DURING_FUNCTION_CALL, this.name, ex.getMessage());
        }
        finally {
            if (compilable) {
                this.exitTypeDescriptor = CodeFlow.toDescriptor(method2.getReturnType());
                this.method = method2;
            } else {
                this.exitTypeDescriptor = null;
                this.method = null;
            }
        }
    }

    private TypedValue executeFunctionViaMethodHandle(ExpressionState state2, MethodHandle methodHandle) throws EvaluationException {
        Object[] functionArgs = this.getArguments(state2);
        MethodType declaredParams = methodHandle.type();
        int spelParamCount = functionArgs.length;
        int declaredParamCount = declaredParams.parameterCount();
        boolean isSuspectedVarargs = declaredParams.lastParameterType().isArray();
        if (isSuspectedVarargs) {
            if (spelParamCount < declaredParamCount - 1) {
                throw new SpelEvaluationException(SpelMessage.INCORRECT_NUMBER_OF_ARGUMENTS_TO_FUNCTION, this.name, spelParamCount, declaredParamCount - 1 + " or more");
            }
        } else if (spelParamCount != declaredParamCount) {
            throw new SpelEvaluationException(SpelMessage.INCORRECT_NUMBER_OF_ARGUMENTS_TO_FUNCTION, this.name, spelParamCount, declaredParamCount);
        }
        if (declaredParamCount == 0) {
            try {
                TypedValue typedValue = new TypedValue(methodHandle.invoke());
                return typedValue;
            }
            catch (Throwable ex) {
                throw new SpelEvaluationException(this.getStartPosition(), ex, SpelMessage.EXCEPTION_DURING_FUNCTION_CALL, this.name, ex.getMessage());
            }
            finally {
                this.exitTypeDescriptor = null;
                this.method = null;
            }
        }
        Integer varArgPosition = null;
        if (isSuspectedVarargs) {
            varArgPosition = declaredParamCount - 1;
        }
        TypeConverter converter = state2.getEvaluationContext().getTypeConverter();
        ReflectionHelper.convertAllMethodHandleArguments(converter, functionArgs, methodHandle, varArgPosition);
        if (isSuspectedVarargs) {
            Object object;
            int actualVarargsIndex;
            if (declaredParamCount == 1) {
                functionArgs = ReflectionHelper.setupArgumentsForVarargsInvocation(methodHandle.type().parameterArray(), functionArgs);
            } else if (spelParamCount == declaredParamCount && (actualVarargsIndex = functionArgs.length - 1) >= 0 && (object = functionArgs[actualVarargsIndex]) instanceof Object[]) {
                Object[] argsToUnpack = (Object[])object;
                Object[] newArgs = new Object[actualVarargsIndex + argsToUnpack.length];
                System.arraycopy(functionArgs, 0, newArgs, 0, actualVarargsIndex);
                System.arraycopy(argsToUnpack, 0, newArgs, actualVarargsIndex, argsToUnpack.length);
                functionArgs = newArgs;
            }
        }
        try {
            TypedValue actualVarargsIndex = new TypedValue(methodHandle.invokeWithArguments(functionArgs));
            return actualVarargsIndex;
        }
        catch (Throwable ex) {
            throw new SpelEvaluationException(this.getStartPosition(), ex, SpelMessage.EXCEPTION_DURING_FUNCTION_CALL, this.name, ex.getMessage());
        }
        finally {
            this.exitTypeDescriptor = null;
            this.method = null;
        }
    }

    @Override
    public String toStringAST() {
        StringJoiner sj = new StringJoiner(",", "(", ")");
        for (int i2 = 0; i2 < this.getChildCount(); ++i2) {
            sj.add(this.getChild(i2).toStringAST());
        }
        return "#" + this.name + sj;
    }

    private Object[] getArguments(ExpressionState state2) throws EvaluationException {
        Object[] arguments = new Object[this.getChildCount()];
        for (int i2 = 0; i2 < arguments.length; ++i2) {
            arguments[i2] = this.children[i2].getValueInternal(state2).getValue();
        }
        return arguments;
    }

    @Override
    public boolean isCompilable() {
        Method method2 = this.method;
        if (method2 == null) {
            return false;
        }
        int methodModifiers = method2.getModifiers();
        if (!(Modifier.isStatic(methodModifiers) && Modifier.isPublic(methodModifiers) && Modifier.isPublic(method2.getDeclaringClass().getModifiers()))) {
            return false;
        }
        for (SpelNodeImpl child : this.children) {
            if (child.isCompilable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void generateCode(MethodVisitor mv, CodeFlow cf) {
        Method method2 = this.method;
        Assert.state(method2 != null, "No method handle");
        String classDesc = method2.getDeclaringClass().getName().replace('.', '/');
        FunctionReference.generateCodeForArguments(mv, cf, method2, this.children);
        mv.visitMethodInsn(184, classDesc, method2.getName(), CodeFlow.createSignatureDescriptor(method2), false);
        cf.pushDescriptor(this.exitTypeDescriptor);
    }
}

