/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import org.springframework.asm.MethodVisitor;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.AccessException;
import org.springframework.expression.ConstructorExecutor;
import org.springframework.expression.ConstructorResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.TypedValue;
import org.springframework.expression.common.ExpressionUtils;
import org.springframework.expression.spel.CodeFlow;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelMessage;
import org.springframework.expression.spel.ast.FormatHelper;
import org.springframework.expression.spel.ast.InlineList;
import org.springframework.expression.spel.ast.SpelNodeImpl;
import org.springframework.expression.spel.ast.TypeCode;
import org.springframework.expression.spel.support.ReflectiveConstructorExecutor;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class ConstructorReference
extends SpelNodeImpl {
    private static final int MAX_ARRAY_ELEMENTS = 262144;
    private final boolean isArrayConstructor;
    @Nullable
    private final SpelNodeImpl[] dimensions;
    @Nullable
    private volatile ConstructorExecutor cachedExecutor;

    public ConstructorReference(int startPos, int endPos, SpelNodeImpl ... arguments) {
        super(startPos, endPos, arguments);
        this.isArrayConstructor = false;
        this.dimensions = null;
    }

    public ConstructorReference(int startPos, int endPos, SpelNodeImpl[] dimensions2, SpelNodeImpl ... arguments) {
        super(startPos, endPos, arguments);
        this.isArrayConstructor = true;
        this.dimensions = dimensions2;
    }

    @Override
    public TypedValue getValueInternal(ExpressionState state2) throws EvaluationException {
        if (this.isArrayConstructor) {
            return this.createArray(state2);
        }
        return this.createNewInstance(state2);
    }

    private TypedValue createNewInstance(ExpressionState state2) throws EvaluationException {
        String typeName;
        Object[] arguments = new Object[this.getChildCount() - 1];
        ArrayList<TypeDescriptor> argumentTypes = new ArrayList<TypeDescriptor>(this.getChildCount() - 1);
        for (int i2 = 0; i2 < arguments.length; ++i2) {
            Object value2;
            TypedValue childValue = this.children[i2 + 1].getValueInternal(state2);
            arguments[i2] = value2 = childValue.getValue();
            argumentTypes.add(TypeDescriptor.forObject(value2));
        }
        ConstructorExecutor executorToUse = this.cachedExecutor;
        if (executorToUse != null) {
            try {
                return executorToUse.execute(state2.getEvaluationContext(), arguments);
            }
            catch (AccessException ex) {
                Throwable throwable = ex.getCause();
                if (throwable instanceof InvocationTargetException) {
                    InvocationTargetException cause2 = (InvocationTargetException)throwable;
                    Throwable rootCause = cause2.getCause();
                    if (rootCause instanceof RuntimeException) {
                        RuntimeException runtimeException = (RuntimeException)rootCause;
                        throw runtimeException;
                    }
                    String typeName2 = (String)this.children[0].getValueInternal(state2).getValue();
                    throw new SpelEvaluationException(this.getStartPosition(), rootCause, SpelMessage.CONSTRUCTOR_INVOCATION_PROBLEM, typeName2, FormatHelper.formatMethodForMessage("", argumentTypes));
                }
                this.cachedExecutor = null;
            }
        }
        Assert.state((typeName = (String)this.children[0].getValueInternal(state2).getValue()) != null, "No type name");
        executorToUse = this.findExecutorForConstructor(typeName, argumentTypes, state2);
        try {
            this.cachedExecutor = executorToUse;
            if (executorToUse instanceof ReflectiveConstructorExecutor) {
                ReflectiveConstructorExecutor reflectiveConstructorExecutor = (ReflectiveConstructorExecutor)executorToUse;
                this.exitTypeDescriptor = CodeFlow.toDescriptor(reflectiveConstructorExecutor.getConstructor().getDeclaringClass());
            }
            return executorToUse.execute(state2.getEvaluationContext(), arguments);
        }
        catch (AccessException ex) {
            throw new SpelEvaluationException(this.getStartPosition(), (Throwable)ex, SpelMessage.CONSTRUCTOR_INVOCATION_PROBLEM, typeName, FormatHelper.formatMethodForMessage("", argumentTypes));
        }
    }

    private ConstructorExecutor findExecutorForConstructor(String typeName, List<TypeDescriptor> argumentTypes, ExpressionState state2) throws SpelEvaluationException {
        EvaluationContext evalContext = state2.getEvaluationContext();
        List<ConstructorResolver> ctorResolvers = evalContext.getConstructorResolvers();
        for (ConstructorResolver ctorResolver : ctorResolvers) {
            try {
                ConstructorExecutor ce = ctorResolver.resolve(state2.getEvaluationContext(), typeName, argumentTypes);
                if (ce == null) continue;
                return ce;
            }
            catch (AccessException ex) {
                throw new SpelEvaluationException(this.getStartPosition(), (Throwable)ex, SpelMessage.CONSTRUCTOR_INVOCATION_PROBLEM, typeName, FormatHelper.formatMethodForMessage("", argumentTypes));
            }
        }
        throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.CONSTRUCTOR_NOT_FOUND, typeName, FormatHelper.formatMethodForMessage("", argumentTypes));
    }

    @Override
    public String toStringAST() {
        StringBuilder sb = new StringBuilder("new ");
        sb.append(this.getChild(0).toStringAST());
        if (this.isArrayConstructor) {
            if (this.hasInitializer()) {
                InlineList initializer = (InlineList)this.getChild(1);
                sb.append("[] ").append(initializer.toStringAST());
            } else if (this.dimensions != null) {
                for (SpelNodeImpl dimension : this.dimensions) {
                    sb.append('[').append(dimension.toStringAST()).append(']');
                }
            }
        } else {
            StringJoiner sj = new StringJoiner(",", "(", ")");
            int count2 = this.getChildCount();
            for (int i2 = 1; i2 < count2; ++i2) {
                sj.add(this.getChild(i2).toStringAST());
            }
            sb.append(sj.toString());
        }
        return sb.toString();
    }

    private TypedValue createArray(ExpressionState state2) throws EvaluationException {
        Object intendedArrayType = this.getChild(0).getValue(state2);
        if (!(intendedArrayType instanceof String)) {
            throw new SpelEvaluationException(this.getChild(0).getStartPosition(), SpelMessage.TYPE_NAME_EXPECTED_FOR_ARRAY_CONSTRUCTION, FormatHelper.formatClassNameForMessage(intendedArrayType != null ? intendedArrayType.getClass() : null));
        }
        String type2 = (String)intendedArrayType;
        if (state2.getEvaluationContext().getConstructorResolvers().isEmpty()) {
            throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.CONSTRUCTOR_NOT_FOUND, type2 + "[]", "[]");
        }
        TypeCode arrayTypeCode = TypeCode.forName(type2);
        Class<?> componentType = arrayTypeCode == TypeCode.OBJECT ? state2.findType(type2) : arrayTypeCode.getType();
        Object newArray = null;
        if (!this.hasInitializer()) {
            if (this.dimensions != null) {
                for (SpelNodeImpl dimension : this.dimensions) {
                    if (dimension != null) continue;
                    throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.MISSING_ARRAY_DIMENSION, new Object[0]);
                }
                TypeConverter typeConverter = state2.getEvaluationContext().getTypeConverter();
                if (this.dimensions.length == 1) {
                    TypedValue o = this.dimensions[0].getTypedValue(state2);
                    int arraySize = ExpressionUtils.toInt(typeConverter, o);
                    this.checkNumElements(arraySize);
                    newArray = Array.newInstance(componentType, arraySize);
                } else {
                    int[] dims = new int[this.dimensions.length];
                    long numElements = 1L;
                    for (int d = 0; d < this.dimensions.length; ++d) {
                        int arraySize;
                        TypedValue o = this.dimensions[d].getTypedValue(state2);
                        dims[d] = arraySize = ExpressionUtils.toInt(typeConverter, o);
                        this.checkNumElements(numElements *= (long)arraySize);
                    }
                    newArray = Array.newInstance(componentType, dims);
                }
            }
        } else {
            TypedValue dValue;
            int i2;
            if (this.dimensions == null || this.dimensions.length > 1) {
                throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.MULTIDIM_ARRAY_INITIALIZER_NOT_SUPPORTED, new Object[0]);
            }
            TypeConverter typeConverter = state2.getEvaluationContext().getTypeConverter();
            InlineList initializer = (InlineList)this.getChild(1);
            if (this.dimensions[0] != null && (i2 = ExpressionUtils.toInt(typeConverter, dValue = this.dimensions[0].getTypedValue(state2))) != initializer.getChildCount()) {
                throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.INITIALIZER_LENGTH_INCORRECT, new Object[0]);
            }
            newArray = switch (arrayTypeCode) {
                case TypeCode.OBJECT -> (Object)this.createReferenceTypeArray(state2, typeConverter, initializer.children, componentType);
                case TypeCode.BOOLEAN -> this.createBooleanArray(state2, typeConverter, initializer.children);
                case TypeCode.CHAR -> (Object)this.createCharArray(state2, typeConverter, initializer.children);
                case TypeCode.BYTE -> (Object)this.createByteArray(state2, typeConverter, initializer.children);
                case TypeCode.SHORT -> (Object)this.createShortArray(state2, typeConverter, initializer.children);
                case TypeCode.INT -> (Object)this.createIntArray(state2, typeConverter, initializer.children);
                case TypeCode.LONG -> (Object)this.createLongArray(state2, typeConverter, initializer.children);
                case TypeCode.FLOAT -> (Object)this.createFloatArray(state2, typeConverter, initializer.children);
                case TypeCode.DOUBLE -> (Object)this.createDoubleArray(state2, typeConverter, initializer.children);
                default -> throw new IllegalStateException("Unsupported TypeCode: " + arrayTypeCode);
            };
        }
        return new TypedValue(newArray);
    }

    private void checkNumElements(long numElements) {
        if (numElements >= 262144L) {
            throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.MAX_ARRAY_ELEMENTS_THRESHOLD_EXCEEDED, 262144);
        }
    }

    private Object createReferenceTypeArray(ExpressionState state2, TypeConverter typeConverter, SpelNodeImpl[] children2, Class<?> componentType) {
        Object[] array2 = (Object[])Array.newInstance(componentType, children2.length);
        TypeDescriptor targetType = TypeDescriptor.valueOf(componentType);
        for (int i2 = 0; i2 < array2.length; ++i2) {
            Object value2 = children2[i2].getValue(state2);
            array2[i2] = typeConverter.convertValue(value2, TypeDescriptor.forObject(value2), targetType);
        }
        return array2;
    }

    private boolean[] createBooleanArray(ExpressionState state2, TypeConverter typeConverter, SpelNodeImpl[] children2) {
        boolean[] array2 = new boolean[children2.length];
        for (int i2 = 0; i2 < array2.length; ++i2) {
            TypedValue typedValue = children2[i2].getTypedValue(state2);
            array2[i2] = ExpressionUtils.toBoolean(typeConverter, typedValue);
        }
        return array2;
    }

    private char[] createCharArray(ExpressionState state2, TypeConverter typeConverter, SpelNodeImpl[] children2) {
        char[] array2 = new char[children2.length];
        for (int i2 = 0; i2 < array2.length; ++i2) {
            TypedValue typedValue = children2[i2].getTypedValue(state2);
            array2[i2] = ExpressionUtils.toChar(typeConverter, typedValue);
        }
        return array2;
    }

    private byte[] createByteArray(ExpressionState state2, TypeConverter converter, SpelNodeImpl[] children2) {
        byte[] array2 = new byte[children2.length];
        for (int i2 = 0; i2 < array2.length; ++i2) {
            TypedValue typedValue = children2[i2].getTypedValue(state2);
            array2[i2] = ExpressionUtils.toByte(converter, typedValue);
        }
        return array2;
    }

    private short[] createShortArray(ExpressionState state2, TypeConverter typeConverter, SpelNodeImpl[] children2) {
        short[] array2 = new short[children2.length];
        for (int i2 = 0; i2 < array2.length; ++i2) {
            TypedValue typedValue = children2[i2].getTypedValue(state2);
            array2[i2] = ExpressionUtils.toShort(typeConverter, typedValue);
        }
        return array2;
    }

    private int[] createIntArray(ExpressionState state2, TypeConverter typeConverter, SpelNodeImpl[] children2) {
        int[] array2 = new int[children2.length];
        for (int i2 = 0; i2 < array2.length; ++i2) {
            TypedValue typedValue = children2[i2].getTypedValue(state2);
            array2[i2] = ExpressionUtils.toInt(typeConverter, typedValue);
        }
        return array2;
    }

    private long[] createLongArray(ExpressionState state2, TypeConverter converter, SpelNodeImpl[] children2) {
        long[] array2 = new long[children2.length];
        for (int i2 = 0; i2 < array2.length; ++i2) {
            TypedValue typedValue = children2[i2].getTypedValue(state2);
            array2[i2] = ExpressionUtils.toLong(converter, typedValue);
        }
        return array2;
    }

    private float[] createFloatArray(ExpressionState state2, TypeConverter typeConverter, SpelNodeImpl[] children2) {
        float[] array2 = new float[children2.length];
        for (int i2 = 0; i2 < array2.length; ++i2) {
            TypedValue typedValue = children2[i2].getTypedValue(state2);
            array2[i2] = ExpressionUtils.toFloat(typeConverter, typedValue);
        }
        return array2;
    }

    private double[] createDoubleArray(ExpressionState state2, TypeConverter typeConverter, SpelNodeImpl[] children2) {
        double[] array2 = new double[children2.length];
        for (int i2 = 0; i2 < array2.length; ++i2) {
            TypedValue typedValue = children2[i2].getTypedValue(state2);
            array2[i2] = ExpressionUtils.toDouble(typeConverter, typedValue);
        }
        return array2;
    }

    private boolean hasInitializer() {
        return this.getChildCount() > 1;
    }

    @Override
    public boolean isCompilable() {
        Constructor<?> constructor2;
        ReflectiveConstructorExecutor executor;
        block6: {
            block5: {
                ConstructorExecutor constructorExecutor = this.cachedExecutor;
                if (!(constructorExecutor instanceof ReflectiveConstructorExecutor)) break block5;
                executor = (ReflectiveConstructorExecutor)constructorExecutor;
                if (this.exitTypeDescriptor != null) break block6;
            }
            return false;
        }
        if (this.getChildCount() > 1) {
            int max2 = this.getChildCount();
            for (int c = 1; c < max2; ++c) {
                if (this.children[c].isCompilable()) continue;
                return false;
            }
        }
        return Modifier.isPublic((constructor2 = executor.getConstructor()).getModifiers()) && Modifier.isPublic(constructor2.getDeclaringClass().getModifiers());
    }

    @Override
    public void generateCode(MethodVisitor mv, CodeFlow cf) {
        ReflectiveConstructorExecutor executor = (ReflectiveConstructorExecutor)this.cachedExecutor;
        Assert.state(executor != null, "No cached executor");
        Constructor<?> constructor2 = executor.getConstructor();
        String classDesc = constructor2.getDeclaringClass().getName().replace('.', '/');
        mv.visitTypeInsn(187, classDesc);
        mv.visitInsn(89);
        SpelNodeImpl[] arguments = new SpelNodeImpl[this.children.length - 1];
        System.arraycopy(this.children, 1, arguments, 0, this.children.length - 1);
        ConstructorReference.generateCodeForArguments(mv, cf, constructor2, arguments);
        mv.visitMethodInsn(183, classDesc, "<init>", CodeFlow.createSignatureDescriptor(constructor2), false);
        cf.pushDescriptor(this.exitTypeDescriptor);
    }
}

