/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import java.util.function.Supplier;
import org.springframework.asm.MethodVisitor;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.CodeFlow;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.ast.Indexer;
import org.springframework.expression.spel.ast.SpelNodeImpl;
import org.springframework.expression.spel.ast.ValueRef;

public class CompoundExpression
extends SpelNodeImpl {
    public CompoundExpression(int startPos, int endPos, SpelNodeImpl ... expressionComponents) {
        super(startPos, endPos, expressionComponents);
        if (expressionComponents.length < 2) {
            throw new IllegalStateException("Do not build compound expressions with less than two entries: " + expressionComponents.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ValueRef getValueRef(ExpressionState state2) throws EvaluationException {
        if (this.getChildCount() == 1) {
            return this.children[0].getValueRef(state2);
        }
        SpelNodeImpl nextNode = this.children[0];
        TypedValue result2 = nextNode.getValueInternal(state2);
        int cc = this.getChildCount();
        for (int i2 = 1; i2 < cc - 1; ++i2) {
            try {
                state2.pushActiveContextObject(result2);
                nextNode = this.children[i2];
                result2 = nextNode.getValueInternal(state2);
                continue;
            }
            finally {
                state2.popActiveContextObject();
            }
        }
        try {
            state2.pushActiveContextObject(result2);
            nextNode = this.children[cc - 1];
            ValueRef valueRef = nextNode.getValueRef(state2);
            state2.popActiveContextObject();
            return valueRef;
        }
        catch (Throwable throwable) {
            try {
                state2.popActiveContextObject();
                throw throwable;
            }
            catch (SpelEvaluationException ex) {
                ex.setPosition(nextNode.getStartPosition());
                throw ex;
            }
        }
    }

    @Override
    public TypedValue getValueInternal(ExpressionState state2) throws EvaluationException {
        ValueRef ref = this.getValueRef(state2);
        TypedValue result2 = ref.getValue();
        this.exitTypeDescriptor = this.children[this.children.length - 1].exitTypeDescriptor;
        return result2;
    }

    @Override
    public TypedValue setValueInternal(ExpressionState state2, Supplier<TypedValue> valueSupplier) throws EvaluationException {
        TypedValue typedValue = valueSupplier.get();
        this.getValueRef(state2).setValue(typedValue.getValue());
        return typedValue;
    }

    @Override
    public boolean isWritable(ExpressionState state2) throws EvaluationException {
        return this.getValueRef(state2).isWritable();
    }

    @Override
    public String toStringAST() {
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < this.getChildCount(); ++i2) {
            sb.append(this.getChild(i2).toStringAST());
            if (i2 >= this.getChildCount() - 1) continue;
            SpelNodeImpl nextChild = this.children[i2 + 1];
            if (nextChild.isNullSafe()) {
                sb.append("?.");
                continue;
            }
            if (nextChild instanceof Indexer) continue;
            sb.append('.');
        }
        return sb.toString();
    }

    @Override
    public boolean isCompilable() {
        for (SpelNodeImpl child : this.children) {
            if (child.isCompilable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void generateCode(MethodVisitor mv, CodeFlow cf) {
        for (SpelNodeImpl child : this.children) {
            child.generateCode(mv, cf);
        }
        cf.pushDescriptor(this.exitTypeDescriptor);
    }
}

