/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.type.classreading;

import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.asm.AnnotationVisitor;
import org.springframework.asm.ClassVisitor;
import org.springframework.asm.MethodVisitor;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.type.MethodMetadata;
import org.springframework.core.type.classreading.MergedAnnotationReadingVisitor;
import org.springframework.core.type.classreading.SimpleAnnotationMetadata;
import org.springframework.core.type.classreading.SimpleMethodMetadataReadingVisitor;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

final class SimpleAnnotationMetadataReadingVisitor
extends ClassVisitor {
    @Nullable
    private final ClassLoader classLoader;
    private String className = "";
    private int access;
    @Nullable
    private String superClassName;
    @Nullable
    private String enclosingClassName;
    private boolean independentInnerClass;
    private final Set<String> interfaceNames = new LinkedHashSet<String>(4);
    private final Set<String> memberClassNames = new LinkedHashSet<String>(4);
    private final Set<MergedAnnotation<?>> annotations = new LinkedHashSet(4);
    private final Set<MethodMetadata> declaredMethods = new LinkedHashSet<MethodMetadata>(4);
    @Nullable
    private SimpleAnnotationMetadata metadata;
    @Nullable
    private Source source;

    SimpleAnnotationMetadataReadingVisitor(@Nullable ClassLoader classLoader) {
        super(0x10A0000);
        this.classLoader = classLoader;
    }

    @Override
    public void visit(int version, int access, String name2, String signature, @Nullable String supername, String[] interfaces2) {
        this.className = this.toClassName(name2);
        this.access = access;
        if (supername != null && !this.isInterface(access)) {
            this.superClassName = this.toClassName(supername);
        }
        for (String element : interfaces2) {
            this.interfaceNames.add(this.toClassName(element));
        }
    }

    @Override
    public void visitOuterClass(String owner2, String name2, String desc) {
        this.enclosingClassName = this.toClassName(owner2);
    }

    @Override
    public void visitInnerClass(String name2, @Nullable String outerName, String innerName, int access) {
        if (outerName != null) {
            String className = this.toClassName(name2);
            String outerClassName = this.toClassName(outerName);
            if (this.className.equals(className)) {
                this.enclosingClassName = outerClassName;
                this.independentInnerClass = (access & 8) != 0;
            } else if (this.className.equals(outerClassName)) {
                this.memberClassNames.add(className);
            }
        }
    }

    @Override
    @Nullable
    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        return MergedAnnotationReadingVisitor.get(this.classLoader, this.getSource(), descriptor, visible, this.annotations::add);
    }

    @Override
    @Nullable
    public MethodVisitor visitMethod(int access, String name2, String descriptor, String signature, String[] exceptions) {
        if (this.isBridge(access) || name2.equals("<init>")) {
            return null;
        }
        return new SimpleMethodMetadataReadingVisitor(this.classLoader, this.className, access, name2, descriptor, this.declaredMethods::add);
    }

    @Override
    public void visitEnd() {
        MergedAnnotations annotations = MergedAnnotations.of(this.annotations);
        this.metadata = new SimpleAnnotationMetadata(this.className, this.access, this.enclosingClassName, this.superClassName, this.independentInnerClass, this.interfaceNames, this.memberClassNames, this.declaredMethods, annotations);
    }

    public SimpleAnnotationMetadata getMetadata() {
        Assert.state(this.metadata != null, "AnnotationMetadata not initialized");
        return this.metadata;
    }

    private Source getSource() {
        Source source2 = this.source;
        if (source2 == null) {
            this.source = source2 = new Source(this.className);
        }
        return source2;
    }

    private String toClassName(String name2) {
        return ClassUtils.convertResourcePathToClassName(name2);
    }

    private boolean isBridge(int access) {
        return (access & 0x40) != 0;
    }

    private boolean isInterface(int access) {
        return (access & 0x200) != 0;
    }

    private static final class Source {
        private final String className;

        Source(String className) {
            this.className = className;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(@Nullable Object other) {
            if (this == other) return true;
            if (!(other instanceof Source)) return false;
            Source that = (Source)other;
            if (!this.className.equals(that.className)) return false;
            return true;
        }

        public int hashCode() {
            return this.className.hashCode();
        }

        public String toString() {
            return this.className;
        }
    }
}

