/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.type;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.annotation.RepeatableContainers;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.MethodMetadata;
import org.springframework.core.type.StandardClassMetadata;
import org.springframework.core.type.StandardMethodMetadata;
import org.springframework.lang.Nullable;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ReflectionUtils;

public class StandardAnnotationMetadata
extends StandardClassMetadata
implements AnnotationMetadata {
    private final MergedAnnotations mergedAnnotations;
    private final boolean nestedAnnotationsAsMap;
    @Nullable
    private Set<String> annotationTypes;

    @Deprecated
    public StandardAnnotationMetadata(Class<?> introspectedClass) {
        this(introspectedClass, false);
    }

    @Deprecated
    public StandardAnnotationMetadata(Class<?> introspectedClass, boolean nestedAnnotationsAsMap) {
        super(introspectedClass);
        this.mergedAnnotations = MergedAnnotations.from(introspectedClass, MergedAnnotations.SearchStrategy.INHERITED_ANNOTATIONS, RepeatableContainers.none());
        this.nestedAnnotationsAsMap = nestedAnnotationsAsMap;
    }

    @Override
    public MergedAnnotations getAnnotations() {
        return this.mergedAnnotations;
    }

    @Override
    public Set<String> getAnnotationTypes() {
        Set<String> annotationTypes = this.annotationTypes;
        if (annotationTypes == null) {
            this.annotationTypes = annotationTypes = Collections.unmodifiableSet(AnnotationMetadata.super.getAnnotationTypes());
        }
        return annotationTypes;
    }

    @Override
    @Nullable
    public Map<String, Object> getAnnotationAttributes(String annotationName, boolean classValuesAsString) {
        if (this.nestedAnnotationsAsMap) {
            return AnnotationMetadata.super.getAnnotationAttributes(annotationName, classValuesAsString);
        }
        return AnnotatedElementUtils.getMergedAnnotationAttributes(this.getIntrospectedClass(), annotationName, classValuesAsString, false);
    }

    @Override
    @Nullable
    public MultiValueMap<String, Object> getAllAnnotationAttributes(String annotationName, boolean classValuesAsString) {
        if (this.nestedAnnotationsAsMap) {
            return AnnotationMetadata.super.getAllAnnotationAttributes(annotationName, classValuesAsString);
        }
        return AnnotatedElementUtils.getAllAnnotationAttributes(this.getIntrospectedClass(), annotationName, classValuesAsString, false);
    }

    @Override
    public boolean hasAnnotatedMethods(String annotationName) {
        if (AnnotationUtils.isCandidateClass(this.getIntrospectedClass(), annotationName)) {
            try {
                Method[] methods2;
                for (Method method2 : methods2 = ReflectionUtils.getDeclaredMethods(this.getIntrospectedClass())) {
                    if (!StandardAnnotationMetadata.isAnnotatedMethod(method2, annotationName)) continue;
                    return true;
                }
            }
            catch (Throwable ex) {
                throw new IllegalStateException("Failed to introspect annotated methods on " + this.getIntrospectedClass(), ex);
            }
        }
        return false;
    }

    @Override
    public Set<MethodMetadata> getAnnotatedMethods(String annotationName) {
        LinkedHashSet<MethodMetadata> result2 = new LinkedHashSet<MethodMetadata>(4);
        if (AnnotationUtils.isCandidateClass(this.getIntrospectedClass(), annotationName)) {
            ReflectionUtils.doWithLocalMethods(this.getIntrospectedClass(), method2 -> {
                if (StandardAnnotationMetadata.isAnnotatedMethod(method2, annotationName)) {
                    result2.add(new StandardMethodMetadata(method2, this.nestedAnnotationsAsMap));
                }
            });
        }
        return result2;
    }

    @Override
    public Set<MethodMetadata> getDeclaredMethods() {
        LinkedHashSet<MethodMetadata> result2 = new LinkedHashSet<MethodMetadata>(16);
        ReflectionUtils.doWithLocalMethods(this.getIntrospectedClass(), method2 -> result2.add(new StandardMethodMetadata(method2, this.nestedAnnotationsAsMap)));
        return result2;
    }

    private static boolean isAnnotatedMethod(Method method2, String annotationName) {
        return !method2.isBridge() && method2.getAnnotations().length > 0 && AnnotatedElementUtils.isAnnotated((AnnotatedElement)method2, annotationName);
    }

    static AnnotationMetadata from(Class<?> introspectedClass) {
        return new StandardAnnotationMetadata(introspectedClass, true);
    }
}

