/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.task;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;

public class TaskRejectedException
extends RejectedExecutionException {
    public TaskRejectedException(String msg) {
        super(msg);
    }

    public TaskRejectedException(String msg, Throwable cause2) {
        super(msg, cause2);
    }

    public TaskRejectedException(Executor executor, Object task, RejectedExecutionException cause2) {
        super(TaskRejectedException.executorDescription(executor) + " did not accept task: " + task, cause2);
    }

    private static String executorDescription(Executor executor) {
        if (executor instanceof ExecutorService) {
            ExecutorService executorService = (ExecutorService)executor;
            return "ExecutorService in " + (executorService.isShutdown() ? "shutdown" : "active") + " state";
        }
        return executor.toString();
    }
}

