/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.style;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import org.springframework.core.style.ValueStyler;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public class DefaultValueStyler
implements ValueStyler {
    private static final String EMPTY = "[[empty]]";
    private static final String NULL = "[null]";
    private static final String COLLECTION = "collection";
    private static final String SET = "set";
    private static final String LIST = "list";
    private static final String MAP = "map";
    private static final String EMPTY_MAP = "map[[empty]]";
    private static final String ARRAY = "array";

    @Override
    public String style(@Nullable Object value2) {
        if (value2 == null) {
            return this.styleNull();
        }
        if (value2 instanceof String) {
            String str = (String)value2;
            return this.styleString(str);
        }
        if (value2 instanceof Class) {
            Class clazz = (Class)value2;
            return this.styleClass(clazz);
        }
        if (value2 instanceof Method) {
            Method method2 = (Method)value2;
            return this.styleMethod(method2);
        }
        if (value2 instanceof Map) {
            Map map2 = (Map)value2;
            return this.styleMap(map2);
        }
        if (value2 instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)value2;
            return this.styleMapEntry(entry);
        }
        if (value2 instanceof Collection) {
            Collection collection = (Collection)value2;
            return this.styleCollection(collection);
        }
        if (value2.getClass().isArray()) {
            return this.styleArray(ObjectUtils.toObjectArray(value2));
        }
        return this.styleObject(value2);
    }

    protected String styleNull() {
        return NULL;
    }

    protected String styleString(String str) {
        return "'" + str + "'";
    }

    protected String styleClass(Class<?> clazz) {
        return ClassUtils.getShortName(clazz);
    }

    protected String styleMethod(Method method2) {
        return method2.getName() + "@" + ClassUtils.getShortName(method2.getDeclaringClass());
    }

    protected <K, V> String styleMap(Map<K, V> map2) {
        if (map2.isEmpty()) {
            return EMPTY_MAP;
        }
        StringJoiner result2 = new StringJoiner(", ", "[", "]");
        for (Map.Entry<K, V> entry : map2.entrySet()) {
            result2.add(this.styleMapEntry(entry));
        }
        return MAP + result2;
    }

    protected String styleMapEntry(Map.Entry<?, ?> entry) {
        return this.style(entry.getKey()) + " -> " + this.style(entry.getValue());
    }

    protected String styleCollection(Collection<?> collection) {
        String collectionType = DefaultValueStyler.getCollectionTypeString(collection);
        if (collection.isEmpty()) {
            return collectionType + EMPTY;
        }
        StringJoiner result2 = new StringJoiner(", ", "[", "]");
        for (Object element : collection) {
            result2.add(this.style(element));
        }
        return collectionType + result2;
    }

    protected String styleArray(Object[] array2) {
        if (array2.length == 0) {
            return "array<" + ClassUtils.getShortName(array2.getClass().componentType()) + ">[[empty]]";
        }
        StringJoiner result2 = new StringJoiner(", ", "[", "]");
        for (Object element : array2) {
            result2.add(this.style(element));
        }
        return "array<" + ClassUtils.getShortName(array2.getClass().componentType()) + ">" + result2;
    }

    protected String styleObject(Object obj) {
        return String.valueOf(obj);
    }

    private static String getCollectionTypeString(Collection<?> collection) {
        if (collection instanceof List) {
            return LIST;
        }
        if (collection instanceof Set) {
            return SET;
        }
        return COLLECTION;
    }
}

