/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.metrics.jfr;

import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.springframework.core.metrics.StartupStep;
import org.springframework.core.metrics.jfr.FlightRecorderStartupEvent;

class FlightRecorderStartupStep
implements StartupStep {
    private final FlightRecorderStartupEvent event;
    private final FlightRecorderTags tags = new FlightRecorderTags();
    private final Consumer<FlightRecorderStartupStep> recordingCallback;

    public FlightRecorderStartupStep(long id2, String name2, long parentId, Consumer<FlightRecorderStartupStep> recordingCallback) {
        this.event = new FlightRecorderStartupEvent(id2, name2, parentId);
        this.event.begin();
        this.recordingCallback = recordingCallback;
    }

    @Override
    public String getName() {
        return this.event.name;
    }

    @Override
    public long getId() {
        return this.event.eventId;
    }

    @Override
    public Long getParentId() {
        return this.event.parentId;
    }

    @Override
    public StartupStep tag(String key2, String value2) {
        this.tags.add(key2, value2);
        return this;
    }

    @Override
    public StartupStep tag(String key2, Supplier<String> value2) {
        this.tags.add(key2, value2.get());
        return this;
    }

    @Override
    public StartupStep.Tags getTags() {
        return this.tags;
    }

    @Override
    public void end() {
        this.event.end();
        if (this.event.shouldCommit()) {
            StringBuilder builder = new StringBuilder();
            this.tags.forEach(tag2 -> builder.append(tag2.getKey()).append('=').append(tag2.getValue()).append(','));
            this.event.setTags(builder.toString());
        }
        this.event.commit();
        this.recordingCallback.accept(this);
    }

    protected FlightRecorderStartupEvent getEvent() {
        return this.event;
    }

    static class FlightRecorderTags
    implements StartupStep.Tags {
        private StartupStep.Tag[] tags = new StartupStep.Tag[0];

        FlightRecorderTags() {
        }

        public void add(String key2, String value2) {
            StartupStep.Tag[] newTags = new StartupStep.Tag[this.tags.length + 1];
            System.arraycopy(this.tags, 0, newTags, 0, this.tags.length);
            newTags[newTags.length - 1] = new FlightRecorderTag(key2, value2);
            this.tags = newTags;
        }

        public void add(String key2, Supplier<String> value2) {
            this.add(key2, value2.get());
        }

        @Override
        public Iterator<StartupStep.Tag> iterator() {
            return new TagsIterator();
        }

        private class TagsIterator
        implements Iterator<StartupStep.Tag> {
            private int idx = 0;

            private TagsIterator() {
            }

            @Override
            public boolean hasNext() {
                return this.idx < FlightRecorderTags.this.tags.length;
            }

            @Override
            public StartupStep.Tag next() {
                return FlightRecorderTags.this.tags[this.idx++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("tags are append only");
            }
        }
    }

    static class FlightRecorderTag
    implements StartupStep.Tag {
        private final String key;
        private final String value;

        public FlightRecorderTag(String key2, String value2) {
            this.key = key2;
            this.value = value2;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }
}

