/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.log;

import java.util.function.Function;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class LogFormatUtils {
    private static final Pattern NEWLINE_PATTERN = Pattern.compile("[\n\r]");
    private static final Pattern CONTROL_CHARACTER_PATTERN = Pattern.compile("\\p{Cc}");

    public static String formatValue(@Nullable Object value2, boolean limitLength) {
        return LogFormatUtils.formatValue(value2, limitLength ? 100 : -1, limitLength);
    }

    public static String formatValue(@Nullable Object value2, int maxLength, boolean replaceNewlinesAndControlCharacters) {
        Object result2;
        if (value2 == null) {
            return "";
        }
        try {
            result2 = ObjectUtils.nullSafeToString(value2);
        }
        catch (Throwable ex) {
            result2 = ObjectUtils.nullSafeToString(ex);
        }
        if (maxLength != -1) {
            result2 = StringUtils.truncate((CharSequence)result2, maxLength);
        }
        if (replaceNewlinesAndControlCharacters) {
            result2 = NEWLINE_PATTERN.matcher((CharSequence)result2).replaceAll("<EOL>");
            result2 = CONTROL_CHARACTER_PATTERN.matcher((CharSequence)result2).replaceAll("?");
        }
        if (value2 instanceof CharSequence) {
            result2 = "\"" + (String)result2 + "\"";
        }
        return result2;
    }

    public static void traceDebug(Log logger, Function<Boolean, String> messageFactory) {
        if (logger.isDebugEnabled()) {
            boolean traceEnabled = logger.isTraceEnabled();
            String logMessage = messageFactory.apply(traceEnabled);
            if (traceEnabled) {
                logger.trace(logMessage);
            } else {
                logger.debug(logMessage);
            }
        }
    }
}

