/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.log;

import java.util.List;
import java.util.function.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.NoOpLog;

final class CompositeLog
implements Log {
    private static final Log NO_OP_LOG = new NoOpLog();
    private final List<Log> loggers;

    CompositeLog(List<Log> loggers) {
        this.loggers = loggers;
    }

    @Override
    public boolean isFatalEnabled() {
        return this.isEnabled(Log::isFatalEnabled);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.isEnabled(Log::isErrorEnabled);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.isEnabled(Log::isWarnEnabled);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.isEnabled(Log::isInfoEnabled);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.isEnabled(Log::isDebugEnabled);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.isEnabled(Log::isTraceEnabled);
    }

    private boolean isEnabled(Predicate<Log> predicate) {
        return this.getLogger(predicate) != NO_OP_LOG;
    }

    @Override
    public void fatal(Object message2) {
        this.getLogger(Log::isFatalEnabled).fatal(message2);
    }

    @Override
    public void fatal(Object message2, Throwable ex) {
        this.getLogger(Log::isFatalEnabled).fatal(message2, ex);
    }

    @Override
    public void error(Object message2) {
        this.getLogger(Log::isErrorEnabled).error(message2);
    }

    @Override
    public void error(Object message2, Throwable ex) {
        this.getLogger(Log::isErrorEnabled).error(message2, ex);
    }

    @Override
    public void warn(Object message2) {
        this.getLogger(Log::isWarnEnabled).warn(message2);
    }

    @Override
    public void warn(Object message2, Throwable ex) {
        this.getLogger(Log::isWarnEnabled).warn(message2, ex);
    }

    @Override
    public void info(Object message2) {
        this.getLogger(Log::isInfoEnabled).info(message2);
    }

    @Override
    public void info(Object message2, Throwable ex) {
        this.getLogger(Log::isInfoEnabled).info(message2, ex);
    }

    @Override
    public void debug(Object message2) {
        this.getLogger(Log::isDebugEnabled).debug(message2);
    }

    @Override
    public void debug(Object message2, Throwable ex) {
        this.getLogger(Log::isDebugEnabled).debug(message2, ex);
    }

    @Override
    public void trace(Object message2) {
        this.getLogger(Log::isTraceEnabled).trace(message2);
    }

    @Override
    public void trace(Object message2, Throwable ex) {
        this.getLogger(Log::isTraceEnabled).trace(message2, ex);
    }

    private Log getLogger(Predicate<Log> predicate) {
        for (Log logger : this.loggers) {
            if (!predicate.test(logger)) continue;
            return logger;
        }
        return NO_OP_LOG;
    }
}

