/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io.support;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.reflect.KClass;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.full.KClasses;
import kotlin.reflect.jvm.KCallablesJvm;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.KotlinDetector;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.core.log.LogMessage;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class SpringFactoriesLoader {
    public static final String FACTORIES_RESOURCE_LOCATION = "META-INF/spring.factories";
    private static final FailureHandler THROWING_FAILURE_HANDLER = FailureHandler.throwing();
    private static final Log logger = LogFactory.getLog(SpringFactoriesLoader.class);
    static final Map<ClassLoader, Map<String, SpringFactoriesLoader>> cache = new ConcurrentReferenceHashMap<ClassLoader, Map<String, SpringFactoriesLoader>>();
    @Nullable
    private final ClassLoader classLoader;
    private final Map<String, List<String>> factories;

    protected SpringFactoriesLoader(@Nullable ClassLoader classLoader, Map<String, List<String>> factories) {
        this.classLoader = classLoader;
        this.factories = factories;
    }

    public <T> List<T> load(Class<T> factoryType) {
        return this.load(factoryType, null, null);
    }

    public <T> List<T> load(Class<T> factoryType, @Nullable ArgumentResolver argumentResolver) {
        return this.load(factoryType, argumentResolver, null);
    }

    public <T> List<T> load(Class<T> factoryType, @Nullable FailureHandler failureHandler) {
        return this.load(factoryType, null, failureHandler);
    }

    public <T> List<T> load(Class<T> factoryType, @Nullable ArgumentResolver argumentResolver, @Nullable FailureHandler failureHandler) {
        Assert.notNull(factoryType, "'factoryType' must not be null");
        List<String> implementationNames = this.loadFactoryNames(factoryType);
        logger.trace(LogMessage.format("Loaded [%s] names: %s", (Object)factoryType.getName(), implementationNames));
        ArrayList<T> result2 = new ArrayList<T>(implementationNames.size());
        FailureHandler failureHandlerToUse = failureHandler != null ? failureHandler : THROWING_FAILURE_HANDLER;
        for (String implementationName : implementationNames) {
            T factory = this.instantiateFactory(implementationName, factoryType, argumentResolver, failureHandlerToUse);
            if (factory == null) continue;
            result2.add(factory);
        }
        AnnotationAwareOrderComparator.sort(result2);
        return result2;
    }

    private List<String> loadFactoryNames(Class<?> factoryType) {
        return this.factories.getOrDefault(factoryType.getName(), Collections.emptyList());
    }

    @Nullable
    protected <T> T instantiateFactory(String implementationName, Class<T> type2, @Nullable ArgumentResolver argumentResolver, FailureHandler failureHandler) {
        try {
            Class<?> factoryImplementationClass = ClassUtils.forName(implementationName, this.classLoader);
            Assert.isTrue(type2.isAssignableFrom(factoryImplementationClass), () -> "Class [%s] is not assignable to factory type [%s]".formatted(implementationName, type2.getName()));
            FactoryInstantiator factoryInstantiator = FactoryInstantiator.forClass(factoryImplementationClass);
            return factoryInstantiator.instantiate(argumentResolver);
        }
        catch (Throwable ex) {
            failureHandler.handleFailure(type2, implementationName, ex);
            return null;
        }
    }

    public static <T> List<T> loadFactories(Class<T> factoryType, @Nullable ClassLoader classLoader) {
        return SpringFactoriesLoader.forDefaultResourceLocation(classLoader).load(factoryType);
    }

    @Deprecated(since="6.0")
    public static List<String> loadFactoryNames(Class<?> factoryType, @Nullable ClassLoader classLoader) {
        return SpringFactoriesLoader.forDefaultResourceLocation(classLoader).loadFactoryNames(factoryType);
    }

    public static SpringFactoriesLoader forDefaultResourceLocation() {
        return SpringFactoriesLoader.forDefaultResourceLocation(null);
    }

    public static SpringFactoriesLoader forDefaultResourceLocation(@Nullable ClassLoader classLoader) {
        return SpringFactoriesLoader.forResourceLocation(FACTORIES_RESOURCE_LOCATION, classLoader);
    }

    public static SpringFactoriesLoader forResourceLocation(String resourceLocation) {
        return SpringFactoriesLoader.forResourceLocation(resourceLocation, null);
    }

    public static SpringFactoriesLoader forResourceLocation(String resourceLocation, @Nullable ClassLoader classLoader) {
        Assert.hasText(resourceLocation, "'resourceLocation' must not be empty");
        ClassLoader resourceClassLoader = classLoader != null ? classLoader : SpringFactoriesLoader.class.getClassLoader();
        Map loaders = cache.computeIfAbsent(resourceClassLoader, key2 -> new ConcurrentReferenceHashMap());
        return loaders.computeIfAbsent(resourceLocation, key2 -> new SpringFactoriesLoader(classLoader, SpringFactoriesLoader.loadFactoriesResource(resourceClassLoader, resourceLocation)));
    }

    protected static Map<String, List<String>> loadFactoriesResource(ClassLoader classLoader, String resourceLocation) {
        LinkedHashMap<String, List> result2 = new LinkedHashMap<String, List>();
        try {
            Enumeration<URL> urls = classLoader.getResources(resourceLocation);
            while (urls.hasMoreElements()) {
                UrlResource resource = new UrlResource(urls.nextElement());
                Properties properties = PropertiesLoaderUtils.loadProperties(resource);
                properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(name2, value2) -> {
                    String[] factoryImplementationNames = StringUtils.commaDelimitedListToStringArray((String)value2);
                    List implementations = result2.computeIfAbsent(((String)name2).trim(), key2 -> new ArrayList(factoryImplementationNames.length));
                    Arrays.stream(factoryImplementationNames).map(String::trim).forEach(implementations::add);
                }));
            }
            result2.replaceAll(SpringFactoriesLoader::toDistinctUnmodifiableList);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Unable to load factories from location [" + resourceLocation + "]", ex);
        }
        return Collections.unmodifiableMap(result2);
    }

    private static List<String> toDistinctUnmodifiableList(String factoryType, List<String> implementations) {
        return implementations.stream().distinct().toList();
    }

    @FunctionalInterface
    public static interface ArgumentResolver {
        @Nullable
        public <T> T resolve(Class<T> var1);

        default public <T> ArgumentResolver and(Class<T> type2, T value2) {
            return this.and(ArgumentResolver.of(type2, value2));
        }

        default public <T> ArgumentResolver andSupplied(Class<T> type2, Supplier<T> valueSupplier) {
            return this.and(ArgumentResolver.ofSupplied(type2, valueSupplier));
        }

        default public ArgumentResolver and(ArgumentResolver argumentResolver) {
            return ArgumentResolver.from(type2 -> {
                Object resolved = this.resolve((Class)type2);
                return resolved != null ? resolved : argumentResolver.resolve((Class)type2);
            });
        }

        public static ArgumentResolver none() {
            return ArgumentResolver.from(type2 -> null);
        }

        public static <T> ArgumentResolver of(Class<T> type2, T value2) {
            return ArgumentResolver.ofSupplied(type2, () -> value2);
        }

        public static <T> ArgumentResolver ofSupplied(Class<T> type2, Supplier<T> valueSupplier) {
            return ArgumentResolver.from(candidateType -> candidateType.equals(type2) ? valueSupplier.get() : null);
        }

        public static ArgumentResolver from(final Function<Class<?>, Object> function) {
            return new ArgumentResolver(){

                @Override
                public <T> T resolve(Class<T> type2) {
                    return (T)function.apply(type2);
                }
            };
        }
    }

    @FunctionalInterface
    public static interface FailureHandler {
        public void handleFailure(Class<?> var1, String var2, Throwable var3);

        public static FailureHandler throwing() {
            return FailureHandler.throwing(IllegalArgumentException::new);
        }

        public static FailureHandler throwing(BiFunction<String, Throwable, ? extends RuntimeException> exceptionFactory) {
            return FailureHandler.handleMessage((messageSupplier, failure) -> {
                throw (RuntimeException)exceptionFactory.apply((String)messageSupplier.get(), (Throwable)failure);
            });
        }

        public static FailureHandler logging(Log logger) {
            return FailureHandler.handleMessage((messageSupplier, failure) -> logger.trace(LogMessage.of(messageSupplier), (Throwable)failure));
        }

        public static FailureHandler handleMessage(BiConsumer<Supplier<String>, Throwable> messageHandler) {
            return (factoryType, factoryImplementationName, failure) -> {
                Supplier<String> messageSupplier = () -> "Unable to instantiate factory class [%s] for factory type [%s]".formatted(factoryImplementationName, factoryType.getName());
                messageHandler.accept(messageSupplier, failure);
            };
        }
    }

    static final class FactoryInstantiator<T> {
        private final Constructor<T> constructor;

        private FactoryInstantiator(Constructor<T> constructor2) {
            ReflectionUtils.makeAccessible(constructor2);
            this.constructor = constructor2;
        }

        T instantiate(@Nullable ArgumentResolver argumentResolver) throws Exception {
            Object[] args2 = this.resolveArgs(argumentResolver);
            if (FactoryInstantiator.isKotlinType(this.constructor.getDeclaringClass())) {
                return KotlinDelegate.instantiate(this.constructor, args2);
            }
            return this.constructor.newInstance(args2);
        }

        private Object[] resolveArgs(@Nullable ArgumentResolver argumentResolver) {
            Class<?>[] types = this.constructor.getParameterTypes();
            return argumentResolver != null ? Arrays.stream(types).map(argumentResolver::resolve).toArray() : new Object[types.length];
        }

        static <T> FactoryInstantiator<T> forClass(Class<?> factoryImplementationClass) {
            Constructor<?> constructor2 = FactoryInstantiator.findConstructor(factoryImplementationClass);
            Assert.state(constructor2 != null, () -> "Class [%s] has no suitable constructor".formatted(factoryImplementationClass.getName()));
            return new FactoryInstantiator(constructor2);
        }

        @Nullable
        private static Constructor<?> findConstructor(Class<?> factoryImplementationClass) {
            Constructor<?> constructor2 = FactoryInstantiator.findPrimaryKotlinConstructor(factoryImplementationClass);
            constructor2 = constructor2 != null ? constructor2 : FactoryInstantiator.findSingleConstructor(factoryImplementationClass.getConstructors());
            constructor2 = constructor2 != null ? constructor2 : FactoryInstantiator.findSingleConstructor(factoryImplementationClass.getDeclaredConstructors());
            constructor2 = constructor2 != null ? constructor2 : FactoryInstantiator.findDeclaredConstructor(factoryImplementationClass);
            return constructor2;
        }

        @Nullable
        private static Constructor<?> findPrimaryKotlinConstructor(Class<?> factoryImplementationClass) {
            return FactoryInstantiator.isKotlinType(factoryImplementationClass) ? KotlinDelegate.findPrimaryConstructor(factoryImplementationClass) : null;
        }

        private static boolean isKotlinType(Class<?> factoryImplementationClass) {
            return KotlinDetector.isKotlinReflectPresent() && KotlinDetector.isKotlinType(factoryImplementationClass);
        }

        @Nullable
        private static Constructor<?> findSingleConstructor(Constructor<?>[] constructors2) {
            return constructors2.length == 1 ? constructors2[0] : null;
        }

        @Nullable
        private static Constructor<?> findDeclaredConstructor(Class<?> factoryImplementationClass) {
            try {
                return factoryImplementationClass.getDeclaredConstructor(new Class[0]);
            }
            catch (NoSuchMethodException ex) {
                return null;
            }
        }
    }

    private static class KotlinDelegate {
        private KotlinDelegate() {
        }

        @Nullable
        static <T> Constructor<T> findPrimaryConstructor(Class<T> clazz) {
            try {
                KFunction primaryConstructor = KClasses.getPrimaryConstructor((KClass)JvmClassMappingKt.getKotlinClass(clazz));
                if (primaryConstructor != null) {
                    Constructor constructor2 = ReflectJvmMapping.getJavaConstructor((KFunction)primaryConstructor);
                    Assert.state(constructor2 != null, () -> "Failed to find Java constructor for Kotlin primary constructor: " + clazz.getName());
                    return constructor2;
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            return null;
        }

        static <T> T instantiate(Constructor<T> constructor2, Object[] args2) throws Exception {
            KFunction kotlinConstructor = ReflectJvmMapping.getKotlinFunction(constructor2);
            if (kotlinConstructor == null) {
                return constructor2.newInstance(args2);
            }
            KotlinDelegate.makeAccessible(constructor2, kotlinConstructor);
            return KotlinDelegate.instantiate(kotlinConstructor, KotlinDelegate.convertArgs(args2, kotlinConstructor.getParameters()));
        }

        private static <T> void makeAccessible(Constructor<T> constructor2, KFunction<T> kotlinConstructor) {
            if (!Modifier.isPublic(constructor2.getModifiers()) || !Modifier.isPublic(constructor2.getDeclaringClass().getModifiers())) {
                KCallablesJvm.setAccessible(kotlinConstructor, (boolean)true);
            }
        }

        private static Map<KParameter, Object> convertArgs(Object[] args2, List<KParameter> parameters2) {
            HashMap<KParameter, Object> result2 = CollectionUtils.newHashMap(parameters2.size());
            Assert.isTrue(args2.length <= parameters2.size(), "Number of provided arguments should be less than or equal to the number of constructor parameters");
            for (int i2 = 0; i2 < args2.length; ++i2) {
                if (parameters2.get(i2).isOptional() && args2[i2] == null) continue;
                result2.put(parameters2.get(i2), args2[i2]);
            }
            return result2;
        }

        private static <T> T instantiate(KFunction<T> kotlinConstructor, Map<KParameter, Object> args2) {
            return (T)kotlinConstructor.callBy(args2);
        }
    }
}

