/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io.support;

import java.beans.PropertyEditorSupport;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ResourceArrayPropertyEditor
extends PropertyEditorSupport {
    private static final Log logger = LogFactory.getLog(ResourceArrayPropertyEditor.class);
    private final ResourcePatternResolver resourcePatternResolver;
    @Nullable
    private PropertyResolver propertyResolver;
    private final boolean ignoreUnresolvablePlaceholders;

    public ResourceArrayPropertyEditor() {
        this(new PathMatchingResourcePatternResolver(), null, true);
    }

    public ResourceArrayPropertyEditor(ResourcePatternResolver resourcePatternResolver, @Nullable PropertyResolver propertyResolver) {
        this(resourcePatternResolver, propertyResolver, true);
    }

    public ResourceArrayPropertyEditor(ResourcePatternResolver resourcePatternResolver, @Nullable PropertyResolver propertyResolver, boolean ignoreUnresolvablePlaceholders) {
        Assert.notNull((Object)resourcePatternResolver, "ResourcePatternResolver must not be null");
        this.resourcePatternResolver = resourcePatternResolver;
        this.propertyResolver = propertyResolver;
        this.ignoreUnresolvablePlaceholders = ignoreUnresolvablePlaceholders;
    }

    @Override
    public void setAsText(String text) {
        String pattern = this.resolvePath(text).trim();
        String[] locationPatterns = StringUtils.commaDelimitedListToStringArray(pattern);
        if (locationPatterns.length == 1) {
            this.setValue(this.getResources(locationPatterns[0]));
        } else {
            Resource[] resources = (Resource[])Arrays.stream(locationPatterns).map(String::trim).map(this::getResources).flatMap(Arrays::stream).toArray(Resource[]::new);
            this.setValue(resources);
        }
    }

    private Resource[] getResources(String locationPattern) {
        try {
            return this.resourcePatternResolver.getResources(locationPattern);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Could not resolve resource location pattern [" + locationPattern + "]: " + ex.getMessage());
        }
    }

    @Override
    public void setValue(Object value2) throws IllegalArgumentException {
        if (value2 instanceof Collection || value2 instanceof Object[] && !(value2 instanceof Resource[])) {
            Collection<Object> collection;
            if (value2 instanceof Collection) {
                Collection collection2 = (Collection)value2;
                collection = collection2;
            } else {
                collection = Arrays.asList((Object[])value2);
            }
            Collection<Object> input = collection;
            LinkedHashSet<Resource> merged = new LinkedHashSet<Resource>();
            for (Object element : input) {
                if (element instanceof String) {
                    String path2 = (String)element;
                    String pattern = this.resolvePath(path2.trim());
                    try {
                        Resource[] resources = this.resourcePatternResolver.getResources(pattern);
                        Collections.addAll(merged, resources);
                    }
                    catch (IOException ex) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("Could not retrieve resources for pattern '" + pattern + "'", ex);
                    }
                    continue;
                }
                if (element instanceof Resource) {
                    Resource resource = (Resource)element;
                    merged.add(resource);
                    continue;
                }
                throw new IllegalArgumentException("Cannot convert element [" + element + "] to [" + Resource.class.getName() + "]: only location String and Resource object supported");
            }
            super.setValue(merged.toArray(new Resource[0]));
        } else {
            super.setValue(value2);
        }
    }

    protected String resolvePath(String path2) {
        if (this.propertyResolver == null) {
            this.propertyResolver = new StandardEnvironment();
        }
        return this.ignoreUnresolvablePlaceholders ? this.propertyResolver.resolvePlaceholders(path2) : this.propertyResolver.resolveRequiredPlaceholders(path2);
    }
}

