/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io.buffer;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.function.IntPredicate;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class DefaultDataBuffer
implements DataBuffer {
    private static final int MAX_CAPACITY = Integer.MAX_VALUE;
    private static final int CAPACITY_THRESHOLD = 0x400000;
    private final DefaultDataBufferFactory dataBufferFactory;
    private ByteBuffer byteBuffer;
    private int capacity;
    private int readPosition;
    private int writePosition;

    private DefaultDataBuffer(DefaultDataBufferFactory dataBufferFactory, ByteBuffer byteBuffer) {
        ByteBuffer slice2;
        Assert.notNull((Object)dataBufferFactory, "DefaultDataBufferFactory must not be null");
        Assert.notNull((Object)byteBuffer, "ByteBuffer must not be null");
        this.dataBufferFactory = dataBufferFactory;
        this.byteBuffer = slice2 = byteBuffer.slice();
        this.capacity = slice2.remaining();
    }

    static DefaultDataBuffer fromFilledByteBuffer(DefaultDataBufferFactory dataBufferFactory, ByteBuffer byteBuffer) {
        DefaultDataBuffer dataBuffer = new DefaultDataBuffer(dataBufferFactory, byteBuffer);
        dataBuffer.writePosition(byteBuffer.remaining());
        return dataBuffer;
    }

    static DefaultDataBuffer fromEmptyByteBuffer(DefaultDataBufferFactory dataBufferFactory, ByteBuffer byteBuffer) {
        return new DefaultDataBuffer(dataBufferFactory, byteBuffer);
    }

    public ByteBuffer getNativeBuffer() {
        this.byteBuffer.position(this.readPosition);
        this.byteBuffer.limit(this.readableByteCount());
        return this.byteBuffer;
    }

    private void setNativeBuffer(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
        this.capacity = byteBuffer.remaining();
    }

    @Override
    public DefaultDataBufferFactory factory() {
        return this.dataBufferFactory;
    }

    @Override
    public int indexOf(IntPredicate predicate, int fromIndex) {
        Assert.notNull((Object)predicate, "IntPredicate must not be null");
        if (fromIndex < 0) {
            fromIndex = 0;
        } else if (fromIndex >= this.writePosition) {
            return -1;
        }
        for (int i2 = fromIndex; i2 < this.writePosition; ++i2) {
            byte b2 = this.byteBuffer.get(i2);
            if (!predicate.test(b2)) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(IntPredicate predicate, int fromIndex) {
        Assert.notNull((Object)predicate, "IntPredicate must not be null");
        for (int i2 = Math.min(fromIndex, this.writePosition - 1); i2 >= 0; --i2) {
            byte b2 = this.byteBuffer.get(i2);
            if (!predicate.test(b2)) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public int readableByteCount() {
        return this.writePosition - this.readPosition;
    }

    @Override
    public int writableByteCount() {
        return this.capacity - this.writePosition;
    }

    @Override
    public int readPosition() {
        return this.readPosition;
    }

    @Override
    public DefaultDataBuffer readPosition(int readPosition) {
        this.assertIndex(readPosition >= 0, "'readPosition' %d must be >= 0", readPosition);
        this.assertIndex(readPosition <= this.writePosition, "'readPosition' %d must be <= %d", readPosition, this.writePosition);
        this.readPosition = readPosition;
        return this;
    }

    @Override
    public int writePosition() {
        return this.writePosition;
    }

    @Override
    public DefaultDataBuffer writePosition(int writePosition) {
        this.assertIndex(writePosition >= this.readPosition, "'writePosition' %d must be >= %d", writePosition, this.readPosition);
        this.assertIndex(writePosition <= this.capacity, "'writePosition' %d must be <= %d", writePosition, this.capacity);
        this.writePosition = writePosition;
        return this;
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    @Deprecated
    public DataBuffer capacity(int capacity) {
        this.setCapacity(capacity);
        return this;
    }

    private void setCapacity(int newCapacity) {
        if (newCapacity < 0) {
            throw new IllegalArgumentException(String.format("'newCapacity' %d must be 0 or higher", newCapacity));
        }
        int readPosition = this.readPosition();
        int writePosition = this.writePosition();
        int oldCapacity = this.capacity();
        if (newCapacity > oldCapacity) {
            ByteBuffer oldBuffer = this.byteBuffer;
            ByteBuffer newBuffer = DefaultDataBuffer.allocate(newCapacity, oldBuffer.isDirect());
            oldBuffer.position(0).limit(oldBuffer.capacity());
            newBuffer.position(0).limit(oldBuffer.capacity());
            newBuffer.put(oldBuffer);
            newBuffer.clear();
            this.setNativeBuffer(newBuffer);
        } else if (newCapacity < oldCapacity) {
            ByteBuffer oldBuffer = this.byteBuffer;
            ByteBuffer newBuffer = DefaultDataBuffer.allocate(newCapacity, oldBuffer.isDirect());
            if (readPosition < newCapacity) {
                if (writePosition > newCapacity) {
                    writePosition = newCapacity;
                    this.writePosition(writePosition);
                }
                oldBuffer.position(readPosition).limit(writePosition);
                newBuffer.position(readPosition).limit(writePosition);
                newBuffer.put(oldBuffer);
                newBuffer.clear();
            } else {
                this.readPosition(newCapacity);
                this.writePosition(newCapacity);
            }
            this.setNativeBuffer(newBuffer);
        }
    }

    @Override
    public DataBuffer ensureWritable(int length2) {
        if (length2 > this.writableByteCount()) {
            int newCapacity = this.calculateCapacity(this.writePosition + length2);
            this.setCapacity(newCapacity);
        }
        return this;
    }

    private static ByteBuffer allocate(int capacity, boolean direct) {
        return direct ? ByteBuffer.allocateDirect(capacity) : ByteBuffer.allocate(capacity);
    }

    @Override
    public byte getByte(int index2) {
        this.assertIndex(index2 >= 0, "index %d must be >= 0", index2);
        this.assertIndex(index2 <= this.writePosition - 1, "index %d must be <= %d", index2, this.writePosition - 1);
        return this.byteBuffer.get(index2);
    }

    @Override
    public byte read() {
        this.assertIndex(this.readPosition <= this.writePosition - 1, "readPosition %d must be <= %d", this.readPosition, this.writePosition - 1);
        int pos2 = this.readPosition;
        byte b2 = this.byteBuffer.get(pos2);
        this.readPosition = pos2 + 1;
        return b2;
    }

    @Override
    public DefaultDataBuffer read(byte[] destination) {
        Assert.notNull((Object)destination, "Byte array must not be null");
        this.read(destination, 0, destination.length);
        return this;
    }

    @Override
    public DefaultDataBuffer read(byte[] destination, int offset2, int length2) {
        Assert.notNull((Object)destination, "Byte array must not be null");
        this.assertIndex(this.readPosition <= this.writePosition - length2, "readPosition %d and length %d should be smaller than writePosition %d", this.readPosition, length2, this.writePosition);
        ByteBuffer tmp = this.byteBuffer.duplicate();
        int limit2 = this.readPosition + length2;
        tmp.clear().position(this.readPosition).limit(limit2);
        tmp.get(destination, offset2, length2);
        this.readPosition += length2;
        return this;
    }

    @Override
    public DefaultDataBuffer write(byte b2) {
        this.ensureWritable(1);
        int pos2 = this.writePosition;
        this.byteBuffer.put(pos2, b2);
        this.writePosition = pos2 + 1;
        return this;
    }

    @Override
    public DefaultDataBuffer write(byte[] source2) {
        Assert.notNull((Object)source2, "Byte array must not be null");
        this.write(source2, 0, source2.length);
        return this;
    }

    @Override
    public DefaultDataBuffer write(byte[] source2, int offset2, int length2) {
        Assert.notNull((Object)source2, "Byte array must not be null");
        this.ensureWritable(length2);
        ByteBuffer tmp = this.byteBuffer.duplicate();
        int limit2 = this.writePosition + length2;
        tmp.clear().position(this.writePosition).limit(limit2);
        tmp.put(source2, offset2, length2);
        this.writePosition += length2;
        return this;
    }

    @Override
    public DefaultDataBuffer write(DataBuffer ... dataBuffers) {
        if (!ObjectUtils.isEmpty(dataBuffers)) {
            ByteBuffer[] byteBuffers = new ByteBuffer[dataBuffers.length];
            for (int i2 = 0; i2 < dataBuffers.length; ++i2) {
                byteBuffers[i2] = ByteBuffer.allocate(dataBuffers[i2].readableByteCount());
                dataBuffers[i2].toByteBuffer(byteBuffers[i2]);
            }
            this.write(byteBuffers);
        }
        return this;
    }

    @Override
    public DefaultDataBuffer write(ByteBuffer ... buffers) {
        if (!ObjectUtils.isEmpty(buffers)) {
            int capacity = Arrays.stream(buffers).mapToInt(Buffer::remaining).sum();
            this.ensureWritable(capacity);
            Arrays.stream(buffers).forEach(this::write);
        }
        return this;
    }

    private void write(ByteBuffer source2) {
        int length2 = source2.remaining();
        ByteBuffer tmp = this.byteBuffer.duplicate();
        int limit2 = this.writePosition + source2.remaining();
        tmp.clear().position(this.writePosition).limit(limit2);
        tmp.put(source2);
        this.writePosition += length2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public DefaultDataBuffer slice(int index2, int length2) {
        this.checkIndex(index2, length2);
        int oldPosition = this.byteBuffer.position();
        try {
            this.byteBuffer.position(index2);
            ByteBuffer slice2 = this.byteBuffer.slice();
            slice2.limit(length2);
            SlicedDefaultDataBuffer slicedDefaultDataBuffer = new SlicedDefaultDataBuffer(slice2, this.dataBufferFactory, length2);
            return slicedDefaultDataBuffer;
        }
        finally {
            this.byteBuffer.position(oldPosition);
        }
    }

    @Override
    public DataBuffer split(int index2) {
        this.checkIndex(index2);
        ByteBuffer split2 = this.byteBuffer.duplicate().clear().position(0).limit(index2).slice();
        DefaultDataBuffer result2 = new DefaultDataBuffer(this.dataBufferFactory, split2);
        result2.writePosition = Math.min(this.writePosition, index2);
        result2.readPosition = Math.min(this.readPosition, index2);
        this.byteBuffer = this.byteBuffer.duplicate().clear().position(index2).limit(this.byteBuffer.capacity()).slice();
        this.writePosition = Math.max(this.writePosition, index2) - index2;
        this.readPosition = Math.max(this.readPosition, index2) - index2;
        this.capacity = this.byteBuffer.capacity();
        return result2;
    }

    @Override
    @Deprecated
    public ByteBuffer asByteBuffer() {
        return this.asByteBuffer(this.readPosition, this.readableByteCount());
    }

    @Override
    @Deprecated
    public ByteBuffer asByteBuffer(int index2, int length2) {
        this.checkIndex(index2, length2);
        ByteBuffer duplicate = this.byteBuffer.duplicate();
        duplicate.position(index2);
        duplicate.limit(index2 + length2);
        return duplicate.slice();
    }

    @Override
    @Deprecated
    public ByteBuffer toByteBuffer(int index2, int length2) {
        this.checkIndex(index2, length2);
        ByteBuffer copy2 = DefaultDataBuffer.allocate(length2, this.byteBuffer.isDirect());
        ByteBuffer readOnly = this.byteBuffer.asReadOnlyBuffer();
        readOnly.clear().position(index2).limit(index2 + length2);
        copy2.put(readOnly);
        return copy2.flip();
    }

    @Override
    public void toByteBuffer(int srcPos, ByteBuffer dest, int destPos, int length2) {
        this.checkIndex(srcPos, length2);
        Assert.notNull((Object)dest, "Dest must not be null");
        dest = dest.duplicate().clear();
        dest.put(destPos, this.byteBuffer, srcPos, length2);
    }

    @Override
    public DataBuffer.ByteBufferIterator readableByteBuffers() {
        ByteBuffer readOnly = this.byteBuffer.slice(this.readPosition, this.readableByteCount()).asReadOnlyBuffer();
        return new ByteBufferIterator(readOnly);
    }

    @Override
    public DataBuffer.ByteBufferIterator writableByteBuffers() {
        ByteBuffer slice2 = this.byteBuffer.slice(this.writePosition, this.writableByteCount());
        return new ByteBufferIterator(slice2);
    }

    @Override
    public String toString(int index2, int length2, Charset charset) {
        int offset2;
        byte[] bytes2;
        this.checkIndex(index2, length2);
        Assert.notNull((Object)charset, "Charset must not be null");
        if (this.byteBuffer.hasArray()) {
            bytes2 = this.byteBuffer.array();
            offset2 = this.byteBuffer.arrayOffset() + index2;
        } else {
            bytes2 = new byte[length2];
            offset2 = 0;
            ByteBuffer duplicate = this.byteBuffer.duplicate();
            duplicate.clear().position(index2).limit(index2 + length2);
            duplicate.get(bytes2, 0, length2);
        }
        return new String(bytes2, offset2, length2, charset);
    }

    private int calculateCapacity(int neededCapacity) {
        int newCapacity;
        Assert.isTrue(neededCapacity >= 0, "'neededCapacity' must be >= 0");
        if (neededCapacity == 0x400000) {
            return 0x400000;
        }
        if (neededCapacity > 0x400000) {
            int newCapacity2 = neededCapacity / 0x400000 * 0x400000;
            newCapacity2 = newCapacity2 > 0x7FBFFFFF ? Integer.MAX_VALUE : (newCapacity2 += 0x400000);
            return newCapacity2;
        }
        for (newCapacity = 64; newCapacity < neededCapacity; newCapacity <<= 1) {
        }
        return Math.min(newCapacity, Integer.MAX_VALUE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        if (!(other instanceof DefaultDataBuffer)) return false;
        DefaultDataBuffer that = (DefaultDataBuffer)other;
        if (this.readPosition != that.readPosition) return false;
        if (this.writePosition != that.writePosition) return false;
        if (!this.byteBuffer.equals(that.byteBuffer)) return false;
        return true;
    }

    public int hashCode() {
        return this.byteBuffer.hashCode();
    }

    public String toString() {
        return String.format("DefaultDataBuffer (r: %d, w: %d, c: %d)", this.readPosition, this.writePosition, this.capacity);
    }

    private void checkIndex(int index2, int length2) {
        this.checkIndex(index2);
        this.checkLength(length2);
    }

    private void checkIndex(int index2) {
        this.assertIndex(index2 >= 0, "index %d must be >= 0", index2);
        this.assertIndex(index2 <= this.capacity, "index %d must be <= %d", index2, this.capacity);
    }

    private void checkLength(int length2) {
        this.assertIndex(length2 >= 0, "length %d must be >= 0", length2);
        this.assertIndex(length2 <= this.capacity, "length %d must be <= %d", length2, this.capacity);
    }

    private void assertIndex(boolean expression, String format, Object ... args2) {
        if (!expression) {
            String message2 = String.format(format, args2);
            throw new IndexOutOfBoundsException(message2);
        }
    }

    private static class SlicedDefaultDataBuffer
    extends DefaultDataBuffer {
        SlicedDefaultDataBuffer(ByteBuffer byteBuffer, DefaultDataBufferFactory dataBufferFactory, int length2) {
            super(dataBufferFactory, byteBuffer);
            this.writePosition(length2);
        }

        @Override
        public DefaultDataBuffer capacity(int newCapacity) {
            throw new UnsupportedOperationException("Changing the capacity of a sliced buffer is not supported");
        }
    }

    private static final class ByteBufferIterator
    implements DataBuffer.ByteBufferIterator {
        private final ByteBuffer buffer;
        private boolean hasNext = true;

        public ByteBufferIterator(ByteBuffer buffer) {
            this.buffer = buffer;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public ByteBuffer next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            this.hasNext = false;
            return this.buffer;
        }

        @Override
        public void close() {
        }
    }
}

