/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io.buffer;

import java.io.IOException;
import java.io.OutputStream;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.util.Assert;

final class DataBufferOutputStream
extends OutputStream {
    private final DataBuffer dataBuffer;
    private boolean closed;

    public DataBufferOutputStream(DataBuffer dataBuffer) {
        Assert.notNull((Object)dataBuffer, "DataBuffer must not be null");
        this.dataBuffer = dataBuffer;
    }

    @Override
    public void write(int b2) throws IOException {
        this.checkClosed();
        this.dataBuffer.ensureWritable(1);
        this.dataBuffer.write((byte)b2);
    }

    @Override
    public void write(byte[] b2, int off, int len) throws IOException {
        this.checkClosed();
        if (len > 0) {
            this.dataBuffer.ensureWritable(len);
            this.dataBuffer.write(b2, off, len);
        }
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
    }

    private void checkClosed() throws IOException {
        if (this.closed) {
            throw new IOException("DataBufferOutputStream is closed");
        }
    }
}

