/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io.buffer;

import java.io.IOException;
import java.io.InputStream;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.util.Assert;

final class DataBufferInputStream
extends InputStream {
    private final DataBuffer dataBuffer;
    private final int end;
    private final boolean releaseOnClose;
    private boolean closed;
    private int mark;

    public DataBufferInputStream(DataBuffer dataBuffer, boolean releaseOnClose) {
        Assert.notNull((Object)dataBuffer, "DataBuffer must not be null");
        this.dataBuffer = dataBuffer;
        int start2 = this.dataBuffer.readPosition();
        this.end = start2 + this.dataBuffer.readableByteCount();
        this.mark = start2;
        this.releaseOnClose = releaseOnClose;
    }

    @Override
    public int read() throws IOException {
        this.checkClosed();
        if (this.available() == 0) {
            return -1;
        }
        return this.dataBuffer.read() & 0xFF;
    }

    @Override
    public int read(byte[] b2, int off, int len) throws IOException {
        this.checkClosed();
        int available = this.available();
        if (available == 0) {
            return -1;
        }
        len = Math.min(available, len);
        this.dataBuffer.read(b2, off, len);
        return len;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readLimit) {
        Assert.isTrue(readLimit > 0, "readLimit must be greater than 0");
        this.mark = this.dataBuffer.readPosition();
    }

    @Override
    public int available() {
        return Math.max(0, this.end - this.dataBuffer.readPosition());
    }

    @Override
    public void reset() {
        this.dataBuffer.readPosition(this.mark);
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        if (this.releaseOnClose) {
            DataBufferUtils.release(this.dataBuffer);
        }
        this.closed = true;
    }

    private void checkClosed() throws IOException {
        if (this.closed) {
            throw new IOException("DataBufferInputStream is closed");
        }
    }
}

