/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.Resource;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ModuleResource
extends AbstractResource {
    private final Module module;
    private final String path;

    public ModuleResource(Module module, String path2) {
        Assert.notNull((Object)module, "Module must not be null");
        Assert.notNull((Object)path2, "Path must not be null");
        this.module = module;
        this.path = path2;
    }

    public final Module getModule() {
        return this.module;
    }

    public final String getPath() {
        return this.path;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        InputStream is = this.module.getResourceAsStream(this.path);
        if (is == null) {
            throw new FileNotFoundException(this.getDescription() + " cannot be opened because it does not exist");
        }
        return is;
    }

    @Override
    public Resource createRelative(String relativePath) {
        String pathToUse = StringUtils.applyRelativePath(this.path, relativePath);
        return new ModuleResource(this.module, pathToUse);
    }

    @Override
    @Nullable
    public String getFilename() {
        return StringUtils.getFilename(this.path);
    }

    @Override
    public String getDescription() {
        return "module resource [" + this.path + "]" + (String)(this.module.isNamed() ? " from module [" + this.module.getName() + "]" : "");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof ModuleResource)) return false;
        ModuleResource that = (ModuleResource)obj;
        if (!this.module.equals(that.module)) return false;
        if (!this.path.equals(that.path)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return this.module.hashCode() * 31 + this.path.hashCode();
    }
}

