/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.env;

import java.util.Map;
import org.springframework.core.env.MapPropertySource;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class SystemEnvironmentPropertySource
extends MapPropertySource {
    public SystemEnvironmentPropertySource(String name2, Map<String, Object> source2) {
        super(name2, source2);
    }

    @Override
    public boolean containsProperty(String name2) {
        return this.getProperty(name2) != null;
    }

    @Override
    @Nullable
    public Object getProperty(String name2) {
        String actualName = this.resolvePropertyName(name2);
        if (this.logger.isDebugEnabled() && !name2.equals(actualName)) {
            this.logger.debug("PropertySource '" + this.getName() + "' does not contain property '" + name2 + "', but found equivalent '" + actualName + "'");
        }
        return super.getProperty(actualName);
    }

    protected final String resolvePropertyName(String name2) {
        Assert.notNull((Object)name2, "Property name must not be null");
        String resolvedName = this.checkPropertyName(name2);
        if (resolvedName != null) {
            return resolvedName;
        }
        String uppercasedName = name2.toUpperCase();
        if (!name2.equals(uppercasedName) && (resolvedName = this.checkPropertyName(uppercasedName)) != null) {
            return resolvedName;
        }
        return name2;
    }

    @Nullable
    private String checkPropertyName(String name2) {
        if (((Map)this.source).containsKey(name2)) {
            return name2;
        }
        String noDotName = name2.replace('.', '_');
        if (!name2.equals(noDotName) && ((Map)this.source).containsKey(noDotName)) {
            return noDotName;
        }
        String noHyphenName = name2.replace('-', '_');
        if (!name2.equals(noHyphenName) && ((Map)this.source).containsKey(noHyphenName)) {
            return noHyphenName;
        }
        String noDotNoHyphenName = noDotName.replace('-', '_');
        if (!noDotName.equals(noDotNoHyphenName) && ((Map)this.source).containsKey(noDotNoHyphenName)) {
            return noDotNoHyphenName;
        }
        return null;
    }
}

