/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.env;

import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Stream;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.lang.Nullable;

public class MutablePropertySources
implements PropertySources {
    private final List<PropertySource<?>> propertySourceList = new CopyOnWriteArrayList();

    public MutablePropertySources() {
    }

    public MutablePropertySources(PropertySources propertySources) {
        this();
        for (PropertySource propertySource : propertySources) {
            this.addLast(propertySource);
        }
    }

    @Override
    public Iterator<PropertySource<?>> iterator() {
        return this.propertySourceList.iterator();
    }

    @Override
    public Spliterator<PropertySource<?>> spliterator() {
        return this.propertySourceList.spliterator();
    }

    @Override
    public Stream<PropertySource<?>> stream() {
        return this.propertySourceList.stream();
    }

    @Override
    public boolean contains(String name2) {
        for (PropertySource<?> propertySource : this.propertySourceList) {
            if (!propertySource.getName().equals(name2)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public PropertySource<?> get(String name2) {
        for (PropertySource<?> propertySource : this.propertySourceList) {
            if (!propertySource.getName().equals(name2)) continue;
            return propertySource;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFirst(PropertySource<?> propertySource) {
        List<PropertySource<?>> list2 = this.propertySourceList;
        synchronized (list2) {
            this.removeIfPresent(propertySource);
            this.propertySourceList.add(0, propertySource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLast(PropertySource<?> propertySource) {
        List<PropertySource<?>> list2 = this.propertySourceList;
        synchronized (list2) {
            this.removeIfPresent(propertySource);
            this.propertySourceList.add(propertySource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBefore(String relativePropertySourceName, PropertySource<?> propertySource) {
        this.assertLegalRelativeAddition(relativePropertySourceName, propertySource);
        List<PropertySource<?>> list2 = this.propertySourceList;
        synchronized (list2) {
            this.removeIfPresent(propertySource);
            int index2 = this.assertPresentAndGetIndex(relativePropertySourceName);
            this.addAtIndex(index2, propertySource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAfter(String relativePropertySourceName, PropertySource<?> propertySource) {
        this.assertLegalRelativeAddition(relativePropertySourceName, propertySource);
        List<PropertySource<?>> list2 = this.propertySourceList;
        synchronized (list2) {
            this.removeIfPresent(propertySource);
            int index2 = this.assertPresentAndGetIndex(relativePropertySourceName);
            this.addAtIndex(index2 + 1, propertySource);
        }
    }

    public int precedenceOf(PropertySource<?> propertySource) {
        return this.propertySourceList.indexOf(propertySource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public PropertySource<?> remove(String name2) {
        List<PropertySource<?>> list2 = this.propertySourceList;
        synchronized (list2) {
            int index2 = this.propertySourceList.indexOf(PropertySource.named(name2));
            return index2 != -1 ? this.propertySourceList.remove(index2) : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replace(String name2, PropertySource<?> propertySource) {
        List<PropertySource<?>> list2 = this.propertySourceList;
        synchronized (list2) {
            int index2 = this.assertPresentAndGetIndex(name2);
            this.propertySourceList.set(index2, propertySource);
        }
    }

    public int size() {
        return this.propertySourceList.size();
    }

    public String toString() {
        return this.propertySourceList.toString();
    }

    protected void assertLegalRelativeAddition(String relativePropertySourceName, PropertySource<?> propertySource) {
        String newPropertySourceName = propertySource.getName();
        if (relativePropertySourceName.equals(newPropertySourceName)) {
            throw new IllegalArgumentException("PropertySource named '" + newPropertySourceName + "' cannot be added relative to itself");
        }
    }

    protected void removeIfPresent(PropertySource<?> propertySource) {
        this.propertySourceList.remove(propertySource);
    }

    private void addAtIndex(int index2, PropertySource<?> propertySource) {
        this.removeIfPresent(propertySource);
        this.propertySourceList.add(index2, propertySource);
    }

    private int assertPresentAndGetIndex(String name2) {
        int index2 = this.propertySourceList.indexOf(PropertySource.named(name2));
        if (index2 == -1) {
            throw new IllegalArgumentException("PropertySource named '" + name2 + "' does not exist");
        }
        return index2;
    }
}

