/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.env;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class CompositePropertySource
extends EnumerablePropertySource<Object> {
    private final Set<PropertySource<?>> propertySources = new LinkedHashSet();

    public CompositePropertySource(String name2) {
        super(name2);
    }

    @Override
    @Nullable
    public Object getProperty(String name2) {
        for (PropertySource<?> propertySource : this.propertySources) {
            Object candidate = propertySource.getProperty(name2);
            if (candidate == null) continue;
            return candidate;
        }
        return null;
    }

    @Override
    public boolean containsProperty(String name2) {
        for (PropertySource<?> propertySource : this.propertySources) {
            if (!propertySource.containsProperty(name2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[] getPropertyNames() {
        ArrayList<String[]> namesList = new ArrayList<String[]>(this.propertySources.size());
        int total2 = 0;
        for (PropertySource<?> propertySource : this.propertySources) {
            if (!(propertySource instanceof EnumerablePropertySource)) {
                throw new IllegalStateException("Failed to enumerate property names due to non-enumerable property source: " + propertySource);
            }
            EnumerablePropertySource enumerablePropertySource = (EnumerablePropertySource)propertySource;
            String[] names3 = enumerablePropertySource.getPropertyNames();
            namesList.add(names3);
            total2 += names3.length;
        }
        LinkedHashSet<String> allNames = new LinkedHashSet<String>(total2);
        namesList.forEach(names2 -> Collections.addAll(allNames, names2));
        return StringUtils.toStringArray(allNames);
    }

    public void addPropertySource(PropertySource<?> propertySource) {
        this.propertySources.add(propertySource);
    }

    public void addFirstPropertySource(PropertySource<?> propertySource) {
        ArrayList existing = new ArrayList(this.propertySources);
        this.propertySources.clear();
        this.propertySources.add(propertySource);
        this.propertySources.addAll(existing);
    }

    public Collection<PropertySource<?>> getPropertySources() {
        return this.propertySources;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " {name='" + this.name + "', propertySources=" + this.propertySources + "}";
    }
}

