/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.env;

import java.util.List;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public abstract class CommandLinePropertySource<T>
extends EnumerablePropertySource<T> {
    public static final String COMMAND_LINE_PROPERTY_SOURCE_NAME = "commandLineArgs";
    public static final String DEFAULT_NON_OPTION_ARGS_PROPERTY_NAME = "nonOptionArgs";
    private String nonOptionArgsPropertyName = "nonOptionArgs";

    public CommandLinePropertySource(T source2) {
        super(COMMAND_LINE_PROPERTY_SOURCE_NAME, source2);
    }

    public CommandLinePropertySource(String name2, T source2) {
        super(name2, source2);
    }

    public void setNonOptionArgsPropertyName(String nonOptionArgsPropertyName) {
        this.nonOptionArgsPropertyName = nonOptionArgsPropertyName;
    }

    @Override
    public final boolean containsProperty(String name2) {
        if (this.nonOptionArgsPropertyName.equals(name2)) {
            return !this.getNonOptionArgs().isEmpty();
        }
        return this.containsOption(name2);
    }

    @Override
    @Nullable
    public final String getProperty(String name2) {
        if (this.nonOptionArgsPropertyName.equals(name2)) {
            List<String> nonOptionArguments = this.getNonOptionArgs();
            if (nonOptionArguments.isEmpty()) {
                return null;
            }
            return StringUtils.collectionToCommaDelimitedString(nonOptionArguments);
        }
        List<String> optionValues = this.getOptionValues(name2);
        if (optionValues == null) {
            return null;
        }
        return StringUtils.collectionToCommaDelimitedString(optionValues);
    }

    protected abstract boolean containsOption(String var1);

    @Nullable
    protected abstract List<String> getOptionValues(String var1);

    protected abstract List<String> getNonOptionArgs();
}

