/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert.support;

import java.util.Set;
import org.springframework.core.convert.converter.Converter;
import org.springframework.lang.Nullable;

final class StringToBooleanConverter
implements Converter<String, Boolean> {
    private static final Set<String> trueValues = Set.of("true", "on", "yes", "1");
    private static final Set<String> falseValues = Set.of("false", "off", "no", "0");

    StringToBooleanConverter() {
    }

    @Override
    @Nullable
    public Boolean convert(String source2) {
        String value2 = source2.trim();
        if (value2.isEmpty()) {
            return null;
        }
        if (trueValues.contains(value2 = value2.toLowerCase())) {
            return Boolean.TRUE;
        }
        if (falseValues.contains(value2)) {
            return Boolean.FALSE;
        }
        throw new IllegalArgumentException("Invalid boolean value '" + source2 + "'");
    }
}

