/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert.support;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.ConversionUtils;
import org.springframework.lang.Nullable;

final class ObjectToCollectionConverter
implements ConditionalGenericConverter {
    private final ConversionService conversionService;

    public ObjectToCollectionConverter(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(Object.class, Collection.class));
    }

    @Override
    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        return ConversionUtils.canConvertElements(sourceType, targetType.getElementTypeDescriptor(), this.conversionService);
    }

    @Override
    @Nullable
    public Object convert(@Nullable Object source2, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source2 == null) {
            return null;
        }
        TypeDescriptor elementDesc = targetType.getElementTypeDescriptor();
        Collection<Object> target2 = CollectionFactory.createCollection(targetType.getType(), elementDesc != null ? elementDesc.getType() : null, 1);
        if (elementDesc == null || elementDesc.isCollection()) {
            target2.add(source2);
        } else {
            Object singleElement = this.conversionService.convert(source2, sourceType, elementDesc);
            target2.add(singleElement);
        }
        return target2;
    }
}

