/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.CopyOnWriteArraySet;
import org.springframework.core.DecoratingProxy;
import org.springframework.core.ResolvableType;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.ConverterNotFoundException;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalConverter;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.core.convert.support.ConversionUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.StringUtils;

public class GenericConversionService
implements ConfigurableConversionService {
    private static final GenericConverter NO_OP_CONVERTER = new NoOpConverter("NO_OP");
    private static final GenericConverter NO_MATCH = new NoOpConverter("NO_MATCH");
    private final Converters converters = new Converters();
    private final Map<ConverterCacheKey, GenericConverter> converterCache = new ConcurrentReferenceHashMap<ConverterCacheKey, GenericConverter>(64);

    @Override
    public void addConverter(Converter<?, ?> converter) {
        ResolvableType[] typeInfo = this.getRequiredTypeInfo(converter.getClass(), Converter.class);
        if (typeInfo == null && converter instanceof DecoratingProxy) {
            DecoratingProxy decoratingProxy = (DecoratingProxy)((Object)converter);
            typeInfo = this.getRequiredTypeInfo(decoratingProxy.getDecoratedClass(), Converter.class);
        }
        if (typeInfo == null) {
            throw new IllegalArgumentException("Unable to determine source type <S> and target type <T> for your Converter [" + converter.getClass().getName() + "]; does the class parameterize those types?");
        }
        this.addConverter(new ConverterAdapter(converter, typeInfo[0], typeInfo[1]));
    }

    @Override
    public <S, T> void addConverter(Class<S> sourceType, Class<T> targetType, Converter<? super S, ? extends T> converter) {
        this.addConverter(new ConverterAdapter(converter, ResolvableType.forClass(sourceType), ResolvableType.forClass(targetType)));
    }

    @Override
    public void addConverter(GenericConverter converter) {
        this.converters.add(converter);
        this.invalidateCache();
    }

    @Override
    public void addConverterFactory(ConverterFactory<?, ?> factory) {
        ResolvableType[] typeInfo = this.getRequiredTypeInfo(factory.getClass(), ConverterFactory.class);
        if (typeInfo == null && factory instanceof DecoratingProxy) {
            DecoratingProxy decoratingProxy = (DecoratingProxy)((Object)factory);
            typeInfo = this.getRequiredTypeInfo(decoratingProxy.getDecoratedClass(), ConverterFactory.class);
        }
        if (typeInfo == null) {
            throw new IllegalArgumentException("Unable to determine source type <S> and target type <T> for your ConverterFactory [" + factory.getClass().getName() + "]; does the class parameterize those types?");
        }
        this.addConverter(new ConverterFactoryAdapter(factory, new GenericConverter.ConvertiblePair(typeInfo[0].toClass(), typeInfo[1].toClass())));
    }

    @Override
    public void removeConvertible(Class<?> sourceType, Class<?> targetType) {
        this.converters.remove(sourceType, targetType);
        this.invalidateCache();
    }

    @Override
    public boolean canConvert(@Nullable Class<?> sourceType, Class<?> targetType) {
        Assert.notNull(targetType, "Target type to convert to cannot be null");
        return this.canConvert(sourceType != null ? TypeDescriptor.valueOf(sourceType) : null, TypeDescriptor.valueOf(targetType));
    }

    @Override
    public boolean canConvert(@Nullable TypeDescriptor sourceType, TypeDescriptor targetType) {
        Assert.notNull((Object)targetType, "Target type to convert to cannot be null");
        return sourceType == null || this.getConverter(sourceType, targetType) != null;
    }

    public boolean canBypassConvert(@Nullable TypeDescriptor sourceType, TypeDescriptor targetType) {
        Assert.notNull((Object)targetType, "Target type to convert to cannot be null");
        return sourceType == null || this.getConverter(sourceType, targetType) == NO_OP_CONVERTER;
    }

    @Override
    @Nullable
    public <T> T convert(@Nullable Object source2, Class<T> targetType) {
        Assert.notNull(targetType, "Target type to convert to cannot be null");
        return (T)this.convert(source2, TypeDescriptor.forObject(source2), TypeDescriptor.valueOf(targetType));
    }

    @Override
    @Nullable
    public Object convert(@Nullable Object source2, @Nullable TypeDescriptor sourceType, TypeDescriptor targetType) {
        Assert.notNull((Object)targetType, "Target type to convert to cannot be null");
        if (sourceType == null) {
            Assert.isTrue(source2 == null, "Source must be [null] if source type == [null]");
            return this.handleResult(null, targetType, this.convertNullSource(null, targetType));
        }
        if (source2 != null && !sourceType.getObjectType().isInstance(source2)) {
            throw new IllegalArgumentException("Source to convert from must be an instance of [" + sourceType + "]; instead it was a [" + source2.getClass().getName() + "]");
        }
        GenericConverter converter = this.getConverter(sourceType, targetType);
        if (converter != null) {
            Object result2 = ConversionUtils.invokeConverter(converter, source2, sourceType, targetType);
            return this.handleResult(sourceType, targetType, result2);
        }
        return this.handleConverterNotFound(source2, sourceType, targetType);
    }

    public String toString() {
        return this.converters.toString();
    }

    @Nullable
    protected Object convertNullSource(@Nullable TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (targetType.getObjectType() == Optional.class) {
            return Optional.empty();
        }
        return null;
    }

    @Nullable
    protected GenericConverter getConverter(TypeDescriptor sourceType, TypeDescriptor targetType) {
        ConverterCacheKey key2 = new ConverterCacheKey(sourceType, targetType);
        GenericConverter converter = this.converterCache.get(key2);
        if (converter != null) {
            return converter != NO_MATCH ? converter : null;
        }
        converter = this.converters.find(sourceType, targetType);
        if (converter == null) {
            converter = this.getDefaultConverter(sourceType, targetType);
        }
        if (converter != null) {
            this.converterCache.put(key2, converter);
            return converter;
        }
        this.converterCache.put(key2, NO_MATCH);
        return null;
    }

    @Nullable
    protected GenericConverter getDefaultConverter(TypeDescriptor sourceType, TypeDescriptor targetType) {
        return sourceType.isAssignableTo(targetType) ? NO_OP_CONVERTER : null;
    }

    @Nullable
    private ResolvableType[] getRequiredTypeInfo(Class<?> converterClass, Class<?> genericIfc) {
        ResolvableType resolvableType = ResolvableType.forClass(converterClass).as(genericIfc);
        ResolvableType[] generics = resolvableType.getGenerics();
        if (generics.length < 2) {
            return null;
        }
        Class<?> sourceType = generics[0].resolve();
        Class<?> targetType = generics[1].resolve();
        if (sourceType == null || targetType == null) {
            return null;
        }
        return generics;
    }

    private void invalidateCache() {
        this.converterCache.clear();
    }

    @Nullable
    private Object handleConverterNotFound(@Nullable Object source2, @Nullable TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source2 == null) {
            this.assertNotPrimitiveTargetType(sourceType, targetType);
            return null;
        }
        if ((sourceType == null || sourceType.isAssignableTo(targetType)) && targetType.getObjectType().isInstance(source2)) {
            return source2;
        }
        throw new ConverterNotFoundException(sourceType, targetType);
    }

    @Nullable
    private Object handleResult(@Nullable TypeDescriptor sourceType, TypeDescriptor targetType, @Nullable Object result2) {
        if (result2 == null) {
            this.assertNotPrimitiveTargetType(sourceType, targetType);
        }
        return result2;
    }

    private void assertNotPrimitiveTargetType(@Nullable TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (targetType.isPrimitive()) {
            throw new ConversionFailedException(sourceType, targetType, null, new IllegalArgumentException("A null value cannot be assigned to a primitive type"));
        }
    }

    private static class Converters {
        private final Set<GenericConverter> globalConverters = new CopyOnWriteArraySet<GenericConverter>();
        private final Map<GenericConverter.ConvertiblePair, ConvertersForPair> converters = new ConcurrentHashMap<GenericConverter.ConvertiblePair, ConvertersForPair>(256);

        private Converters() {
        }

        public void add(GenericConverter converter) {
            Set<GenericConverter.ConvertiblePair> convertibleTypes = converter.getConvertibleTypes();
            if (convertibleTypes == null) {
                Assert.state(converter instanceof ConditionalConverter, "Only conditional converters may return null convertible types");
                this.globalConverters.add(converter);
            } else {
                for (GenericConverter.ConvertiblePair convertiblePair : convertibleTypes) {
                    this.getMatchableConverters(convertiblePair).add(converter);
                }
            }
        }

        private ConvertersForPair getMatchableConverters(GenericConverter.ConvertiblePair convertiblePair) {
            return this.converters.computeIfAbsent(convertiblePair, k -> new ConvertersForPair());
        }

        public void remove(Class<?> sourceType, Class<?> targetType) {
            this.converters.remove(new GenericConverter.ConvertiblePair(sourceType, targetType));
        }

        @Nullable
        public GenericConverter find(TypeDescriptor sourceType, TypeDescriptor targetType) {
            List<Class<?>> sourceCandidates = this.getClassHierarchy(sourceType.getType());
            List<Class<?>> targetCandidates = this.getClassHierarchy(targetType.getType());
            for (Class<?> sourceCandidate : sourceCandidates) {
                for (Class<?> targetCandidate : targetCandidates) {
                    GenericConverter.ConvertiblePair convertiblePair = new GenericConverter.ConvertiblePair(sourceCandidate, targetCandidate);
                    GenericConverter converter = this.getRegisteredConverter(sourceType, targetType, convertiblePair);
                    if (converter == null) continue;
                    return converter;
                }
            }
            return null;
        }

        @Nullable
        private GenericConverter getRegisteredConverter(TypeDescriptor sourceType, TypeDescriptor targetType, GenericConverter.ConvertiblePair convertiblePair) {
            GenericConverter converter;
            ConvertersForPair convertersForPair = this.converters.get(convertiblePair);
            if (convertersForPair != null && (converter = convertersForPair.getConverter(sourceType, targetType)) != null) {
                return converter;
            }
            for (GenericConverter globalConverter : this.globalConverters) {
                if (!((ConditionalConverter)((Object)globalConverter)).matches(sourceType, targetType)) continue;
                return globalConverter;
            }
            return null;
        }

        private List<Class<?>> getClassHierarchy(Class<?> type2) {
            ArrayList hierarchy = new ArrayList(20);
            HashSet visited = new HashSet(20);
            this.addToClassHierarchy(0, ClassUtils.resolvePrimitiveIfNecessary(type2), false, hierarchy, visited);
            boolean array2 = type2.isArray();
            for (int i2 = 0; i2 < hierarchy.size(); ++i2) {
                Class<?> candidate = (Class<?>)hierarchy.get(i2);
                candidate = array2 ? candidate.componentType() : ClassUtils.resolvePrimitiveIfNecessary(candidate);
                Class<?> superclass2 = candidate.getSuperclass();
                if (superclass2 != null && superclass2 != Object.class && superclass2 != Enum.class) {
                    this.addToClassHierarchy(i2 + 1, candidate.getSuperclass(), array2, hierarchy, visited);
                }
                this.addInterfacesToClassHierarchy(candidate, array2, hierarchy, visited);
            }
            if (Enum.class.isAssignableFrom(type2)) {
                this.addToClassHierarchy(hierarchy.size(), Enum.class, false, hierarchy, visited);
                this.addInterfacesToClassHierarchy(Enum.class, false, hierarchy, visited);
            }
            this.addToClassHierarchy(hierarchy.size(), Object.class, array2, hierarchy, visited);
            this.addToClassHierarchy(hierarchy.size(), Object.class, false, hierarchy, visited);
            return hierarchy;
        }

        private void addInterfacesToClassHierarchy(Class<?> type2, boolean asArray, List<Class<?>> hierarchy, Set<Class<?>> visited) {
            for (Class<?> implementedInterface : type2.getInterfaces()) {
                this.addToClassHierarchy(hierarchy.size(), implementedInterface, asArray, hierarchy, visited);
            }
        }

        private void addToClassHierarchy(int index2, Class<?> type2, boolean asArray, List<Class<?>> hierarchy, Set<Class<?>> visited) {
            if (asArray) {
                type2 = type2.arrayType();
            }
            if (visited.add((Class<?>)type2)) {
                hierarchy.add(index2, (Class<?>)type2);
            }
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("ConversionService converters =\n");
            for (String converterString : this.getConverterStrings()) {
                builder.append('\t').append(converterString).append('\n');
            }
            return builder.toString();
        }

        private List<String> getConverterStrings() {
            ArrayList<String> converterStrings = new ArrayList<String>();
            for (ConvertersForPair convertersForPair : this.converters.values()) {
                converterStrings.add(convertersForPair.toString());
            }
            Collections.sort(converterStrings);
            return converterStrings;
        }
    }

    private final class ConverterAdapter
    implements ConditionalGenericConverter {
        private final Converter<Object, Object> converter;
        private final GenericConverter.ConvertiblePair typeInfo;
        private final ResolvableType targetType;

        public ConverterAdapter(Converter<?, ?> converter, ResolvableType sourceType, ResolvableType targetType) {
            this.converter = converter;
            this.typeInfo = new GenericConverter.ConvertiblePair(sourceType.toClass(), targetType.toClass());
            this.targetType = targetType;
        }

        @Override
        public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
            return Collections.singleton(this.typeInfo);
        }

        @Override
        public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
            ConditionalConverter conditionalConverter;
            if (this.typeInfo.getTargetType() != targetType.getObjectType()) {
                return false;
            }
            ResolvableType rt = targetType.getResolvableType();
            if (!(rt.getType() instanceof Class || rt.isAssignableFrom(this.targetType) || this.targetType.hasUnresolvableGenerics())) {
                return false;
            }
            Converter<Object, Object> converter = this.converter;
            return !(converter instanceof ConditionalConverter) || (conditionalConverter = (ConditionalConverter)((Object)converter)).matches(sourceType, targetType);
        }

        @Override
        @Nullable
        public Object convert(@Nullable Object source2, TypeDescriptor sourceType, TypeDescriptor targetType) {
            if (source2 == null) {
                return GenericConversionService.this.convertNullSource(sourceType, targetType);
            }
            return this.converter.convert(source2);
        }

        public String toString() {
            return this.typeInfo + " : " + this.converter;
        }
    }

    private final class ConverterFactoryAdapter
    implements ConditionalGenericConverter {
        private final ConverterFactory<Object, Object> converterFactory;
        private final GenericConverter.ConvertiblePair typeInfo;

        public ConverterFactoryAdapter(ConverterFactory<?, ?> converterFactory, GenericConverter.ConvertiblePair typeInfo) {
            this.converterFactory = converterFactory;
            this.typeInfo = typeInfo;
        }

        @Override
        public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
            return Collections.singleton(this.typeInfo);
        }

        @Override
        public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
            Converter<Object, ?> converter;
            boolean matches = true;
            ConverterFactory<Object, Object> converterFactory = this.converterFactory;
            if (converterFactory instanceof ConditionalConverter) {
                ConditionalConverter conditionalConverter = (ConditionalConverter)((Object)converterFactory);
                matches = conditionalConverter.matches(sourceType, targetType);
            }
            if (matches && (converter = this.converterFactory.getConverter(targetType.getType())) instanceof ConditionalConverter) {
                ConditionalConverter conditionalConverter = (ConditionalConverter)((Object)converter);
                matches = conditionalConverter.matches(sourceType, targetType);
            }
            return matches;
        }

        @Override
        @Nullable
        public Object convert(@Nullable Object source2, TypeDescriptor sourceType, TypeDescriptor targetType) {
            if (source2 == null) {
                return GenericConversionService.this.convertNullSource(sourceType, targetType);
            }
            return this.converterFactory.getConverter(targetType.getObjectType()).convert(source2);
        }

        public String toString() {
            return this.typeInfo + " : " + this.converterFactory;
        }
    }

    private static final class ConverterCacheKey
    implements Comparable<ConverterCacheKey> {
        private final TypeDescriptor sourceType;
        private final TypeDescriptor targetType;

        public ConverterCacheKey(TypeDescriptor sourceType, TypeDescriptor targetType) {
            this.sourceType = sourceType;
            this.targetType = targetType;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(@Nullable Object other) {
            if (this == other) return true;
            if (!(other instanceof ConverterCacheKey)) return false;
            ConverterCacheKey that = (ConverterCacheKey)other;
            if (!this.sourceType.equals(that.sourceType)) return false;
            if (!this.targetType.equals(that.targetType)) return false;
            return true;
        }

        public int hashCode() {
            return this.sourceType.hashCode() * 29 + this.targetType.hashCode();
        }

        public String toString() {
            return "ConverterCacheKey [sourceType = " + this.sourceType + ", targetType = " + this.targetType + "]";
        }

        @Override
        public int compareTo(ConverterCacheKey other) {
            int result2 = this.sourceType.getResolvableType().toString().compareTo(other.sourceType.getResolvableType().toString());
            if (result2 == 0) {
                result2 = this.targetType.getResolvableType().toString().compareTo(other.targetType.getResolvableType().toString());
            }
            return result2;
        }
    }

    private static class NoOpConverter
    implements GenericConverter {
        private final String name;

        public NoOpConverter(String name2) {
            this.name = name2;
        }

        @Override
        @Nullable
        public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
            return null;
        }

        @Override
        @Nullable
        public Object convert(@Nullable Object source2, TypeDescriptor sourceType, TypeDescriptor targetType) {
            return source2;
        }

        public String toString() {
            return this.name;
        }
    }

    private static class ConvertersForPair {
        private final Deque<GenericConverter> converters = new ConcurrentLinkedDeque<GenericConverter>();

        private ConvertersForPair() {
        }

        public void add(GenericConverter converter) {
            this.converters.addFirst(converter);
        }

        @Nullable
        public GenericConverter getConverter(TypeDescriptor sourceType, TypeDescriptor targetType) {
            for (GenericConverter converter : this.converters) {
                ConditionalGenericConverter genericConverter;
                if (converter instanceof ConditionalGenericConverter && !(genericConverter = (ConditionalGenericConverter)converter).matches(sourceType, targetType)) continue;
                return converter;
            }
            return null;
        }

        public String toString() {
            return StringUtils.collectionToCommaDelimitedString(this.converters);
        }
    }
}

