/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert.support;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.ConversionUtils;
import org.springframework.lang.Nullable;

final class ArrayToCollectionConverter
implements ConditionalGenericConverter {
    private final ConversionService conversionService;

    public ArrayToCollectionConverter(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(Object[].class, Collection.class));
    }

    @Override
    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        return ConversionUtils.canConvertElements(sourceType.getElementTypeDescriptor(), targetType.getElementTypeDescriptor(), this.conversionService);
    }

    @Override
    @Nullable
    public Object convert(@Nullable Object source2, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source2 == null) {
            return null;
        }
        int length2 = Array.getLength(source2);
        TypeDescriptor elementDesc = targetType.getElementTypeDescriptor();
        Collection<Object> target2 = this.createCollection(targetType.getType(), elementDesc != null ? elementDesc.getType() : null, length2);
        if (elementDesc == null) {
            for (int i2 = 0; i2 < length2; ++i2) {
                Object sourceElement = Array.get(source2, i2);
                target2.add(sourceElement);
            }
        } else {
            for (int i3 = 0; i3 < length2; ++i3) {
                Object sourceElement = Array.get(source2, i3);
                Object targetElement = this.conversionService.convert(sourceElement, sourceType.elementTypeDescriptor(sourceElement), elementDesc);
                target2.add(targetElement);
            }
        }
        return target2;
    }

    private Collection<Object> createCollection(Class<?> targetType, @Nullable Class<?> elementType, int length2) {
        if (targetType.isInterface() && targetType.isAssignableFrom(ArrayList.class)) {
            return new ArrayList<Object>(length2);
        }
        return CollectionFactory.createCollection(targetType, elementType, length2);
    }
}

