/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.core.annotation.AnnotationConfigurationException;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.AttributeMethods;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;

final class SynthesizedMergedAnnotationInvocationHandler<A extends Annotation>
implements InvocationHandler {
    private final MergedAnnotation<?> annotation;
    private final Class<A> type;
    private final AttributeMethods attributes;
    private final Map<String, Object> valueCache = new ConcurrentHashMap<String, Object>(8);
    @Nullable
    private volatile Integer hashCode;
    @Nullable
    private volatile String string;

    private SynthesizedMergedAnnotationInvocationHandler(MergedAnnotation<A> annotation, Class<A> type2) {
        Assert.notNull(annotation, "MergedAnnotation must not be null");
        Assert.notNull(type2, "Type must not be null");
        Assert.isTrue(type2.isAnnotation(), "Type must be an annotation");
        this.annotation = annotation;
        this.type = type2;
        this.attributes = AttributeMethods.forAnnotationType(type2);
    }

    @Override
    public Object invoke(Object proxy2, Method method2, Object[] args2) {
        if (this.attributes.indexOf(method2.getName()) != -1) {
            return this.getAttributeValue(method2);
        }
        if (method2.getParameterCount() == 0) {
            switch (method2.getName()) {
                case "annotationType": {
                    return this.type;
                }
                case "hashCode": {
                    return this.annotationHashCode();
                }
                case "toString": {
                    return this.annotationToString();
                }
            }
        }
        if (ReflectionUtils.isEqualsMethod(method2)) {
            return this.annotationEquals(args2[0]);
        }
        throw new AnnotationConfigurationException(String.format("Method [%s] is unsupported for synthesized annotation type [%s]", method2, this.type));
    }

    private boolean annotationEquals(Object other) {
        if (this == other) {
            return true;
        }
        if (!this.type.isInstance(other)) {
            return false;
        }
        for (int i2 = 0; i2 < this.attributes.size(); ++i2) {
            Object otherValue;
            Method attribute = this.attributes.get(i2);
            Object thisValue = this.getAttributeValue(attribute);
            if (ObjectUtils.nullSafeEquals(thisValue, otherValue = AnnotationUtils.invokeAnnotationMethod(attribute, other))) continue;
            return false;
        }
        return true;
    }

    private int annotationHashCode() {
        Integer hashCode = this.hashCode;
        if (hashCode == null) {
            this.hashCode = hashCode = this.computeHashCode();
        }
        return hashCode;
    }

    private Integer computeHashCode() {
        int hashCode = 0;
        for (int i2 = 0; i2 < this.attributes.size(); ++i2) {
            Method attribute = this.attributes.get(i2);
            Object value2 = this.getAttributeValue(attribute);
            hashCode += 127 * attribute.getName().hashCode() ^ ObjectUtils.nullSafeHashCode(value2);
        }
        return hashCode;
    }

    private String annotationToString() {
        String string2 = this.string;
        if (string2 == null) {
            StringBuilder builder = new StringBuilder("@").append(SynthesizedMergedAnnotationInvocationHandler.getName(this.type)).append('(');
            for (int i2 = 0; i2 < this.attributes.size(); ++i2) {
                Method attribute = this.attributes.get(i2);
                if (i2 > 0) {
                    builder.append(", ");
                }
                builder.append(attribute.getName());
                builder.append('=');
                builder.append(this.toString(this.getAttributeValue(attribute)));
            }
            builder.append(')');
            this.string = string2 = builder.toString();
        }
        return string2;
    }

    private String toString(Object value2) {
        if (value2 instanceof String) {
            String str = (String)value2;
            return "\"" + str + "\"";
        }
        if (value2 instanceof Character) {
            return "'" + value2.toString() + "'";
        }
        if (value2 instanceof Byte) {
            return String.format("(byte) 0x%02X", value2);
        }
        if (value2 instanceof Long) {
            Long longValue = (Long)value2;
            return Long.toString(longValue) + "L";
        }
        if (value2 instanceof Float) {
            Float floatValue = (Float)value2;
            return Float.toString(floatValue.floatValue()) + "f";
        }
        if (value2 instanceof Double) {
            Double doubleValue = (Double)value2;
            return Double.toString(doubleValue) + "d";
        }
        if (value2 instanceof Enum) {
            Enum e = (Enum)value2;
            return e.name();
        }
        if (value2 instanceof Class) {
            Class clazz = (Class)value2;
            return SynthesizedMergedAnnotationInvocationHandler.getName(clazz) + ".class";
        }
        if (value2.getClass().isArray()) {
            StringBuilder builder = new StringBuilder("{");
            for (int i2 = 0; i2 < Array.getLength(value2); ++i2) {
                if (i2 > 0) {
                    builder.append(", ");
                }
                builder.append(this.toString(Array.get(value2, i2)));
            }
            builder.append('}');
            return builder.toString();
        }
        return String.valueOf(value2);
    }

    private Object getAttributeValue(Method method2) {
        Object value2 = this.valueCache.computeIfAbsent(method2.getName(), attributeName -> {
            Class<?> type2 = ClassUtils.resolvePrimitiveIfNecessary(method2.getReturnType());
            return this.annotation.getValue((String)attributeName, type2).orElseThrow(() -> new NoSuchElementException("No value found for attribute named '" + attributeName + "' in merged annotation " + this.annotation.getType().getName()));
        });
        if (value2.getClass().isArray() && Array.getLength(value2) > 0) {
            value2 = this.cloneArray(value2);
        }
        return value2;
    }

    private Object cloneArray(Object array2) {
        if (array2 instanceof boolean[]) {
            boolean[] booleans = (boolean[])array2;
            return booleans.clone();
        }
        if (array2 instanceof byte[]) {
            byte[] bytes2 = (byte[])array2;
            return bytes2.clone();
        }
        if (array2 instanceof char[]) {
            char[] chars2 = (char[])array2;
            return chars2.clone();
        }
        if (array2 instanceof double[]) {
            double[] doubles = (double[])array2;
            return doubles.clone();
        }
        if (array2 instanceof float[]) {
            float[] floats = (float[])array2;
            return floats.clone();
        }
        if (array2 instanceof int[]) {
            int[] ints = (int[])array2;
            return ints.clone();
        }
        if (array2 instanceof long[]) {
            long[] longs = (long[])array2;
            return longs.clone();
        }
        if (array2 instanceof short[]) {
            short[] shorts = (short[])array2;
            return shorts.clone();
        }
        return ((Object[])array2).clone();
    }

    static <A extends Annotation> A createProxy(MergedAnnotation<A> annotation, Class<A> type2) {
        ClassLoader classLoader = type2.getClassLoader();
        Class[] interfaces2 = new Class[]{type2};
        SynthesizedMergedAnnotationInvocationHandler<A> handler = new SynthesizedMergedAnnotationInvocationHandler<A>(annotation, type2);
        return (A)((Annotation)Proxy.newProxyInstance(classLoader, interfaces2, handler));
    }

    private static String getName(Class<?> clazz) {
        String canonicalName = clazz.getCanonicalName();
        return canonicalName != null ? canonicalName : clazz.getName();
    }
}

