/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.annotation;

import java.lang.reflect.AnnotatedElement;
import java.util.Map;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.annotation.Order;
import org.springframework.lang.Nullable;
import org.springframework.util.ConcurrentReferenceHashMap;

public abstract class OrderUtils {
    private static final Object NOT_ANNOTATED = new Object();
    private static final String JAKARTA_PRIORITY_ANNOTATION = "jakarta.annotation.Priority";
    static final Map<AnnotatedElement, Object> orderCache = new ConcurrentReferenceHashMap<AnnotatedElement, Object>(64);

    public static int getOrder(Class<?> type2, int defaultOrder) {
        Integer order2 = OrderUtils.getOrder(type2);
        return order2 != null ? order2 : defaultOrder;
    }

    @Nullable
    public static Integer getOrder(Class<?> type2, @Nullable Integer defaultOrder) {
        Integer order2 = OrderUtils.getOrder(type2);
        return order2 != null ? order2 : defaultOrder;
    }

    @Nullable
    public static Integer getOrder(Class<?> type2) {
        return OrderUtils.getOrder(type2);
    }

    @Nullable
    public static Integer getOrder(AnnotatedElement element) {
        return OrderUtils.getOrderFromAnnotations(element, MergedAnnotations.from(element, MergedAnnotations.SearchStrategy.TYPE_HIERARCHY));
    }

    @Nullable
    static Integer getOrderFromAnnotations(AnnotatedElement element, MergedAnnotations annotations) {
        if (!(element instanceof Class)) {
            return OrderUtils.findOrder(annotations);
        }
        Object cached = orderCache.get(element);
        if (cached != null) {
            Integer integer;
            return cached instanceof Integer ? (integer = (Integer)cached) : null;
        }
        Integer result2 = OrderUtils.findOrder(annotations);
        orderCache.put(element, result2 != null ? result2 : NOT_ANNOTATED);
        return result2;
    }

    @Nullable
    private static Integer findOrder(MergedAnnotations annotations) {
        MergedAnnotation<Order> orderAnnotation = annotations.get(Order.class);
        if (orderAnnotation.isPresent()) {
            return orderAnnotation.getInt("value");
        }
        MergedAnnotation priorityAnnotation = annotations.get(JAKARTA_PRIORITY_ANNOTATION);
        if (priorityAnnotation.isPresent()) {
            return priorityAnnotation.getInt("value");
        }
        return null;
    }

    @Nullable
    public static Integer getPriority(Class<?> type2) {
        return MergedAnnotations.from(type2, MergedAnnotations.SearchStrategy.TYPE_HIERARCHY).get(JAKARTA_PRIORITY_ANNOTATION).getValue("value", Integer.class).orElse(null);
    }
}

