/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.annotation;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.lang.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
enum IntrospectionFailureLogger {
    DEBUG{

        @Override
        public boolean isEnabled() {
            return IntrospectionFailureLogger.getLogger().isDebugEnabled();
        }

        @Override
        public void log(String message2) {
            IntrospectionFailureLogger.getLogger().debug(message2);
        }
    }
    ,
    INFO{

        @Override
        public boolean isEnabled() {
            return IntrospectionFailureLogger.getLogger().isInfoEnabled();
        }

        @Override
        public void log(String message2) {
            IntrospectionFailureLogger.getLogger().info(message2);
        }
    };

    @Nullable
    private static Log logger;

    void log(String message2, @Nullable Object source2, Exception ex) {
        Object on = source2 != null ? " on " + source2 : "";
        this.log(message2 + (String)on + ": " + ex);
    }

    abstract boolean isEnabled();

    abstract void log(String var1);

    private static Log getLogger() {
        Log logger = IntrospectionFailureLogger.logger;
        if (logger == null) {
            IntrospectionFailureLogger.logger = logger = LogFactory.getLog(MergedAnnotation.class);
        }
        return logger;
    }
}

