/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.annotation;

import java.lang.annotation.Annotation;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.annotation.AliasFor;
import org.springframework.core.annotation.AnnotationConfigurationException;
import org.springframework.core.annotation.AnnotationTypeMappings;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.AnnotationsScanner;
import org.springframework.core.annotation.AttributeMethods;
import org.springframework.core.annotation.TypeMappedAnnotation;
import org.springframework.core.annotation.ValueExtractor;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

final class AnnotationTypeMapping {
    private static final Log logger = LogFactory.getLog(AnnotationTypeMapping.class);
    private static final Predicate<? super Annotation> isBeanValidationConstraint = annotation -> annotation.annotationType().getName().equals("jakarta.validation.Constraint");
    private static final Set<String> conventionBasedOverrideCheckCache = ConcurrentHashMap.newKeySet();
    private static final MirrorSets.MirrorSet[] EMPTY_MIRROR_SETS = new MirrorSets.MirrorSet[0];
    @Nullable
    private final AnnotationTypeMapping source;
    private final AnnotationTypeMapping root;
    private final int distance;
    private final Class<? extends Annotation> annotationType;
    private final List<Class<? extends Annotation>> metaTypes;
    @Nullable
    private final Annotation annotation;
    private final AttributeMethods attributes;
    private final MirrorSets mirrorSets;
    private final int[] aliasMappings;
    private final int[] conventionMappings;
    private final int[] annotationValueMappings;
    private final AnnotationTypeMapping[] annotationValueSource;
    private final Map<Method, List<Method>> aliasedBy;
    private final boolean synthesizable;
    private final Set<Method> claimedAliases = new HashSet<Method>();

    AnnotationTypeMapping(@Nullable AnnotationTypeMapping source2, Class<? extends Annotation> annotationType, @Nullable Annotation annotation, Set<Class<? extends Annotation>> visitedAnnotationTypes) {
        this.source = source2;
        this.root = source2 != null ? source2.getRoot() : this;
        this.distance = source2 == null ? 0 : source2.getDistance() + 1;
        this.annotationType = annotationType;
        this.metaTypes = AnnotationTypeMapping.merge(source2 != null ? source2.getMetaTypes() : null, annotationType);
        this.annotation = annotation;
        this.attributes = AttributeMethods.forAnnotationType(annotationType);
        this.mirrorSets = new MirrorSets();
        this.aliasMappings = AnnotationTypeMapping.filledIntArray(this.attributes.size());
        this.conventionMappings = AnnotationTypeMapping.filledIntArray(this.attributes.size());
        this.annotationValueMappings = AnnotationTypeMapping.filledIntArray(this.attributes.size());
        this.annotationValueSource = new AnnotationTypeMapping[this.attributes.size()];
        this.aliasedBy = this.resolveAliasedForTargets();
        this.processAliases();
        this.addConventionMappings();
        this.addConventionAnnotationValues();
        this.synthesizable = this.computeSynthesizableFlag(visitedAnnotationTypes);
    }

    private static <T> List<T> merge(@Nullable List<T> existing, T element) {
        if (existing == null) {
            return Collections.singletonList(element);
        }
        ArrayList<T> merged = new ArrayList<T>(existing.size() + 1);
        merged.addAll(existing);
        merged.add(element);
        return Collections.unmodifiableList(merged);
    }

    private Map<Method, List<Method>> resolveAliasedForTargets() {
        HashMap<Method, List> aliasedBy = new HashMap<Method, List>();
        for (int i2 = 0; i2 < this.attributes.size(); ++i2) {
            Method attribute = this.attributes.get(i2);
            AliasFor aliasFor = AnnotationsScanner.getDeclaredAnnotation(attribute, AliasFor.class);
            if (aliasFor == null) continue;
            Method target2 = this.resolveAliasTarget(attribute, aliasFor);
            aliasedBy.computeIfAbsent(target2, key2 -> new ArrayList()).add(attribute);
        }
        return Collections.unmodifiableMap(aliasedBy);
    }

    private Method resolveAliasTarget(Method attribute, AliasFor aliasFor) {
        return this.resolveAliasTarget(attribute, aliasFor, true);
    }

    private Method resolveAliasTarget(Method attribute, AliasFor aliasFor, boolean checkAliasPair) {
        Method mirror;
        AliasFor targetAliasFor;
        Method target2;
        String targetAttributeName;
        if (StringUtils.hasText(aliasFor.value()) && StringUtils.hasText(aliasFor.attribute())) {
            throw new AnnotationConfigurationException(String.format("In @AliasFor declared on %s, attribute 'attribute' and its alias 'value' are present with values of '%s' and '%s', but only one is permitted.", AttributeMethods.describe(attribute), aliasFor.attribute(), aliasFor.value()));
        }
        Class<? extends Annotation> targetAnnotation = aliasFor.annotation();
        if (targetAnnotation == Annotation.class) {
            targetAnnotation = this.annotationType;
        }
        if (!StringUtils.hasLength(targetAttributeName = aliasFor.attribute())) {
            targetAttributeName = aliasFor.value();
        }
        if (!StringUtils.hasLength(targetAttributeName)) {
            targetAttributeName = attribute.getName();
        }
        if ((target2 = AttributeMethods.forAnnotationType(targetAnnotation).get(targetAttributeName)) == null) {
            if (targetAnnotation == this.annotationType) {
                throw new AnnotationConfigurationException(String.format("@AliasFor declaration on %s declares an alias for '%s' which is not present.", AttributeMethods.describe(attribute), targetAttributeName));
            }
            throw new AnnotationConfigurationException(String.format("%s is declared as an @AliasFor nonexistent %s.", StringUtils.capitalize(AttributeMethods.describe(attribute)), AttributeMethods.describe(targetAnnotation, targetAttributeName)));
        }
        if (target2.equals(attribute)) {
            throw new AnnotationConfigurationException(String.format("@AliasFor declaration on %s points to itself. Specify 'annotation' to point to a same-named attribute on a meta-annotation.", AttributeMethods.describe(attribute)));
        }
        if (!this.isCompatibleReturnType(attribute.getReturnType(), target2.getReturnType())) {
            throw new AnnotationConfigurationException(String.format("Misconfigured aliases: %s and %s must declare the same return type.", AttributeMethods.describe(attribute), AttributeMethods.describe(target2)));
        }
        if (this.isAliasPair(target2) && checkAliasPair && (targetAliasFor = target2.getAnnotation(AliasFor.class)) != null && !(mirror = this.resolveAliasTarget(target2, targetAliasFor, false)).equals(attribute)) {
            throw new AnnotationConfigurationException(String.format("%s must be declared as an @AliasFor %s, not %s.", StringUtils.capitalize(AttributeMethods.describe(target2)), AttributeMethods.describe(attribute), AttributeMethods.describe(mirror)));
        }
        return target2;
    }

    private boolean isAliasPair(Method target2) {
        return this.annotationType == target2.getDeclaringClass();
    }

    private boolean isCompatibleReturnType(Class<?> attributeType, Class<?> targetType) {
        return attributeType == targetType || attributeType == targetType.componentType();
    }

    private void processAliases() {
        ArrayList<Method> aliases2 = new ArrayList<Method>();
        for (int i2 = 0; i2 < this.attributes.size(); ++i2) {
            aliases2.clear();
            aliases2.add(this.attributes.get(i2));
            this.collectAliases(aliases2);
            if (aliases2.size() <= 1) continue;
            this.processAliases(i2, aliases2);
        }
    }

    private void collectAliases(List<Method> aliases2) {
        AnnotationTypeMapping mapping = this;
        while (mapping != null) {
            int size2 = aliases2.size();
            for (int j = 0; j < size2; ++j) {
                List<Method> additional = mapping.aliasedBy.get(aliases2.get(j));
                if (additional == null) continue;
                aliases2.addAll(additional);
            }
            mapping = mapping.source;
        }
    }

    private void processAliases(int attributeIndex, List<Method> aliases2) {
        int rootAttributeIndex = this.getFirstRootAttributeIndex(aliases2);
        AnnotationTypeMapping mapping = this;
        while (mapping != null) {
            if (rootAttributeIndex != -1 && mapping != this.root) {
                for (int i2 = 0; i2 < mapping.attributes.size(); ++i2) {
                    if (!aliases2.contains(mapping.attributes.get(i2))) continue;
                    mapping.aliasMappings[i2] = rootAttributeIndex;
                }
            }
            mapping.mirrorSets.updateFrom(aliases2);
            mapping.claimedAliases.addAll(aliases2);
            if (mapping.annotation != null) {
                int[] resolvedMirrors = mapping.mirrorSets.resolve(null, mapping.annotation, AnnotationUtils::invokeAnnotationMethod);
                for (int i3 = 0; i3 < mapping.attributes.size(); ++i3) {
                    if (!aliases2.contains(mapping.attributes.get(i3))) continue;
                    this.annotationValueMappings[attributeIndex] = resolvedMirrors[i3];
                    this.annotationValueSource[attributeIndex] = mapping;
                }
            }
            mapping = mapping.source;
        }
    }

    private int getFirstRootAttributeIndex(Collection<Method> aliases2) {
        AttributeMethods rootAttributes = this.root.getAttributes();
        for (int i2 = 0; i2 < rootAttributes.size(); ++i2) {
            if (!aliases2.contains(rootAttributes.get(i2))) continue;
            return i2;
        }
        return -1;
    }

    private void addConventionMappings() {
        if (this.distance == 0) {
            return;
        }
        AttributeMethods rootAttributes = this.root.getAttributes();
        int[] mappings = this.conventionMappings;
        HashSet<String> conventionMappedAttributes = new HashSet<String>();
        for (int i2 = 0; i2 < mappings.length; ++i2) {
            String name2 = this.attributes.get(i2).getName();
            int mapped = rootAttributes.indexOf(name2);
            if ("value".equals(name2) || mapped == -1 || this.isExplicitAttributeOverride(name2)) continue;
            conventionMappedAttributes.add(name2);
            mappings[i2] = mapped;
            MirrorSets.MirrorSet mirrors = this.getMirrorSets().getAssigned(i2);
            if (mirrors == null) continue;
            for (int j = 0; j < mirrors.size(); ++j) {
                mappings[mirrors.getAttributeIndex((int)j)] = mapped;
            }
        }
        String rootAnnotationTypeName = this.root.annotationType.getName();
        String cacheKey = rootAnnotationTypeName + "-" + this.annotationType.getName();
        if (conventionBasedOverrideCheckCache.add(cacheKey) && !conventionMappedAttributes.isEmpty() && Arrays.stream(this.annotationType.getAnnotations()).noneMatch(isBeanValidationConstraint) && logger.isWarnEnabled()) {
            logger.warn("Support for convention-based annotation attribute overrides is deprecated and will be removed in Spring Framework 6.2. Please annotate the following attributes in @%s with appropriate @AliasFor declarations: %s".formatted(rootAnnotationTypeName, conventionMappedAttributes));
        }
    }

    private boolean isExplicitAttributeOverride(String name2) {
        Method attribute = this.root.getAttributes().get(name2);
        if (attribute != null) {
            AliasFor aliasFor = AnnotationsScanner.getDeclaredAnnotation(attribute, AliasFor.class);
            return aliasFor != null && aliasFor.annotation() != Annotation.class && aliasFor.annotation() != this.root.annotationType;
        }
        return false;
    }

    private void addConventionAnnotationValues() {
        for (int i2 = 0; i2 < this.attributes.size(); ++i2) {
            Method attribute = this.attributes.get(i2);
            boolean isValueAttribute = "value".equals(attribute.getName());
            AnnotationTypeMapping mapping = this;
            while (mapping != null && mapping.distance > 0) {
                int mapped = mapping.getAttributes().indexOf(attribute.getName());
                if (mapped != -1 && this.isBetterConventionAnnotationValue(i2, isValueAttribute, mapping)) {
                    this.annotationValueMappings[i2] = mapped;
                    this.annotationValueSource[i2] = mapping;
                }
                mapping = mapping.source;
            }
        }
    }

    private boolean isBetterConventionAnnotationValue(int index2, boolean isValueAttribute, AnnotationTypeMapping mapping) {
        if (this.annotationValueMappings[index2] == -1) {
            return true;
        }
        int existingDistance = this.annotationValueSource[index2].distance;
        return !isValueAttribute && existingDistance > mapping.distance;
    }

    private boolean computeSynthesizableFlag(Set<Class<? extends Annotation>> visitedAnnotationTypes) {
        visitedAnnotationTypes.add(this.annotationType);
        for (int index2 : this.aliasMappings) {
            if (index2 == -1) continue;
            return true;
        }
        if (!this.aliasedBy.isEmpty()) {
            return true;
        }
        for (int index2 : this.conventionMappings) {
            if (index2 == -1) continue;
            return true;
        }
        if (this.getAttributes().hasNestedAnnotation()) {
            AttributeMethods attributeMethods = this.getAttributes();
            for (int i2 = 0; i2 < attributeMethods.size(); ++i2) {
                AnnotationTypeMapping mapping;
                TypeDescriptor.OfField<Class<?>> annotationType;
                Method method2 = attributeMethods.get(i2);
                Class<?> type2 = method2.getReturnType();
                if (!type2.isAnnotation() && (!type2.isArray() || !((Class)type2.componentType()).isAnnotation())) continue;
                TypeDescriptor.OfField<Class<?>> ofField = annotationType = type2.isAnnotation() ? type2 : type2.componentType();
                if (!visitedAnnotationTypes.add((Class<? extends Annotation>)annotationType) || !(mapping = AnnotationTypeMappings.forAnnotationType(annotationType, visitedAnnotationTypes).get(0)).isSynthesizable()) continue;
                return true;
            }
        }
        return false;
    }

    void afterAllMappingsSet() {
        this.validateAllAliasesClaimed();
        for (int i2 = 0; i2 < this.mirrorSets.size(); ++i2) {
            this.validateMirrorSet(this.mirrorSets.get(i2));
        }
        this.claimedAliases.clear();
    }

    private void validateAllAliasesClaimed() {
        for (int i2 = 0; i2 < this.attributes.size(); ++i2) {
            Method attribute = this.attributes.get(i2);
            AliasFor aliasFor = AnnotationsScanner.getDeclaredAnnotation(attribute, AliasFor.class);
            if (aliasFor == null || this.claimedAliases.contains(attribute)) continue;
            Method target2 = this.resolveAliasTarget(attribute, aliasFor);
            throw new AnnotationConfigurationException(String.format("@AliasFor declaration on %s declares an alias for %s which is not meta-present.", AttributeMethods.describe(attribute), AttributeMethods.describe(target2)));
        }
    }

    private void validateMirrorSet(MirrorSets.MirrorSet mirrorSet) {
        Method firstAttribute = mirrorSet.get(0);
        Object firstDefaultValue = firstAttribute.getDefaultValue();
        for (int i2 = 1; i2 <= mirrorSet.size() - 1; ++i2) {
            Method mirrorAttribute = mirrorSet.get(i2);
            Object mirrorDefaultValue = mirrorAttribute.getDefaultValue();
            if (firstDefaultValue == null || mirrorDefaultValue == null) {
                throw new AnnotationConfigurationException(String.format("Misconfigured aliases: %s and %s must declare default values.", AttributeMethods.describe(firstAttribute), AttributeMethods.describe(mirrorAttribute)));
            }
            if (ObjectUtils.nullSafeEquals(firstDefaultValue, mirrorDefaultValue)) continue;
            throw new AnnotationConfigurationException(String.format("Misconfigured aliases: %s and %s must declare the same default value.", AttributeMethods.describe(firstAttribute), AttributeMethods.describe(mirrorAttribute)));
        }
    }

    AnnotationTypeMapping getRoot() {
        return this.root;
    }

    @Nullable
    AnnotationTypeMapping getSource() {
        return this.source;
    }

    int getDistance() {
        return this.distance;
    }

    Class<? extends Annotation> getAnnotationType() {
        return this.annotationType;
    }

    List<Class<? extends Annotation>> getMetaTypes() {
        return this.metaTypes;
    }

    @Nullable
    Annotation getAnnotation() {
        return this.annotation;
    }

    AttributeMethods getAttributes() {
        return this.attributes;
    }

    int getAliasMapping(int attributeIndex) {
        return this.aliasMappings[attributeIndex];
    }

    int getConventionMapping(int attributeIndex) {
        return this.conventionMappings[attributeIndex];
    }

    @Nullable
    Object getMappedAnnotationValue(int attributeIndex, boolean metaAnnotationsOnly) {
        int mappedIndex = this.annotationValueMappings[attributeIndex];
        if (mappedIndex == -1) {
            return null;
        }
        AnnotationTypeMapping source2 = this.annotationValueSource[attributeIndex];
        if (source2 == this && metaAnnotationsOnly) {
            return null;
        }
        return AnnotationUtils.invokeAnnotationMethod(source2.attributes.get(mappedIndex), source2.annotation);
    }

    boolean isEquivalentToDefaultValue(int attributeIndex, Object value2, ValueExtractor valueExtractor) {
        Method attribute = this.attributes.get(attributeIndex);
        return AnnotationTypeMapping.isEquivalentToDefaultValue(attribute, value2, valueExtractor);
    }

    MirrorSets getMirrorSets() {
        return this.mirrorSets;
    }

    boolean isSynthesizable() {
        return this.synthesizable;
    }

    private static int[] filledIntArray(int size2) {
        int[] array2 = new int[size2];
        Arrays.fill(array2, -1);
        return array2;
    }

    private static boolean isEquivalentToDefaultValue(Method attribute, Object value2, ValueExtractor valueExtractor) {
        return AnnotationTypeMapping.areEquivalent(attribute.getDefaultValue(), value2, valueExtractor);
    }

    private static boolean areEquivalent(@Nullable Object value2, @Nullable Object extractedValue, ValueExtractor valueExtractor) {
        if (ObjectUtils.nullSafeEquals(value2, extractedValue)) {
            return true;
        }
        if (value2 instanceof Class) {
            Class clazz = (Class)value2;
            if (extractedValue instanceof String) {
                String string2 = (String)extractedValue;
                return AnnotationTypeMapping.areEquivalent(clazz, string2);
            }
        }
        if (value2 instanceof Class[]) {
            Class[] classes = (Class[])value2;
            if (extractedValue instanceof String[]) {
                String[] strings = (String[])extractedValue;
                return AnnotationTypeMapping.areEquivalent(classes, strings);
            }
        }
        if (value2 instanceof Annotation) {
            Annotation annotation = (Annotation)value2;
            return AnnotationTypeMapping.areEquivalent(annotation, extractedValue, valueExtractor);
        }
        return false;
    }

    private static boolean areEquivalent(Class<?>[] value2, String[] extractedValue) {
        if (value2.length != extractedValue.length) {
            return false;
        }
        for (int i2 = 0; i2 < value2.length; ++i2) {
            if (AnnotationTypeMapping.areEquivalent(value2[i2], extractedValue[i2])) continue;
            return false;
        }
        return true;
    }

    private static boolean areEquivalent(Class<?> value2, String extractedValue) {
        return value2.getName().equals(extractedValue);
    }

    private static boolean areEquivalent(Annotation annotation, @Nullable Object extractedValue, ValueExtractor valueExtractor) {
        AttributeMethods attributes = AttributeMethods.forAnnotationType(annotation.annotationType());
        for (int i2 = 0; i2 < attributes.size(); ++i2) {
            Object value2;
            Method attribute = attributes.get(i2);
            Object value1 = AnnotationUtils.invokeAnnotationMethod(attribute, annotation);
            if (extractedValue instanceof TypeMappedAnnotation) {
                TypeMappedAnnotation typeMappedAnnotation = (TypeMappedAnnotation)extractedValue;
                value2 = typeMappedAnnotation.getValue(attribute.getName()).orElse(null);
            } else {
                value2 = valueExtractor.extract(attribute, extractedValue);
            }
            if (AnnotationTypeMapping.areEquivalent(value1, value2, valueExtractor)) continue;
            return false;
        }
        return true;
    }

    class MirrorSets {
        private MirrorSet[] mirrorSets;
        private final MirrorSet[] assigned;

        MirrorSets() {
            this.assigned = new MirrorSet[AnnotationTypeMapping.this.attributes.size()];
            this.mirrorSets = EMPTY_MIRROR_SETS;
        }

        void updateFrom(Collection<Method> aliases2) {
            MirrorSet mirrorSet = null;
            int size2 = 0;
            int last2 = -1;
            for (int i2 = 0; i2 < AnnotationTypeMapping.this.attributes.size(); ++i2) {
                Method attribute = AnnotationTypeMapping.this.attributes.get(i2);
                if (!aliases2.contains(attribute)) continue;
                if (++size2 > 1) {
                    if (mirrorSet == null) {
                        this.assigned[last2] = mirrorSet = new MirrorSet();
                    }
                    this.assigned[i2] = mirrorSet;
                }
                last2 = i2;
            }
            if (mirrorSet != null) {
                mirrorSet.update();
                LinkedHashSet<MirrorSet> unique = new LinkedHashSet<MirrorSet>(Arrays.asList(this.assigned));
                unique.remove(null);
                this.mirrorSets = unique.toArray(EMPTY_MIRROR_SETS);
            }
        }

        int size() {
            return this.mirrorSets.length;
        }

        MirrorSet get(int index2) {
            return this.mirrorSets[index2];
        }

        @Nullable
        MirrorSet getAssigned(int attributeIndex) {
            return this.assigned[attributeIndex];
        }

        int[] resolve(@Nullable Object source2, @Nullable Object annotation, ValueExtractor valueExtractor) {
            int i2;
            int[] result2 = new int[AnnotationTypeMapping.this.attributes.size()];
            for (i2 = 0; i2 < result2.length; ++i2) {
                result2[i2] = i2;
            }
            for (i2 = 0; i2 < this.size(); ++i2) {
                MirrorSet mirrorSet = this.get(i2);
                int resolved = mirrorSet.resolve(source2, annotation, valueExtractor);
                for (int j = 0; j < mirrorSet.size; ++j) {
                    result2[mirrorSet.indexes[j]] = resolved;
                }
            }
            return result2;
        }

        class MirrorSet {
            private int size;
            private final int[] indexes;

            MirrorSet() {
                this.indexes = new int[AnnotationTypeMapping.this.attributes.size()];
            }

            void update() {
                this.size = 0;
                Arrays.fill(this.indexes, -1);
                for (int i2 = 0; i2 < MirrorSets.this.assigned.length; ++i2) {
                    if (MirrorSets.this.assigned[i2] != this) continue;
                    this.indexes[this.size] = i2;
                    ++this.size;
                }
            }

            <A> int resolve(@Nullable Object source2, @Nullable A annotation, ValueExtractor valueExtractor) {
                int result2 = -1;
                Object lastValue = null;
                for (int i2 = 0; i2 < this.size; ++i2) {
                    boolean isDefaultValue;
                    Method attribute = AnnotationTypeMapping.this.attributes.get(this.indexes[i2]);
                    Object value2 = valueExtractor.extract(attribute, annotation);
                    boolean bl = isDefaultValue = value2 == null || AnnotationTypeMapping.isEquivalentToDefaultValue(attribute, value2, valueExtractor);
                    if (isDefaultValue || ObjectUtils.nullSafeEquals(lastValue, value2)) {
                        if (result2 != -1) continue;
                        result2 = this.indexes[i2];
                        continue;
                    }
                    if (lastValue != null && !ObjectUtils.nullSafeEquals(lastValue, value2)) {
                        Object on = source2 != null ? " declared on " + source2 : "";
                        throw new AnnotationConfigurationException(String.format("Different @AliasFor mirror values for annotation [%s]%s; attribute '%s' and its alias '%s' are declared with values of [%s] and [%s].", AnnotationTypeMapping.this.getAnnotationType().getName(), on, AnnotationTypeMapping.this.attributes.get(result2).getName(), attribute.getName(), ObjectUtils.nullSafeToString(lastValue), ObjectUtils.nullSafeToString(value2)));
                    }
                    result2 = this.indexes[i2];
                    lastValue = value2;
                }
                return result2;
            }

            int size() {
                return this.size;
            }

            Method get(int index2) {
                int attributeIndex = this.indexes[index2];
                return AnnotationTypeMapping.this.attributes.get(attributeIndex);
            }

            int getAttributeIndex(int index2) {
                return this.indexes[index2];
            }
        }
    }
}

