/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.annotation;

import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.List;
import org.springframework.core.DecoratingProxy;
import org.springframework.core.OrderComparator;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.annotation.OrderUtils;
import org.springframework.lang.Nullable;

public class AnnotationAwareOrderComparator
extends OrderComparator {
    public static final AnnotationAwareOrderComparator INSTANCE = new AnnotationAwareOrderComparator();

    @Override
    @Nullable
    protected Integer findOrder(Object obj) {
        Integer order2 = super.findOrder(obj);
        if (order2 != null) {
            return order2;
        }
        return this.findOrderFromAnnotation(obj);
    }

    @Nullable
    private Integer findOrderFromAnnotation(Object obj) {
        AnnotatedElement annotatedElement;
        if (obj instanceof AnnotatedElement) {
            AnnotatedElement ae = (AnnotatedElement)obj;
            annotatedElement = ae;
        } else {
            annotatedElement = obj.getClass();
        }
        Class<?> element = annotatedElement;
        MergedAnnotations annotations = MergedAnnotations.from(element, MergedAnnotations.SearchStrategy.TYPE_HIERARCHY);
        Integer order2 = OrderUtils.getOrderFromAnnotations(element, annotations);
        if (order2 == null && obj instanceof DecoratingProxy) {
            DecoratingProxy decoratingProxy = (DecoratingProxy)obj;
            return this.findOrderFromAnnotation(decoratingProxy.getDecoratedClass());
        }
        return order2;
    }

    @Override
    @Nullable
    public Integer getPriority(Object obj) {
        if (obj instanceof Class) {
            Class clazz = (Class)obj;
            return OrderUtils.getPriority(clazz);
        }
        Integer priority2 = OrderUtils.getPriority(obj.getClass());
        if (priority2 == null && obj instanceof DecoratingProxy) {
            DecoratingProxy decoratingProxy = (DecoratingProxy)obj;
            return this.getPriority(decoratingProxy.getDecoratedClass());
        }
        return priority2;
    }

    public static void sort(List<?> list2) {
        if (list2.size() > 1) {
            list2.sort(INSTANCE);
        }
    }

    public static void sort(Object[] array2) {
        if (array2.length > 1) {
            Arrays.sort(array2, INSTANCE);
        }
    }

    public static void sortIfNecessary(Object value2) {
        if (value2 instanceof Object[]) {
            Object[] objects = (Object[])value2;
            AnnotationAwareOrderComparator.sort(objects);
        } else if (value2 instanceof List) {
            List list2 = (List)value2;
            AnnotationAwareOrderComparator.sort(list2);
        }
    }
}

