/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class AnnotationAttributes
extends LinkedHashMap<String, Object> {
    private static final String UNKNOWN = "unknown";
    @Nullable
    private final Class<? extends Annotation> annotationType;
    final String displayName;
    final boolean validated;

    public AnnotationAttributes() {
        this.annotationType = null;
        this.displayName = UNKNOWN;
        this.validated = false;
    }

    public AnnotationAttributes(int initialCapacity) {
        super(initialCapacity);
        this.annotationType = null;
        this.displayName = UNKNOWN;
        this.validated = false;
    }

    public AnnotationAttributes(Map<String, Object> map2) {
        super(map2);
        this.annotationType = null;
        this.displayName = UNKNOWN;
        this.validated = false;
    }

    public AnnotationAttributes(AnnotationAttributes other) {
        super(other);
        this.annotationType = other.annotationType;
        this.displayName = other.displayName;
        this.validated = other.validated;
    }

    public AnnotationAttributes(Class<? extends Annotation> annotationType) {
        this(annotationType, false);
    }

    AnnotationAttributes(Class<? extends Annotation> annotationType, boolean validated) {
        Assert.notNull(annotationType, "'annotationType' must not be null");
        this.annotationType = annotationType;
        this.displayName = annotationType.getName();
        this.validated = validated;
    }

    public AnnotationAttributes(String annotationType, @Nullable ClassLoader classLoader) {
        Assert.notNull((Object)annotationType, "'annotationType' must not be null");
        this.annotationType = AnnotationAttributes.getAnnotationType(annotationType, classLoader);
        this.displayName = annotationType;
        this.validated = false;
    }

    @Nullable
    private static Class<? extends Annotation> getAnnotationType(String annotationType, @Nullable ClassLoader classLoader) {
        if (classLoader != null) {
            try {
                return classLoader.loadClass(annotationType);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public Class<? extends Annotation> annotationType() {
        return this.annotationType;
    }

    public String getString(String attributeName) {
        return this.getRequiredAttribute(attributeName, String.class);
    }

    public String[] getStringArray(String attributeName) {
        return this.getRequiredAttribute(attributeName, String[].class);
    }

    public boolean getBoolean(String attributeName) {
        return this.getRequiredAttribute(attributeName, Boolean.class);
    }

    public <N extends Number> N getNumber(String attributeName) {
        return (N)this.getRequiredAttribute(attributeName, Number.class);
    }

    public <E extends Enum<?>> E getEnum(String attributeName) {
        return (E)this.getRequiredAttribute(attributeName, Enum.class);
    }

    public <T> Class<? extends T> getClass(String attributeName) {
        return this.getRequiredAttribute(attributeName, Class.class);
    }

    public Class<?>[] getClassArray(String attributeName) {
        return this.getRequiredAttribute(attributeName, Class[].class);
    }

    public AnnotationAttributes getAnnotation(String attributeName) {
        return this.getRequiredAttribute(attributeName, AnnotationAttributes.class);
    }

    public <A extends Annotation> A getAnnotation(String attributeName, Class<A> annotationType) {
        return (A)((Annotation)this.getRequiredAttribute(attributeName, annotationType));
    }

    public AnnotationAttributes[] getAnnotationArray(String attributeName) {
        return this.getRequiredAttribute(attributeName, AnnotationAttributes[].class);
    }

    public <A extends Annotation> A[] getAnnotationArray(String attributeName, Class<A> annotationType) {
        return (Annotation[])this.getRequiredAttribute(attributeName, (Class)annotationType.arrayType());
    }

    private <T> T getRequiredAttribute(String attributeName, Class<T> expectedType) {
        Assert.hasText(attributeName, "'attributeName' must not be null or empty");
        Object value2 = this.get(attributeName);
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Attribute '%s' not found in attributes for annotation [%s]", attributeName, this.displayName));
        }
        if (value2 instanceof Throwable) {
            Throwable throwable = (Throwable)value2;
            throw new IllegalArgumentException(String.format("Attribute '%s' for annotation [%s] was not resolvable due to exception [%s]", attributeName, this.displayName, value2), throwable);
        }
        if (!expectedType.isInstance(value2) && expectedType.isArray() && ((Class)expectedType.componentType()).isInstance(value2)) {
            Object array2 = Array.newInstance(expectedType.componentType(), 1);
            Array.set(array2, 0, value2);
            value2 = array2;
        }
        if (!expectedType.isInstance(value2)) {
            throw new IllegalArgumentException(String.format("Attribute '%s' is of type %s, but %s was expected in attributes for annotation [%s]", attributeName, value2.getClass().getSimpleName(), expectedType.getSimpleName(), this.displayName));
        }
        return (T)value2;
    }

    @Override
    public String toString() {
        Iterator entries2 = this.entrySet().iterator();
        StringBuilder sb = new StringBuilder("{");
        while (entries2.hasNext()) {
            Map.Entry entry = entries2.next();
            sb.append((String)entry.getKey());
            sb.append('=');
            sb.append(this.valueToString(entry.getValue()));
            if (!entries2.hasNext()) continue;
            sb.append(", ");
        }
        sb.append('}');
        return sb.toString();
    }

    private String valueToString(Object value2) {
        if (value2 == this) {
            return "(this Map)";
        }
        if (value2 instanceof Object[]) {
            Object[] objects = (Object[])value2;
            return "[" + StringUtils.arrayToDelimitedString(objects, ", ") + "]";
        }
        return String.valueOf(value2);
    }

    @Nullable
    public static AnnotationAttributes fromMap(@Nullable Map<String, Object> map2) {
        if (map2 == null) {
            return null;
        }
        if (map2 instanceof AnnotationAttributes) {
            AnnotationAttributes annotationAttributes = (AnnotationAttributes)map2;
            return annotationAttributes;
        }
        return new AnnotationAttributes(map2);
    }
}

