/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.io.Serializable;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.StringJoiner;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.ResolvableTypeProvider;
import org.springframework.core.SerializableTypeWrapper;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class ResolvableType
implements Serializable {
    public static final ResolvableType NONE = new ResolvableType(EmptyType.INSTANCE, null, null, 0);
    private static final ResolvableType[] EMPTY_TYPES_ARRAY = new ResolvableType[0];
    private static final ConcurrentReferenceHashMap<ResolvableType, ResolvableType> cache = new ConcurrentReferenceHashMap(256);
    private final Type type;
    @Nullable
    private final ResolvableType componentType;
    @Nullable
    private final SerializableTypeWrapper.TypeProvider typeProvider;
    @Nullable
    private final VariableResolver variableResolver;
    @Nullable
    private final Integer hash;
    @Nullable
    private Class<?> resolved;
    @Nullable
    private volatile ResolvableType superType;
    @Nullable
    private volatile ResolvableType[] interfaces;
    @Nullable
    private volatile ResolvableType[] generics;
    @Nullable
    private volatile Boolean unresolvableGenerics;

    private ResolvableType(Type type2, @Nullable SerializableTypeWrapper.TypeProvider typeProvider, @Nullable VariableResolver variableResolver) {
        this.type = type2;
        this.componentType = null;
        this.typeProvider = typeProvider;
        this.variableResolver = variableResolver;
        this.hash = this.calculateHashCode();
        this.resolved = null;
    }

    private ResolvableType(Type type2, @Nullable SerializableTypeWrapper.TypeProvider typeProvider, @Nullable VariableResolver variableResolver, @Nullable Integer hash2) {
        this.type = type2;
        this.componentType = null;
        this.typeProvider = typeProvider;
        this.variableResolver = variableResolver;
        this.hash = hash2;
        this.resolved = this.resolveClass();
    }

    private ResolvableType(Type type2, @Nullable ResolvableType componentType, @Nullable SerializableTypeWrapper.TypeProvider typeProvider, @Nullable VariableResolver variableResolver) {
        this.type = type2;
        this.componentType = componentType;
        this.typeProvider = typeProvider;
        this.variableResolver = variableResolver;
        this.hash = null;
        this.resolved = this.resolveClass();
    }

    private ResolvableType(@Nullable Class<?> clazz) {
        this.type = this.resolved = clazz != null ? clazz : Object.class;
        this.componentType = null;
        this.typeProvider = null;
        this.variableResolver = null;
        this.hash = null;
    }

    public Type getType() {
        return SerializableTypeWrapper.unwrap(this.type);
    }

    @Nullable
    public Class<?> getRawClass() {
        Class rawClass;
        if (this.type == this.resolved) {
            return this.resolved;
        }
        Type rawType = this.type;
        if (rawType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)rawType;
            rawType = parameterizedType.getRawType();
        }
        return rawType instanceof Class ? (rawClass = (Class)rawType) : null;
    }

    public Object getSource() {
        Object source2 = this.typeProvider != null ? this.typeProvider.getSource() : null;
        return source2 != null ? source2 : this.type;
    }

    public Class<?> toClass() {
        return this.resolve(Object.class);
    }

    public boolean isInstance(@Nullable Object obj) {
        return obj != null && this.isAssignableFrom(obj.getClass());
    }

    public boolean isAssignableFrom(Class<?> other) {
        boolean bl;
        Type type2 = this.type;
        if (type2 instanceof Class) {
            Class clazz = (Class)type2;
            bl = ClassUtils.isAssignable(clazz, other);
        } else {
            bl = this.isAssignableFrom(ResolvableType.forClass(other), false, null);
        }
        return bl;
    }

    public boolean isAssignableFrom(ResolvableType other) {
        return this.isAssignableFrom(other, false, null);
    }

    private boolean isAssignableFrom(ResolvableType other, boolean strict, @Nullable Map<Type, Type> matchedBefore) {
        Assert.notNull((Object)other, "ResolvableType must not be null");
        if (this == NONE || other == NONE) {
            return false;
        }
        if (matchedBefore != null) {
            if (matchedBefore.get(this.type) == other.type) {
                return true;
            }
        } else {
            Type type2 = this.type;
            if (type2 instanceof Class) {
                Class clazz = (Class)type2;
                type2 = other.type;
                if (type2 instanceof Class) {
                    Class otherClazz = (Class)type2;
                    return strict ? clazz.isAssignableFrom(otherClazz) : ClassUtils.isAssignable(clazz, otherClazz);
                }
            }
        }
        if (this.isArray()) {
            return other.isArray() && this.getComponentType().isAssignableFrom(other.getComponentType(), true, matchedBefore);
        }
        WildcardBounds ourBounds = WildcardBounds.get(this);
        WildcardBounds typeBounds = WildcardBounds.get(other);
        if (typeBounds != null) {
            return ourBounds != null && ourBounds.isSameKind(typeBounds) && ourBounds.isAssignableFrom(typeBounds.getBounds());
        }
        if (ourBounds != null) {
            return ourBounds.isAssignableFrom(other);
        }
        boolean exactMatch = matchedBefore != null;
        boolean checkGenerics = true;
        Class<?> ourResolved = null;
        Type type3 = this.type;
        if (type3 instanceof TypeVariable) {
            ResolvableType resolved;
            TypeVariable variable = (TypeVariable)type3;
            if (this.variableResolver != null && (resolved = this.variableResolver.resolveVariable(variable)) != null) {
                ourResolved = resolved.resolve();
            }
            if (ourResolved == null && other.variableResolver != null && (resolved = other.variableResolver.resolveVariable(variable)) != null) {
                ourResolved = resolved.resolve();
                checkGenerics = false;
            }
            if (ourResolved == null) {
                exactMatch = false;
            }
        }
        if (ourResolved == null) {
            ourResolved = this.toClass();
        }
        Class<?> otherResolved = other.toClass();
        if (exactMatch ? !ourResolved.equals(otherResolved) : (strict ? !ourResolved.isAssignableFrom(otherResolved) : !ClassUtils.isAssignable(ourResolved, otherResolved))) {
            return false;
        }
        if (checkGenerics) {
            ResolvableType[] typeGenerics;
            ResolvableType[] ourGenerics = this.getGenerics();
            if (ourGenerics.length != (typeGenerics = other.as(ourResolved).getGenerics()).length) {
                return false;
            }
            if (ourGenerics.length > 0) {
                if (matchedBefore == null) {
                    matchedBefore = new IdentityHashMap<Type, Type>(1);
                }
                matchedBefore.put(this.type, other.type);
                for (int i2 = 0; i2 < ourGenerics.length; ++i2) {
                    if (ourGenerics[i2].isAssignableFrom(typeGenerics[i2], true, matchedBefore)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean isArray() {
        Class clazz;
        if (this == NONE) {
            return false;
        }
        Type type2 = this.type;
        return type2 instanceof Class && (clazz = (Class)type2).isArray() || this.type instanceof GenericArrayType || this.resolveType().isArray();
    }

    public ResolvableType getComponentType() {
        if (this == NONE) {
            return NONE;
        }
        if (this.componentType != null) {
            return this.componentType;
        }
        Type type2 = this.type;
        if (type2 instanceof Class) {
            Class clazz = (Class)type2;
            TypeDescriptor.OfField componentType = clazz.componentType();
            return ResolvableType.forType((Type)((Object)componentType), this.variableResolver);
        }
        type2 = this.type;
        if (type2 instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type2;
            return ResolvableType.forType(genericArrayType.getGenericComponentType(), this.variableResolver);
        }
        return this.resolveType().getComponentType();
    }

    public ResolvableType asCollection() {
        return this.as(Collection.class);
    }

    public ResolvableType asMap() {
        return this.as(Map.class);
    }

    public ResolvableType as(Class<?> type2) {
        if (this == NONE) {
            return NONE;
        }
        Class<?> resolved = this.resolve();
        if (resolved == null || resolved == type2) {
            return this;
        }
        for (ResolvableType interfaceType : this.getInterfaces()) {
            ResolvableType interfaceAsType = interfaceType.as(type2);
            if (interfaceAsType == NONE) continue;
            return interfaceAsType;
        }
        return this.getSuperType().as(type2);
    }

    public ResolvableType getSuperType() {
        Class<?> resolved = this.resolve();
        if (resolved == null) {
            return NONE;
        }
        try {
            Type superclass2 = resolved.getGenericSuperclass();
            if (superclass2 == null) {
                return NONE;
            }
            ResolvableType superType = this.superType;
            if (superType == null) {
                this.superType = superType = ResolvableType.forType(superclass2, this);
            }
            return superType;
        }
        catch (TypeNotPresentException ex) {
            return NONE;
        }
    }

    public ResolvableType[] getInterfaces() {
        Class<?> resolved = this.resolve();
        if (resolved == null) {
            return EMPTY_TYPES_ARRAY;
        }
        ResolvableType[] interfaces2 = this.interfaces;
        if (interfaces2 == null) {
            Type[] genericIfcs = resolved.getGenericInterfaces();
            interfaces2 = new ResolvableType[genericIfcs.length];
            for (int i2 = 0; i2 < genericIfcs.length; ++i2) {
                interfaces2[i2] = ResolvableType.forType(genericIfcs[i2], this);
            }
            this.interfaces = interfaces2;
        }
        return interfaces2;
    }

    public boolean hasGenerics() {
        return this.getGenerics().length > 0;
    }

    boolean isEntirelyUnresolvable() {
        ResolvableType[] generics;
        if (this == NONE) {
            return false;
        }
        for (ResolvableType generic : generics = this.getGenerics()) {
            if (generic.isUnresolvableTypeVariable() || generic.isWildcardWithoutBounds()) continue;
            return false;
        }
        return true;
    }

    public boolean hasUnresolvableGenerics() {
        if (this == NONE) {
            return false;
        }
        Boolean unresolvableGenerics = this.unresolvableGenerics;
        if (unresolvableGenerics == null) {
            this.unresolvableGenerics = unresolvableGenerics = Boolean.valueOf(this.determineUnresolvableGenerics());
        }
        return unresolvableGenerics;
    }

    private boolean determineUnresolvableGenerics() {
        ResolvableType[] generics;
        for (ResolvableType generic : generics = this.getGenerics()) {
            if (!generic.isUnresolvableTypeVariable() && !generic.isWildcardWithoutBounds()) continue;
            return true;
        }
        Class<?> resolved = this.resolve();
        if (resolved != null) {
            Class<?> superclass2;
            try {
                for (Type genericInterface : resolved.getGenericInterfaces()) {
                    Class clazz;
                    if (!(genericInterface instanceof Class) || (clazz = (Class)genericInterface).getTypeParameters().length <= 0) continue;
                    return true;
                }
            }
            catch (TypeNotPresentException typeNotPresentException) {
                // empty catch block
            }
            if ((superclass2 = resolved.getSuperclass()) != null && superclass2 != Object.class) {
                return this.getSuperType().hasUnresolvableGenerics();
            }
        }
        return false;
    }

    private boolean isUnresolvableTypeVariable() {
        Type type2 = this.type;
        if (type2 instanceof TypeVariable) {
            TypeVariable variable = (TypeVariable)type2;
            if (this.variableResolver == null) {
                return true;
            }
            ResolvableType resolved = this.variableResolver.resolveVariable(variable);
            if (resolved == null || resolved.isUnresolvableTypeVariable()) {
                return true;
            }
        }
        return false;
    }

    private boolean isWildcardWithoutBounds() {
        Type[] upperBounds;
        WildcardType wt;
        Type type2 = this.type;
        return type2 instanceof WildcardType && (wt = (WildcardType)type2).getLowerBounds().length == 0 && ((upperBounds = wt.getUpperBounds()).length == 0 || upperBounds.length == 1 && Object.class == upperBounds[0]);
    }

    public ResolvableType getNested(int nestingLevel) {
        return this.getNested(nestingLevel, null);
    }

    public ResolvableType getNested(int nestingLevel, @Nullable Map<Integer, Integer> typeIndexesPerLevel) {
        ResolvableType result2 = this;
        for (int i2 = 2; i2 <= nestingLevel; ++i2) {
            if (result2.isArray()) {
                result2 = result2.getComponentType();
                continue;
            }
            while (result2 != NONE && !result2.hasGenerics()) {
                result2 = result2.getSuperType();
            }
            Integer index2 = typeIndexesPerLevel != null ? typeIndexesPerLevel.get(i2) : null;
            index2 = index2 == null ? result2.getGenerics().length - 1 : index2;
            result2 = result2.getGeneric(index2);
        }
        return result2;
    }

    public ResolvableType getGeneric(int ... indexes2) {
        ResolvableType[] generics = this.getGenerics();
        if (indexes2 == null || indexes2.length == 0) {
            return generics.length == 0 ? NONE : generics[0];
        }
        ResolvableType generic = this;
        for (int index2 : indexes2) {
            generics = generic.getGenerics();
            if (index2 < 0 || index2 >= generics.length) {
                return NONE;
            }
            generic = generics[index2];
        }
        return generic;
    }

    public ResolvableType[] getGenerics() {
        if (this == NONE) {
            return EMPTY_TYPES_ARRAY;
        }
        ResolvableType[] generics = this.generics;
        if (generics == null) {
            Type type2 = this.type;
            if (type2 instanceof Class) {
                Class clazz = (Class)type2;
                typeParams = clazz.getTypeParameters();
                generics = new ResolvableType[typeParams.length];
                for (int i2 = 0; i2 < generics.length; ++i2) {
                    generics[i2] = ResolvableType.forType(typeParams[i2], this);
                }
            } else {
                typeParams = this.type;
                if (typeParams instanceof ParameterizedType) {
                    ParameterizedType parameterizedType = (ParameterizedType)typeParams;
                    Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
                    generics = new ResolvableType[actualTypeArguments.length];
                    for (int i3 = 0; i3 < actualTypeArguments.length; ++i3) {
                        generics[i3] = ResolvableType.forType(actualTypeArguments[i3], this.variableResolver);
                    }
                } else {
                    generics = this.resolveType().getGenerics();
                }
            }
            this.generics = generics;
        }
        return generics;
    }

    public Class<?>[] resolveGenerics() {
        ResolvableType[] generics = this.getGenerics();
        Class[] resolvedGenerics = new Class[generics.length];
        for (int i2 = 0; i2 < generics.length; ++i2) {
            resolvedGenerics[i2] = generics[i2].resolve();
        }
        return resolvedGenerics;
    }

    public Class<?>[] resolveGenerics(Class<?> fallback) {
        ResolvableType[] generics = this.getGenerics();
        Class[] resolvedGenerics = new Class[generics.length];
        for (int i2 = 0; i2 < generics.length; ++i2) {
            resolvedGenerics[i2] = generics[i2].resolve(fallback);
        }
        return resolvedGenerics;
    }

    @Nullable
    public Class<?> resolveGeneric(int ... indexes2) {
        return this.getGeneric(indexes2).resolve();
    }

    @Nullable
    public Class<?> resolve() {
        return this.resolved;
    }

    public Class<?> resolve(Class<?> fallback) {
        return this.resolved != null ? this.resolved : fallback;
    }

    @Nullable
    private Class<?> resolveClass() {
        if (this.type == EmptyType.INSTANCE) {
            return null;
        }
        Type type2 = this.type;
        if (type2 instanceof Class) {
            Class clazz = (Class)type2;
            return clazz;
        }
        if (this.type instanceof GenericArrayType) {
            Class<?> resolvedComponent = this.getComponentType().resolve();
            return resolvedComponent != null ? Array.newInstance(resolvedComponent, 0).getClass() : null;
        }
        return this.resolveType().resolve();
    }

    ResolvableType resolveType() {
        Object resolved;
        Type type2 = this.type;
        if (type2 instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type2;
            return ResolvableType.forType(parameterizedType.getRawType(), this.variableResolver);
        }
        type2 = this.type;
        if (type2 instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type2;
            resolved = this.resolveBounds(wildcardType.getUpperBounds());
            if (resolved == null) {
                resolved = this.resolveBounds(wildcardType.getLowerBounds());
            }
            return ResolvableType.forType((Type)resolved, this.variableResolver);
        }
        resolved = this.type;
        if (resolved instanceof TypeVariable) {
            TypeVariable variable = (TypeVariable)resolved;
            if (this.variableResolver != null && (resolved = this.variableResolver.resolveVariable(variable)) != null) {
                return resolved;
            }
            return ResolvableType.forType(this.resolveBounds(variable.getBounds()), this.variableResolver);
        }
        return NONE;
    }

    @Nullable
    private Type resolveBounds(Type[] bounds) {
        if (bounds.length == 0 || bounds[0] == Object.class) {
            return null;
        }
        return bounds[0];
    }

    @Nullable
    private ResolvableType resolveVariable(TypeVariable<?> variable) {
        ResolvableType resolved;
        if (this.type instanceof TypeVariable) {
            return this.resolveType().resolveVariable(variable);
        }
        Type type2 = this.type;
        if (type2 instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type2;
            Class<?> resolved2 = this.resolve();
            if (resolved2 == null) {
                return null;
            }
            TypeVariable<Class<?>>[] variables = resolved2.getTypeParameters();
            for (int i2 = 0; i2 < variables.length; ++i2) {
                if (!ObjectUtils.nullSafeEquals(variables[i2].getName(), variable.getName())) continue;
                Type actualType = parameterizedType.getActualTypeArguments()[i2];
                return ResolvableType.forType(actualType, this.variableResolver);
            }
            Type ownerType = parameterizedType.getOwnerType();
            if (ownerType != null) {
                return ResolvableType.forType(ownerType, this.variableResolver).resolveVariable(variable);
            }
        }
        if (this.type instanceof WildcardType && (resolved = this.resolveType().resolveVariable(variable)) != null) {
            return resolved;
        }
        if (this.variableResolver != null) {
            return this.variableResolver.resolveVariable(variable);
        }
        return null;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        ResolvableType otherType = (ResolvableType)other;
        if (!this.equalsType(otherType)) {
            return false;
        }
        if (!(this.typeProvider == otherType.typeProvider || this.typeProvider != null && otherType.typeProvider != null && ObjectUtils.nullSafeEquals(this.typeProvider.getType(), otherType.typeProvider.getType()))) {
            return false;
        }
        return this.variableResolver == otherType.variableResolver || this.variableResolver != null && otherType.variableResolver != null && ObjectUtils.nullSafeEquals(this.variableResolver.getSource(), otherType.variableResolver.getSource());
    }

    public boolean equalsType(ResolvableType otherType) {
        return ObjectUtils.nullSafeEquals(this.type, otherType.type) && ObjectUtils.nullSafeEquals(this.componentType, otherType.componentType);
    }

    public int hashCode() {
        return this.hash != null ? this.hash.intValue() : this.calculateHashCode();
    }

    private int calculateHashCode() {
        int hashCode = ObjectUtils.nullSafeHashCode(this.type);
        if (this.componentType != null) {
            hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode(this.componentType);
        }
        if (this.typeProvider != null) {
            hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode(this.typeProvider.getType());
        }
        if (this.variableResolver != null) {
            hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode(this.variableResolver.getSource());
        }
        return hashCode;
    }

    @Nullable
    VariableResolver asVariableResolver() {
        if (this == NONE) {
            return null;
        }
        return new DefaultVariableResolver(this);
    }

    private Object readResolve() {
        return this.type == EmptyType.INSTANCE ? NONE : this;
    }

    public String toString() {
        if (this.isArray()) {
            return this.getComponentType() + "[]";
        }
        if (this.resolved == null) {
            return "?";
        }
        Type type2 = this.type;
        if (type2 instanceof TypeVariable) {
            TypeVariable variable = (TypeVariable)type2;
            if (this.variableResolver == null || this.variableResolver.resolveVariable(variable) == null) {
                return "?";
            }
        }
        if (this.hasGenerics()) {
            return this.resolved.getName() + "<" + StringUtils.arrayToDelimitedString(this.getGenerics(), ", ") + ">";
        }
        return this.resolved.getName();
    }

    public static ResolvableType forClass(@Nullable Class<?> clazz) {
        return new ResolvableType(clazz);
    }

    public static ResolvableType forRawClass(final @Nullable Class<?> clazz) {
        return new ResolvableType(clazz){

            @Override
            public ResolvableType[] getGenerics() {
                return EMPTY_TYPES_ARRAY;
            }

            @Override
            public boolean isAssignableFrom(Class<?> other) {
                return clazz == null || ClassUtils.isAssignable(clazz, other);
            }

            @Override
            public boolean isAssignableFrom(ResolvableType other) {
                Class<?> otherClass = other.resolve();
                return otherClass != null && (clazz == null || ClassUtils.isAssignable(clazz, otherClass));
            }
        };
    }

    public static ResolvableType forClass(Class<?> baseType, Class<?> implementationClass) {
        Assert.notNull(baseType, "Base type must not be null");
        ResolvableType asType = ResolvableType.forType(implementationClass).as(baseType);
        return asType == NONE ? ResolvableType.forType(baseType) : asType;
    }

    public static ResolvableType forClassWithGenerics(Class<?> clazz, Class<?> ... generics) {
        Assert.notNull(clazz, "Class must not be null");
        Assert.notNull(generics, "Generics array must not be null");
        ResolvableType[] resolvableGenerics = new ResolvableType[generics.length];
        for (int i2 = 0; i2 < generics.length; ++i2) {
            resolvableGenerics[i2] = ResolvableType.forClass(generics[i2]);
        }
        return ResolvableType.forClassWithGenerics(clazz, resolvableGenerics);
    }

    public static ResolvableType forClassWithGenerics(Class<?> clazz, ResolvableType ... generics) {
        Assert.notNull(clazz, "Class must not be null");
        TypeVariable<Class<?>>[] variables = clazz.getTypeParameters();
        if (generics != null) {
            Assert.isTrue(variables.length == generics.length, () -> "Mismatched number of generics specified for " + clazz.toGenericString());
        }
        Type[] arguments = new Type[variables.length];
        for (int i2 = 0; i2 < variables.length; ++i2) {
            ResolvableType generic = generics != null ? generics[i2] : null;
            Type argument = generic != null ? generic.getType() : null;
            arguments[i2] = argument != null && !(argument instanceof TypeVariable) ? argument : variables[i2];
        }
        return ResolvableType.forType((Type)new SyntheticParameterizedType(clazz, arguments), generics != null ? new TypeVariablesVariableResolver(variables, generics) : null);
    }

    public static ResolvableType forInstance(@Nullable Object instance) {
        ResolvableTypeProvider resolvableTypeProvider;
        ResolvableType type2;
        if (instance instanceof ResolvableTypeProvider && (type2 = (resolvableTypeProvider = (ResolvableTypeProvider)instance).getResolvableType()) != null) {
            return type2;
        }
        return instance != null ? ResolvableType.forClass(instance.getClass()) : NONE;
    }

    public static ResolvableType forField(Field field) {
        Assert.notNull((Object)field, "Field must not be null");
        return ResolvableType.forType(null, new SerializableTypeWrapper.FieldTypeProvider(field), null);
    }

    public static ResolvableType forField(Field field, Class<?> implementationClass) {
        Assert.notNull((Object)field, "Field must not be null");
        ResolvableType owner2 = ResolvableType.forType(implementationClass).as(field.getDeclaringClass());
        return ResolvableType.forType(null, new SerializableTypeWrapper.FieldTypeProvider(field), owner2.asVariableResolver());
    }

    public static ResolvableType forField(Field field, @Nullable ResolvableType implementationType) {
        Assert.notNull((Object)field, "Field must not be null");
        ResolvableType owner2 = implementationType != null ? implementationType : NONE;
        owner2 = owner2.as(field.getDeclaringClass());
        return ResolvableType.forType(null, new SerializableTypeWrapper.FieldTypeProvider(field), owner2.asVariableResolver());
    }

    public static ResolvableType forField(Field field, int nestingLevel) {
        Assert.notNull((Object)field, "Field must not be null");
        return ResolvableType.forType(null, new SerializableTypeWrapper.FieldTypeProvider(field), null).getNested(nestingLevel);
    }

    public static ResolvableType forField(Field field, int nestingLevel, @Nullable Class<?> implementationClass) {
        Assert.notNull((Object)field, "Field must not be null");
        ResolvableType owner2 = ResolvableType.forType(implementationClass).as(field.getDeclaringClass());
        return ResolvableType.forType(null, new SerializableTypeWrapper.FieldTypeProvider(field), owner2.asVariableResolver()).getNested(nestingLevel);
    }

    public static ResolvableType forConstructorParameter(Constructor<?> constructor2, int parameterIndex) {
        Assert.notNull(constructor2, "Constructor must not be null");
        return ResolvableType.forMethodParameter(new MethodParameter(constructor2, parameterIndex));
    }

    public static ResolvableType forConstructorParameter(Constructor<?> constructor2, int parameterIndex, Class<?> implementationClass) {
        Assert.notNull(constructor2, "Constructor must not be null");
        MethodParameter methodParameter = new MethodParameter(constructor2, parameterIndex, implementationClass);
        return ResolvableType.forMethodParameter(methodParameter);
    }

    public static ResolvableType forMethodReturnType(Method method2) {
        Assert.notNull((Object)method2, "Method must not be null");
        return ResolvableType.forMethodParameter(new MethodParameter(method2, -1));
    }

    public static ResolvableType forMethodReturnType(Method method2, Class<?> implementationClass) {
        Assert.notNull((Object)method2, "Method must not be null");
        MethodParameter methodParameter = new MethodParameter((Executable)method2, -1, implementationClass);
        return ResolvableType.forMethodParameter(methodParameter);
    }

    public static ResolvableType forMethodParameter(Method method2, int parameterIndex) {
        Assert.notNull((Object)method2, "Method must not be null");
        return ResolvableType.forMethodParameter(new MethodParameter(method2, parameterIndex));
    }

    public static ResolvableType forMethodParameter(Method method2, int parameterIndex, Class<?> implementationClass) {
        Assert.notNull((Object)method2, "Method must not be null");
        MethodParameter methodParameter = new MethodParameter((Executable)method2, parameterIndex, implementationClass);
        return ResolvableType.forMethodParameter(methodParameter);
    }

    public static ResolvableType forMethodParameter(MethodParameter methodParameter) {
        return ResolvableType.forMethodParameter(methodParameter, (Type)null);
    }

    public static ResolvableType forMethodParameter(MethodParameter methodParameter, @Nullable ResolvableType implementationType) {
        Assert.notNull((Object)methodParameter, "MethodParameter must not be null");
        implementationType = implementationType != null ? implementationType : ResolvableType.forType(methodParameter.getContainingClass());
        ResolvableType owner2 = implementationType.as(methodParameter.getDeclaringClass());
        return ResolvableType.forType(null, new SerializableTypeWrapper.MethodParameterTypeProvider(methodParameter), owner2.asVariableResolver()).getNested(methodParameter.getNestingLevel(), methodParameter.typeIndexesPerLevel);
    }

    public static ResolvableType forMethodParameter(MethodParameter methodParameter, @Nullable Type targetType) {
        Assert.notNull((Object)methodParameter, "MethodParameter must not be null");
        return ResolvableType.forMethodParameter(methodParameter, targetType, methodParameter.getNestingLevel());
    }

    static ResolvableType forMethodParameter(MethodParameter methodParameter, @Nullable Type targetType, int nestingLevel) {
        ResolvableType owner2 = ResolvableType.forType(methodParameter.getContainingClass()).as(methodParameter.getDeclaringClass());
        return ResolvableType.forType(targetType, new SerializableTypeWrapper.MethodParameterTypeProvider(methodParameter), owner2.asVariableResolver()).getNested(nestingLevel, methodParameter.typeIndexesPerLevel);
    }

    public static ResolvableType forArrayComponent(ResolvableType componentType) {
        Assert.notNull((Object)componentType, "Component type must not be null");
        TypeDescriptor.OfField arrayType = componentType.toClass().arrayType();
        return new ResolvableType((Type)((Object)arrayType), componentType, null, null);
    }

    public static ResolvableType forType(@Nullable Type type2) {
        return ResolvableType.forType(type2, null, null);
    }

    public static ResolvableType forType(@Nullable Type type2, @Nullable ResolvableType owner2) {
        VariableResolver variableResolver = null;
        if (owner2 != null) {
            variableResolver = owner2.asVariableResolver();
        }
        return ResolvableType.forType(type2, variableResolver);
    }

    public static ResolvableType forType(ParameterizedTypeReference<?> typeReference) {
        return ResolvableType.forType(typeReference.getType(), null, null);
    }

    static ResolvableType forType(@Nullable Type type2, @Nullable VariableResolver variableResolver) {
        return ResolvableType.forType(type2, null, variableResolver);
    }

    static ResolvableType forType(@Nullable Type type2, @Nullable SerializableTypeWrapper.TypeProvider typeProvider, @Nullable VariableResolver variableResolver) {
        if (type2 == null && typeProvider != null) {
            type2 = SerializableTypeWrapper.forTypeProvider(typeProvider);
        }
        if (type2 == null) {
            return NONE;
        }
        if (type2 instanceof Class) {
            return new ResolvableType(type2, null, typeProvider, variableResolver);
        }
        cache.purgeUnreferencedEntries();
        ResolvableType resultType = new ResolvableType(type2, typeProvider, variableResolver);
        ResolvableType cachedType = cache.get(resultType);
        if (cachedType == null) {
            cachedType = new ResolvableType(type2, typeProvider, variableResolver, resultType.hash);
            cache.put(cachedType, cachedType);
        }
        resultType.resolved = cachedType.resolved;
        return resultType;
    }

    public static void clearCache() {
        cache.clear();
        SerializableTypeWrapper.cache.clear();
    }

    static interface VariableResolver
    extends Serializable {
        public Object getSource();

        @Nullable
        public ResolvableType resolveVariable(TypeVariable<?> var1);
    }

    private static class WildcardBounds {
        private final Kind kind;
        private final ResolvableType[] bounds;

        public WildcardBounds(Kind kind, ResolvableType[] bounds) {
            this.kind = kind;
            this.bounds = bounds;
        }

        public boolean isSameKind(WildcardBounds bounds) {
            return this.kind == bounds.kind;
        }

        public boolean isAssignableFrom(ResolvableType ... types) {
            for (ResolvableType bound : this.bounds) {
                for (ResolvableType type2 : types) {
                    if (this.isAssignable(bound, type2)) continue;
                    return false;
                }
            }
            return true;
        }

        private boolean isAssignable(ResolvableType source2, ResolvableType from) {
            return this.kind == Kind.UPPER ? source2.isAssignableFrom(from) : from.isAssignableFrom(source2);
        }

        public ResolvableType[] getBounds() {
            return this.bounds;
        }

        @Nullable
        public static WildcardBounds get(ResolvableType type2) {
            Type type3;
            ResolvableType resolveToWildcard = type2;
            while (true) {
                if ((type3 = resolveToWildcard.getType()) instanceof WildcardType) break;
                if (resolveToWildcard == NONE) {
                    return null;
                }
                resolveToWildcard = resolveToWildcard.resolveType();
            }
            WildcardType wildcardType = (WildcardType)type3;
            Kind boundsType = wildcardType.getLowerBounds().length > 0 ? Kind.LOWER : Kind.UPPER;
            Type[] bounds = boundsType == Kind.UPPER ? wildcardType.getUpperBounds() : wildcardType.getLowerBounds();
            ResolvableType[] resolvableBounds = new ResolvableType[bounds.length];
            for (int i2 = 0; i2 < bounds.length; ++i2) {
                resolvableBounds[i2] = ResolvableType.forType(bounds[i2], type2.variableResolver);
            }
            return new WildcardBounds(boundsType, resolvableBounds);
        }

        static enum Kind {
            UPPER,
            LOWER;

        }
    }

    static class EmptyType
    implements Type,
    Serializable {
        static final Type INSTANCE = new EmptyType();

        EmptyType() {
        }

        Object readResolve() {
            return INSTANCE;
        }
    }

    private static class DefaultVariableResolver
    implements VariableResolver {
        private final ResolvableType source;

        DefaultVariableResolver(ResolvableType resolvableType) {
            this.source = resolvableType;
        }

        @Override
        @Nullable
        public ResolvableType resolveVariable(TypeVariable<?> variable) {
            return this.source.resolveVariable(variable);
        }

        @Override
        public Object getSource() {
            return this.source;
        }
    }

    private static final class SyntheticParameterizedType
    implements ParameterizedType,
    Serializable {
        private final Type rawType;
        private final Type[] typeArguments;

        public SyntheticParameterizedType(Type rawType, Type[] typeArguments) {
            this.rawType = rawType;
            this.typeArguments = typeArguments;
        }

        @Override
        public String getTypeName() {
            String typeName = this.rawType.getTypeName();
            if (this.typeArguments.length > 0) {
                StringJoiner stringJoiner = new StringJoiner(", ", "<", ">");
                for (Type argument : this.typeArguments) {
                    stringJoiner.add(argument.getTypeName());
                }
                return typeName + stringJoiner;
            }
            return typeName;
        }

        @Override
        @Nullable
        public Type getOwnerType() {
            return null;
        }

        @Override
        public Type getRawType() {
            return this.rawType;
        }

        @Override
        public Type[] getActualTypeArguments() {
            return this.typeArguments;
        }

        public boolean equals(@Nullable Object other) {
            ParameterizedType that;
            return this == other || other instanceof ParameterizedType && (that = (ParameterizedType)other).getOwnerType() == null && this.rawType.equals(that.getRawType()) && Arrays.equals(this.typeArguments, that.getActualTypeArguments());
        }

        public int hashCode() {
            return this.rawType.hashCode() * 31 + Arrays.hashCode(this.typeArguments);
        }

        public String toString() {
            return this.getTypeName();
        }
    }

    private static class TypeVariablesVariableResolver
    implements VariableResolver {
        private final TypeVariable<?>[] variables;
        private final ResolvableType[] generics;

        public TypeVariablesVariableResolver(TypeVariable<?>[] variables, ResolvableType[] generics) {
            this.variables = variables;
            this.generics = generics;
        }

        @Override
        @Nullable
        public ResolvableType resolveVariable(TypeVariable<?> variable) {
            TypeVariable<?> variableToCompare = SerializableTypeWrapper.unwrap(variable);
            for (int i2 = 0; i2 < this.variables.length; ++i2) {
                TypeVariable<?> resolvedVariable = SerializableTypeWrapper.unwrap(this.variables[i2]);
                if (!ObjectUtils.nullSafeEquals(resolvedVariable, variableToCompare)) continue;
                return this.generics[i2];
            }
            return null;
        }

        @Override
        public Object getSource() {
            return this.generics;
        }
    }
}

