/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import io.reactivex.rxjava3.core.BackpressureStrategy;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Single;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.groups.MultiCreate;
import io.smallrye.mutiny.groups.UniConvert;
import io.smallrye.mutiny.groups.UniCreate;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import java.util.function.Function;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.reactive.ReactiveFlowKt;
import kotlinx.coroutines.reactor.ReactorFlowKt;
import org.reactivestreams.FlowAdapters;
import org.reactivestreams.Publisher;
import org.springframework.core.CoroutinesUtils;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveTypeDescriptor;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import reactor.adapter.JdkFlowAdapter;
import reactor.blockhound.BlockHound;
import reactor.blockhound.integration.BlockHoundIntegration;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveAdapterRegistry {
    @Nullable
    private static volatile ReactiveAdapterRegistry sharedInstance;
    private static final boolean reactiveStreamsPresent;
    private static final boolean reactorPresent;
    private static final boolean rxjava3Present;
    private static final boolean kotlinCoroutinesPresent;
    private static final boolean mutinyPresent;
    private final List<ReactiveAdapter> adapters = new ArrayList<ReactiveAdapter>();

    public ReactiveAdapterRegistry() {
        if (!reactiveStreamsPresent) {
            return;
        }
        if (reactorPresent) {
            new ReactorRegistrar().registerAdapters(this);
        }
        if (rxjava3Present) {
            new RxJava3Registrar().registerAdapters(this);
        }
        if (reactorPresent && kotlinCoroutinesPresent) {
            new CoroutinesRegistrar().registerAdapters(this);
        }
        if (mutinyPresent) {
            new MutinyRegistrar().registerAdapters(this);
        }
        if (!reactorPresent) {
            new FlowAdaptersRegistrar().registerAdapters(this);
        }
    }

    public void registerReactiveType(ReactiveTypeDescriptor descriptor, Function<Object, Publisher<?>> toAdapter, Function<Publisher<?>, Object> fromAdapter) {
        this.adapters.add(this.buildAdapter(descriptor, toAdapter, fromAdapter));
    }

    public void registerReactiveTypeOverride(ReactiveTypeDescriptor descriptor, Function<Object, Publisher<?>> toAdapter, Function<Publisher<?>, Object> fromAdapter) {
        this.adapters.add(0, this.buildAdapter(descriptor, toAdapter, fromAdapter));
    }

    private ReactiveAdapter buildAdapter(ReactiveTypeDescriptor descriptor, Function<Object, Publisher<?>> toAdapter, Function<Publisher<?>, Object> fromAdapter) {
        return reactorPresent ? new ReactorAdapter(descriptor, toAdapter, fromAdapter) : new ReactiveAdapter(descriptor, toAdapter, fromAdapter);
    }

    public boolean hasAdapters() {
        return !this.adapters.isEmpty();
    }

    @Nullable
    public ReactiveAdapter getAdapter(Class<?> reactiveType) {
        return this.getAdapter(reactiveType, null);
    }

    @Nullable
    public ReactiveAdapter getAdapter(@Nullable Class<?> reactiveType, @Nullable Object source2) {
        Class<?> clazz;
        Object object;
        if (this.adapters.isEmpty()) {
            return null;
        }
        if (source2 instanceof Optional) {
            Optional optional = (Optional)source2;
            object = optional.orElse(null);
        } else {
            object = source2;
        }
        Object sourceToUse = object;
        Class<?> clazz2 = clazz = sourceToUse != null ? sourceToUse.getClass() : reactiveType;
        if (clazz == null) {
            return null;
        }
        for (ReactiveAdapter adapter : this.adapters) {
            if (adapter.getReactiveType() != clazz) continue;
            return adapter;
        }
        for (ReactiveAdapter adapter : this.adapters) {
            if (!adapter.getReactiveType().isAssignableFrom(clazz)) continue;
            return adapter;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ReactiveAdapterRegistry getSharedInstance() {
        ReactiveAdapterRegistry registry = sharedInstance;
        if (registry != null) return registry;
        Class<ReactiveAdapterRegistry> clazz = ReactiveAdapterRegistry.class;
        synchronized (ReactiveAdapterRegistry.class) {
            registry = sharedInstance;
            if (registry != null) return registry;
            sharedInstance = registry = new ReactiveAdapterRegistry();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return registry;
        }
    }

    static {
        ClassLoader classLoader = ReactiveAdapterRegistry.class.getClassLoader();
        reactiveStreamsPresent = ClassUtils.isPresent("org.reactivestreams.Publisher", classLoader);
        reactorPresent = ClassUtils.isPresent("reactor.core.publisher.Flux", classLoader);
        rxjava3Present = ClassUtils.isPresent("io.reactivex.rxjava3.core.Flowable", classLoader);
        kotlinCoroutinesPresent = ClassUtils.isPresent("kotlinx.coroutines.reactor.MonoKt", classLoader);
        mutinyPresent = ClassUtils.isPresent("io.smallrye.mutiny.Multi", classLoader);
    }

    private static class ReactorRegistrar {
        private static final Flow.Publisher<?> EMPTY_FLOW = JdkFlowAdapter.publisherToFlowPublisher((Publisher)Flux.empty());

        private ReactorRegistrar() {
        }

        void registerAdapters(ReactiveAdapterRegistry registry) {
            registry.registerReactiveType(ReactiveTypeDescriptor.singleOptionalValue(Mono.class, Mono::empty), source2 -> (Mono)source2, Mono::from);
            registry.registerReactiveType(ReactiveTypeDescriptor.multiValue(Flux.class, Flux::empty), source2 -> (Flux)source2, Flux::from);
            registry.registerReactiveType(ReactiveTypeDescriptor.multiValue(Publisher.class, Flux::empty), source2 -> (Publisher)source2, source2 -> source2);
            registry.registerReactiveType(ReactiveTypeDescriptor.nonDeferredAsyncValue(CompletionStage.class, EmptyCompletableFuture::new), source2 -> Mono.fromCompletionStage((CompletionStage)((CompletionStage)source2)), source2 -> Mono.from((Publisher)source2).toFuture());
            registry.registerReactiveType(ReactiveTypeDescriptor.multiValue(Flow.Publisher.class, () -> EMPTY_FLOW), source2 -> JdkFlowAdapter.flowPublisherToFlux((Flow.Publisher)((Flow.Publisher)source2)), JdkFlowAdapter::publisherToFlowPublisher);
        }
    }

    private static class RxJava3Registrar {
        private RxJava3Registrar() {
        }

        void registerAdapters(ReactiveAdapterRegistry registry) {
            registry.registerReactiveType(ReactiveTypeDescriptor.multiValue(Flowable.class, Flowable::empty), source2 -> (Flowable)source2, Flowable::fromPublisher);
            registry.registerReactiveType(ReactiveTypeDescriptor.multiValue(Observable.class, Observable::empty), source2 -> ((Observable)source2).toFlowable(BackpressureStrategy.BUFFER), Observable::fromPublisher);
            registry.registerReactiveType(ReactiveTypeDescriptor.singleRequiredValue(Single.class), source2 -> ((Single)source2).toFlowable(), Single::fromPublisher);
            registry.registerReactiveType(ReactiveTypeDescriptor.singleOptionalValue(Maybe.class, Maybe::empty), source2 -> ((Maybe)source2).toFlowable(), Maybe::fromPublisher);
            registry.registerReactiveType(ReactiveTypeDescriptor.noValue(Completable.class, Completable::complete), source2 -> ((Completable)source2).toFlowable(), Completable::fromPublisher);
        }
    }

    private static class CoroutinesRegistrar {
        private CoroutinesRegistrar() {
        }

        void registerAdapters(ReactiveAdapterRegistry registry) {
            registry.registerReactiveType(ReactiveTypeDescriptor.singleOptionalValue(Deferred.class, () -> CompletableDeferredKt.CompletableDeferred(null)), source2 -> CoroutinesUtils.deferredToMono((Deferred)source2), source2 -> CoroutinesUtils.monoToDeferred(Mono.from((Publisher)source2)));
            registry.registerReactiveType(ReactiveTypeDescriptor.multiValue(Flow.class, FlowKt::emptyFlow), source2 -> ReactorFlowKt.asFlux((Flow)((Flow)source2)), ReactiveFlowKt::asFlow);
        }
    }

    private static class MutinyRegistrar {
        private static final Method uniToPublisher = ClassUtils.getMethod(UniConvert.class, "toPublisher", new Class[0]);

        private MutinyRegistrar() {
        }

        void registerAdapters(ReactiveAdapterRegistry registry) {
            ReactiveTypeDescriptor uniDesc = ReactiveTypeDescriptor.singleOptionalValue(Uni.class, () -> Uni.createFrom().nothing());
            ReactiveTypeDescriptor multiDesc = ReactiveTypeDescriptor.multiValue(Multi.class, () -> Multi.createFrom().empty());
            if (Flow.Publisher.class.isAssignableFrom(uniToPublisher.getReturnType())) {
                Method uniPublisher = ClassUtils.getMethod(UniCreate.class, "publisher", Flow.Publisher.class);
                Method multiPublisher = ClassUtils.getMethod(MultiCreate.class, "publisher", Flow.Publisher.class);
                registry.registerReactiveType(uniDesc, uni -> FlowAdapters.toPublisher((Flow.Publisher)((Flow.Publisher)Objects.requireNonNull(ReflectionUtils.invokeMethod(uniToPublisher, ((Uni)uni).convert())))), publisher -> ReflectionUtils.invokeMethod(uniPublisher, Uni.createFrom(), FlowAdapters.toFlowPublisher((Publisher)publisher)));
                registry.registerReactiveType(multiDesc, multi -> FlowAdapters.toPublisher((Flow.Publisher)((Flow.Publisher)multi)), publisher -> ReflectionUtils.invokeMethod(multiPublisher, Multi.createFrom(), FlowAdapters.toFlowPublisher((Publisher)publisher)));
            } else {
                registry.registerReactiveType(uniDesc, uni -> ((Uni)uni).convert().toPublisher(), publisher -> Uni.createFrom().publisher(publisher));
                registry.registerReactiveType(multiDesc, multi -> (Multi)multi, publisher -> Multi.createFrom().publisher(publisher));
            }
        }
    }

    private static class FlowAdaptersRegistrar {
        private static final Flow.Subscription EMPTY_SUBSCRIPTION = new Flow.Subscription(){

            @Override
            public void request(long n) {
            }

            @Override
            public void cancel() {
            }
        };
        private static final Flow.Publisher<Object> EMPTY_PUBLISHER = subscriber -> {
            subscriber.onSubscribe(EMPTY_SUBSCRIPTION);
            subscriber.onComplete();
        };

        private FlowAdaptersRegistrar() {
        }

        void registerAdapters(ReactiveAdapterRegistry registry) {
            registry.registerReactiveType(ReactiveTypeDescriptor.multiValue(Flow.Publisher.class, () -> EMPTY_PUBLISHER), source2 -> FlowAdapters.toPublisher((Flow.Publisher)((Flow.Publisher)source2)), source2 -> FlowAdapters.toFlowPublisher((Publisher)source2));
        }
    }

    private static class ReactorAdapter
    extends ReactiveAdapter {
        ReactorAdapter(ReactiveTypeDescriptor descriptor, Function<Object, Publisher<?>> toPublisherFunction, Function<Publisher<?>, Object> fromPublisherFunction) {
            super(descriptor, toPublisherFunction, fromPublisherFunction);
        }

        @Override
        public <T> Publisher<T> toPublisher(@Nullable Object source2) {
            Publisher publisher = super.toPublisher(source2);
            return this.isMultiValue() ? Flux.from(publisher) : Mono.from(publisher);
        }
    }

    public static class SpringCoreBlockHoundIntegration
    implements BlockHoundIntegration {
        public void applyTo(BlockHound.Builder builder) {
            String className = "org.springframework.util.ConcurrentReferenceHashMap$Segment";
            builder.allowBlockingCallsInside(className, "doTask");
            builder.allowBlockingCallsInside(className, "clear");
            builder.allowBlockingCallsInside(className, "restructure");
        }
    }

    private static class EmptyCompletableFuture<T>
    extends CompletableFuture<T> {
        EmptyCompletableFuture() {
            this.complete(null);
        }
    }
}

