/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.springframework.core.Ordered;
import org.springframework.core.PriorityOrdered;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;

public class OrderComparator
implements Comparator<Object> {
    public static final OrderComparator INSTANCE = new OrderComparator();

    public Comparator<Object> withSourceProvider(OrderSourceProvider sourceProvider) {
        return (o1, o2) -> this.doCompare(o1, o2, sourceProvider);
    }

    @Override
    public int compare(@Nullable Object o1, @Nullable Object o2) {
        return this.doCompare(o1, o2, null);
    }

    private int doCompare(@Nullable Object o1, @Nullable Object o2, @Nullable OrderSourceProvider sourceProvider) {
        boolean p1 = o1 instanceof PriorityOrdered;
        boolean p2 = o2 instanceof PriorityOrdered;
        if (p1 && !p2) {
            return -1;
        }
        if (p2 && !p1) {
            return 1;
        }
        int i1 = this.getOrder(o1, sourceProvider);
        int i2 = this.getOrder(o2, sourceProvider);
        return Integer.compare(i1, i2);
    }

    private int getOrder(@Nullable Object obj, @Nullable OrderSourceProvider sourceProvider) {
        Object orderSource;
        Integer order2 = null;
        if (obj != null && sourceProvider != null && (orderSource = sourceProvider.getOrderSource(obj)) != null) {
            if (orderSource.getClass().isArray()) {
                Object source2;
                Object[] objectArray = ObjectUtils.toObjectArray(orderSource);
                int n = objectArray.length;
                for (int j = 0; j < n && (order2 = this.findOrder(source2 = objectArray[j])) == null; ++j) {
                }
            } else {
                order2 = this.findOrder(orderSource);
            }
        }
        return order2 != null ? order2.intValue() : this.getOrder(obj);
    }

    protected int getOrder(@Nullable Object obj) {
        Integer order2;
        if (obj != null && (order2 = this.findOrder(obj)) != null) {
            return order2;
        }
        return Integer.MAX_VALUE;
    }

    @Nullable
    protected Integer findOrder(Object obj) {
        Integer n;
        if (obj instanceof Ordered) {
            Ordered ordered = (Ordered)obj;
            n = ordered.getOrder();
        } else {
            n = null;
        }
        return n;
    }

    @Nullable
    public Integer getPriority(Object obj) {
        return null;
    }

    public static void sort(List<?> list2) {
        if (list2.size() > 1) {
            list2.sort(INSTANCE);
        }
    }

    public static void sort(Object[] array2) {
        if (array2.length > 1) {
            Arrays.sort(array2, INSTANCE);
        }
    }

    public static void sortIfNecessary(Object value2) {
        if (value2 instanceof Object[]) {
            Object[] objects = (Object[])value2;
            OrderComparator.sort(objects);
        } else if (value2 instanceof List) {
            List list2 = (List)value2;
            OrderComparator.sort(list2);
        }
    }

    @FunctionalInterface
    public static interface OrderSourceProvider {
        @Nullable
        public Object getOrderSource(Object var1);
    }
}

