/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import org.springframework.core.NestedExceptionUtils;
import org.springframework.lang.Nullable;

public abstract class NestedRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = 5439915454935047936L;

    public NestedRuntimeException(@Nullable String msg) {
        super(msg);
    }

    public NestedRuntimeException(@Nullable String msg, @Nullable Throwable cause2) {
        super(msg, cause2);
    }

    @Nullable
    public Throwable getRootCause() {
        return NestedExceptionUtils.getRootCause(this);
    }

    public Throwable getMostSpecificCause() {
        Throwable rootCause = this.getRootCause();
        return rootCause != null ? rootCause : this;
    }

    public boolean contains(@Nullable Class<?> exType) {
        if (exType == null) {
            return false;
        }
        if (exType.isInstance(this)) {
            return true;
        }
        Throwable cause2 = this.getCause();
        if (cause2 == this) {
            return false;
        }
        if (cause2 instanceof NestedRuntimeException) {
            NestedRuntimeException exception2 = (NestedRuntimeException)cause2;
            return exception2.contains(exType);
        }
        while (cause2 != null) {
            if (exType.isInstance(cause2)) {
                return true;
            }
            if (cause2.getCause() == cause2) break;
            cause2 = cause2.getCause();
        }
        return false;
    }
}

