/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.util.Objects;
import java.util.function.Supplier;
import org.springframework.util.Assert;

public class NamedThreadLocal<T>
extends ThreadLocal<T> {
    private final String name;

    public NamedThreadLocal(String name2) {
        Assert.hasText(name2, "Name must not be empty");
        this.name = name2;
    }

    public String toString() {
        return this.name;
    }

    public static <S> ThreadLocal<S> withInitial(String name2, Supplier<? extends S> supplier) {
        return new SuppliedNamedThreadLocal<S>(name2, supplier);
    }

    private static final class SuppliedNamedThreadLocal<T>
    extends NamedThreadLocal<T> {
        private final Supplier<? extends T> supplier;

        SuppliedNamedThreadLocal(String name2, Supplier<? extends T> supplier) {
            super(name2);
            this.supplier = Objects.requireNonNull(supplier);
        }

        @Override
        protected T initialValue() {
            return this.supplier.get();
        }
    }
}

