/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.lang.reflect.Method;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;

public final class MethodClassKey
implements Comparable<MethodClassKey> {
    private final Method method;
    @Nullable
    private final Class<?> targetClass;

    public MethodClassKey(Method method2, @Nullable Class<?> targetClass) {
        this.method = method2;
        this.targetClass = targetClass;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        if (!(other instanceof MethodClassKey)) return false;
        MethodClassKey that = (MethodClassKey)other;
        if (!this.method.equals(that.method)) return false;
        if (!ObjectUtils.nullSafeEquals(this.targetClass, that.targetClass)) return false;
        return true;
    }

    public int hashCode() {
        return this.method.hashCode() + (this.targetClass != null ? this.targetClass.hashCode() * 29 : 0);
    }

    public String toString() {
        return this.method + (String)(this.targetClass != null ? " on " + this.targetClass : "");
    }

    @Override
    public int compareTo(MethodClassKey other) {
        int result2 = this.method.getName().compareTo(other.method.getName());
        if (result2 == 0 && (result2 = this.method.toString().compareTo(other.method.toString())) == 0 && this.targetClass != null && other.targetClass != null) {
            result2 = this.targetClass.getName().compareTo(other.targetClass.getName());
        }
        return result2;
    }
}

