/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.springframework.core.KotlinDetector;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.lang.Nullable;

public class KotlinReflectionParameterNameDiscoverer
implements ParameterNameDiscoverer {
    @Override
    @Nullable
    public String[] getParameterNames(Method method2) {
        if (!KotlinDetector.isKotlinType(method2.getDeclaringClass())) {
            return null;
        }
        try {
            KFunction function = ReflectJvmMapping.getKotlinFunction((Method)method2);
            return function != null ? this.getParameterNames(function.getParameters()) : null;
        }
        catch (UnsupportedOperationException ex) {
            return null;
        }
    }

    @Override
    @Nullable
    public String[] getParameterNames(Constructor<?> ctor) {
        if (ctor.getDeclaringClass().isEnum() || !KotlinDetector.isKotlinType(ctor.getDeclaringClass())) {
            return null;
        }
        try {
            KFunction function = ReflectJvmMapping.getKotlinFunction(ctor);
            return function != null ? this.getParameterNames(function.getParameters()) : null;
        }
        catch (UnsupportedOperationException ex) {
            return null;
        }
    }

    @Nullable
    private String[] getParameterNames(List<KParameter> parameters2) {
        String[] parameterNames;
        for (String parameterName : parameterNames = (String[])parameters2.stream().filter(p2 -> KParameter.Kind.VALUE.equals((Object)p2.getKind()) || KParameter.Kind.EXTENSION_RECEIVER.equals((Object)p2.getKind())).map(p2 -> KParameter.Kind.EXTENSION_RECEIVER.equals((Object)p2.getKind()) ? "$receiver" : p2.getName()).toArray(String[]::new)) {
            if (parameterName != null) continue;
            return null;
        }
        return parameterNames;
    }
}

