/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ConcurrentReferenceHashMap;

public final class GenericTypeResolver {
    private static final Map<Class<?>, Map<TypeVariable, Type>> typeVariableCache = new ConcurrentReferenceHashMap();

    private GenericTypeResolver() {
    }

    @Deprecated
    public static Class<?> resolveParameterType(MethodParameter methodParameter, Class<?> implementationClass) {
        Assert.notNull((Object)methodParameter, "MethodParameter must not be null");
        Assert.notNull(implementationClass, "Class must not be null");
        methodParameter.setContainingClass(implementationClass);
        return methodParameter.getParameterType();
    }

    public static Class<?> resolveReturnType(Method method2, Class<?> clazz) {
        Assert.notNull((Object)method2, "Method must not be null");
        Assert.notNull(clazz, "Class must not be null");
        return ResolvableType.forMethodReturnType(method2, clazz).resolve(method2.getReturnType());
    }

    @Nullable
    public static Class<?> resolveReturnTypeArgument(Method method2, Class<?> genericType) {
        Assert.notNull((Object)method2, "Method must not be null");
        ResolvableType resolvableType = ResolvableType.forMethodReturnType(method2).as(genericType);
        if (!resolvableType.hasGenerics() || resolvableType.getType() instanceof WildcardType) {
            return null;
        }
        return GenericTypeResolver.getSingleGeneric(resolvableType);
    }

    @Nullable
    public static Class<?> resolveTypeArgument(Class<?> clazz, Class<?> genericType) {
        ResolvableType resolvableType = ResolvableType.forClass(clazz).as(genericType);
        if (!resolvableType.hasGenerics()) {
            return null;
        }
        return GenericTypeResolver.getSingleGeneric(resolvableType);
    }

    @Nullable
    private static Class<?> getSingleGeneric(ResolvableType resolvableType) {
        Assert.isTrue(resolvableType.getGenerics().length == 1, () -> "Expected 1 type argument on generic interface [" + resolvableType + "] but found " + resolvableType.getGenerics().length);
        return resolvableType.getGeneric(new int[0]).resolve();
    }

    @Nullable
    public static Class<?>[] resolveTypeArguments(Class<?> clazz, Class<?> genericType) {
        ResolvableType type2 = ResolvableType.forClass(clazz).as(genericType);
        if (!type2.hasGenerics() || type2.isEntirelyUnresolvable()) {
            return null;
        }
        return type2.resolveGenerics(Object.class);
    }

    public static Type resolveType(Type genericType, @Nullable Class<?> contextClass) {
        if (contextClass != null) {
            if (genericType instanceof TypeVariable) {
                Class<?> resolved;
                TypeVariable typeVariable = (TypeVariable)genericType;
                ResolvableType resolvedTypeVariable = GenericTypeResolver.resolveVariable(typeVariable, ResolvableType.forClass(contextClass));
                if (resolvedTypeVariable != ResolvableType.NONE && (resolved = resolvedTypeVariable.resolve()) != null) {
                    return resolved;
                }
            } else if (genericType instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)genericType;
                ResolvableType resolvedType = ResolvableType.forType(genericType);
                if (resolvedType.hasUnresolvableGenerics()) {
                    Class[] generics = new Class[parameterizedType.getActualTypeArguments().length];
                    Type[] typeArguments = parameterizedType.getActualTypeArguments();
                    ResolvableType contextType = ResolvableType.forClass(contextClass);
                    for (int i2 = 0; i2 < typeArguments.length; ++i2) {
                        Type typeArgument = typeArguments[i2];
                        if (typeArgument instanceof TypeVariable) {
                            TypeVariable typeVariable = (TypeVariable)typeArgument;
                            ResolvableType resolvedTypeArgument = GenericTypeResolver.resolveVariable(typeVariable, contextType);
                            if (resolvedTypeArgument != ResolvableType.NONE) {
                                generics[i2] = resolvedTypeArgument.resolve();
                                continue;
                            }
                            generics[i2] = ResolvableType.forType(typeArgument).resolve();
                            continue;
                        }
                        generics[i2] = ResolvableType.forType(typeArgument).resolve();
                    }
                    Class<?> rawClass = resolvedType.getRawClass();
                    if (rawClass != null) {
                        return ResolvableType.forClassWithGenerics(rawClass, generics).getType();
                    }
                }
            }
        }
        return genericType;
    }

    private static ResolvableType resolveVariable(TypeVariable<?> typeVariable, ResolvableType contextType) {
        ResolvableType superType;
        ResolvableType resolvedType;
        if (contextType.hasGenerics()) {
            ResolvableType.VariableResolver variableResolver = contextType.asVariableResolver();
            if (variableResolver == null) {
                return ResolvableType.NONE;
            }
            resolvedType = variableResolver.resolveVariable(typeVariable);
            if (resolvedType != null) {
                return resolvedType;
            }
        }
        if ((superType = contextType.getSuperType()) != ResolvableType.NONE && (resolvedType = GenericTypeResolver.resolveVariable(typeVariable, superType)) != ResolvableType.NONE) {
            return resolvedType;
        }
        for (ResolvableType ifc : contextType.getInterfaces()) {
            resolvedType = GenericTypeResolver.resolveVariable(typeVariable, ifc);
            if (resolvedType == ResolvableType.NONE) continue;
            return resolvedType;
        }
        return ResolvableType.NONE;
    }

    public static Class<?> resolveType(Type genericType, Map<TypeVariable, Type> map2) {
        return ResolvableType.forType(genericType, new TypeVariableMapVariableResolver(map2)).toClass();
    }

    public static Map<TypeVariable, Type> getTypeVariableMap(Class<?> clazz) {
        Map<TypeVariable, Type> typeVariableMap = typeVariableCache.get(clazz);
        if (typeVariableMap == null) {
            typeVariableMap = new HashMap<TypeVariable, Type>();
            GenericTypeResolver.buildTypeVariableMap(ResolvableType.forClass(clazz), typeVariableMap);
            typeVariableCache.put(clazz, Collections.unmodifiableMap(typeVariableMap));
        }
        return typeVariableMap;
    }

    private static void buildTypeVariableMap(ResolvableType type2, Map<TypeVariable, Type> typeVariableMap) {
        if (type2 != ResolvableType.NONE) {
            Class<?> resolved = type2.resolve();
            if (resolved != null && type2.getType() instanceof ParameterizedType) {
                TypeVariable<Class<?>>[] variables = resolved.getTypeParameters();
                for (int i2 = 0; i2 < variables.length; ++i2) {
                    ResolvableType generic = type2.getGeneric(i2);
                    while (generic.getType() instanceof TypeVariable) {
                        generic = generic.resolveType();
                    }
                    if (generic == ResolvableType.NONE) continue;
                    typeVariableMap.put(variables[i2], generic.getType());
                }
            }
            GenericTypeResolver.buildTypeVariableMap(type2.getSuperType(), typeVariableMap);
            for (ResolvableType interfaceType : type2.getInterfaces()) {
                GenericTypeResolver.buildTypeVariableMap(interfaceType, typeVariableMap);
            }
            if (resolved != null && resolved.isMemberClass()) {
                GenericTypeResolver.buildTypeVariableMap(ResolvableType.forClass(resolved.getEnclosingClass()), typeVariableMap);
            }
        }
    }

    private static class TypeVariableMapVariableResolver
    implements ResolvableType.VariableResolver {
        private final Map<TypeVariable, Type> typeVariableMap;

        public TypeVariableMapVariableResolver(Map<TypeVariable, Type> typeVariableMap) {
            this.typeVariableMap = typeVariableMap;
        }

        @Override
        @Nullable
        public ResolvableType resolveVariable(TypeVariable<?> variable) {
            Type type2 = this.typeVariableMap.get(variable);
            return type2 != null ? ResolvableType.forType(type2) : null;
        }

        @Override
        public Object getSource() {
            return this.typeVariableMap;
        }
    }
}

