/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.reflect.KCallable;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.KType;
import kotlin.reflect.full.KCallables;
import kotlin.reflect.full.KClasses;
import kotlin.reflect.full.KClassifiers;
import kotlin.reflect.full.KTypes;
import kotlin.reflect.jvm.KCallablesJvm;
import kotlin.reflect.jvm.ReflectJvmMapping;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineStart;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.GlobalScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.reactor.MonoKt;
import kotlinx.coroutines.reactor.ReactorFlowKt;
import org.reactivestreams.Publisher;
import org.springframework.core.KotlinDetector;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class CoroutinesUtils {
    private static final KType flowType = KClassifiers.getStarProjectedType((KClassifier)JvmClassMappingKt.getKotlinClass(Flow.class));
    private static final KType monoType = KClassifiers.getStarProjectedType((KClassifier)JvmClassMappingKt.getKotlinClass(Mono.class));
    private static final KType publisherType = KClassifiers.getStarProjectedType((KClassifier)JvmClassMappingKt.getKotlinClass(Publisher.class));

    public static <T> Mono<T> deferredToMono(Deferred<T> source2) {
        return MonoKt.mono((CoroutineContext)Dispatchers.getUnconfined(), (scope, continuation) -> source2.await(continuation));
    }

    public static <T> Deferred<T> monoToDeferred(Mono<T> source2) {
        return BuildersKt.async((CoroutineScope)GlobalScope.INSTANCE, (CoroutineContext)Dispatchers.getUnconfined(), (CoroutineStart)CoroutineStart.DEFAULT, (scope, continuation) -> MonoKt.awaitSingleOrNull((Mono)source2, (Continuation)continuation));
    }

    public static Publisher<?> invokeSuspendingFunction(Method method2, Object target2, Object ... args2) {
        return CoroutinesUtils.invokeSuspendingFunction((CoroutineContext)Dispatchers.getUnconfined(), method2, target2, args2);
    }

    public static Publisher<?> invokeSuspendingFunction(CoroutineContext context, Method method2, @Nullable Object target2, Object ... args2) {
        Assert.isTrue(KotlinDetector.isSuspendingFunction(method2), "Method must be a suspending function");
        KFunction function = ReflectJvmMapping.getKotlinFunction((Method)method2);
        Assert.notNull((Object)function, () -> "Failed to get Kotlin function for method: " + method2);
        if (method2.isAccessible() && !KCallablesJvm.isAccessible((KCallable)function)) {
            KCallablesJvm.setAccessible((KCallable)function, (boolean)true);
        }
        Mono mono = MonoKt.mono((CoroutineContext)context, (scope, continuation) -> {
            HashMap<KParameter, Object> argMap = CollectionUtils.newHashMap(args2.length + 1);
            int index2 = 0;
            for (KParameter parameter : function.getParameters()) {
                switch (parameter.getKind()) {
                    case INSTANCE: {
                        argMap.put(parameter, target2);
                        break;
                    }
                    case VALUE: 
                    case EXTENSION_RECEIVER: {
                        Object arg2 = args2[index2];
                        if (!parameter.isOptional() || arg2 != null) {
                            KClass kClass;
                            KClassifier patt5429$temp;
                            KType type2 = parameter.getType();
                            if ((!type2.isMarkedNullable() || arg2 != null) && (patt5429$temp = type2.getClassifier()) instanceof KClass && KotlinDetector.isInlineClass(JvmClassMappingKt.getJavaClass((KClass)(kClass = (KClass)patt5429$temp)))) {
                                KFunction constructor2 = KClasses.getPrimaryConstructor((KClass)kClass);
                                if (!KCallablesJvm.isAccessible((KCallable)constructor2)) {
                                    KCallablesJvm.setAccessible((KCallable)constructor2, (boolean)true);
                                }
                                arg2 = constructor2.call(new Object[]{arg2});
                            }
                            argMap.put(parameter, arg2);
                        }
                        ++index2;
                    }
                }
            }
            return KCallables.callSuspendBy((KCallable)function, argMap, (Continuation)continuation);
        }).filter(result2 -> result2 != Unit.INSTANCE).onErrorMap(InvocationTargetException.class, InvocationTargetException::getTargetException);
        KType returnType = function.getReturnType();
        if (KTypes.isSubtypeOf((KType)returnType, (KType)flowType)) {
            return mono.flatMapMany(CoroutinesUtils::asFlux);
        }
        if (KTypes.isSubtypeOf((KType)returnType, (KType)publisherType)) {
            if (KTypes.isSubtypeOf((KType)returnType, (KType)monoType)) {
                return mono.flatMap(o -> (Mono)o);
            }
            return mono.flatMapMany(o -> (Publisher)o);
        }
        return mono;
    }

    private static Flux<?> asFlux(Object flow) {
        return ReactorFlowKt.asFlux((Flow)((Flow)flow));
    }
}

