/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.Iterator;
import org.springframework.core.MethodParameter;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.ResolvableType;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public final class Conventions {
    private static final String PLURAL_SUFFIX = "List";

    private Conventions() {
    }

    public static String getVariableName(Object value2) {
        Class<?> valueClass;
        Assert.notNull(value2, "Value must not be null");
        boolean pluralize = false;
        if (value2.getClass().isArray()) {
            valueClass = value2.getClass().componentType();
            pluralize = true;
        } else if (value2 instanceof Collection) {
            Collection collection = (Collection)value2;
            if (collection.isEmpty()) {
                throw new IllegalArgumentException("Cannot generate variable name for an empty Collection");
            }
            Object valueToCheck = Conventions.peekAhead(collection);
            valueClass = Conventions.getClassForValue(valueToCheck);
            pluralize = true;
        } else {
            valueClass = Conventions.getClassForValue(value2);
        }
        String name2 = ClassUtils.getShortNameAsProperty(valueClass);
        return pluralize ? Conventions.pluralize(name2) : name2;
    }

    public static String getVariableNameForParameter(MethodParameter parameter) {
        Class<?> valueClass;
        Assert.notNull((Object)parameter, "MethodParameter must not be null");
        boolean pluralize = false;
        String reactiveSuffix = "";
        if (parameter.getParameterType().isArray()) {
            valueClass = parameter.getParameterType().componentType();
            pluralize = true;
        } else if (Collection.class.isAssignableFrom(parameter.getParameterType())) {
            valueClass = ResolvableType.forMethodParameter(parameter).asCollection().resolveGeneric(new int[0]);
            if (valueClass == null) {
                throw new IllegalArgumentException("Cannot generate variable name for non-typed Collection parameter type");
            }
            pluralize = true;
        } else {
            valueClass = parameter.getParameterType();
            ReactiveAdapter adapter = ReactiveAdapterRegistry.getSharedInstance().getAdapter(valueClass);
            if (adapter != null && !adapter.getDescriptor().isNoValue()) {
                reactiveSuffix = ClassUtils.getShortName(valueClass);
                valueClass = parameter.nested().getNestedParameterType();
            }
        }
        String name2 = ClassUtils.getShortNameAsProperty(valueClass);
        return pluralize ? Conventions.pluralize(name2) : name2 + reactiveSuffix;
    }

    public static String getVariableNameForReturnType(Method method2) {
        return Conventions.getVariableNameForReturnType(method2, method2.getReturnType(), null);
    }

    public static String getVariableNameForReturnType(Method method2, @Nullable Object value2) {
        return Conventions.getVariableNameForReturnType(method2, method2.getReturnType(), value2);
    }

    public static String getVariableNameForReturnType(Method method2, Class<?> resolvedType, @Nullable Object value2) {
        Class<?> valueClass;
        Assert.notNull((Object)method2, "Method must not be null");
        if (Object.class == resolvedType) {
            Assert.notNull(value2, "Cannot generate variable name for an Object return type with null value");
            return Conventions.getVariableName(value2);
        }
        boolean pluralize = false;
        String reactiveSuffix = "";
        if (resolvedType.isArray()) {
            valueClass = resolvedType.componentType();
            pluralize = true;
        } else if (Collection.class.isAssignableFrom(resolvedType)) {
            valueClass = ResolvableType.forMethodReturnType(method2).asCollection().resolveGeneric(new int[0]);
            if (valueClass == null) {
                if (!(value2 instanceof Collection)) {
                    throw new IllegalArgumentException("Cannot generate variable name for non-typed Collection return type and a non-Collection value");
                }
                Collection collection = (Collection)value2;
                if (collection.isEmpty()) {
                    throw new IllegalArgumentException("Cannot generate variable name for non-typed Collection return type and an empty Collection value");
                }
                Object valueToCheck = Conventions.peekAhead(collection);
                valueClass = Conventions.getClassForValue(valueToCheck);
            }
            pluralize = true;
        } else {
            valueClass = resolvedType;
            ReactiveAdapter adapter = ReactiveAdapterRegistry.getSharedInstance().getAdapter(valueClass);
            if (adapter != null && !adapter.getDescriptor().isNoValue()) {
                reactiveSuffix = ClassUtils.getShortName(valueClass);
                valueClass = ResolvableType.forMethodReturnType(method2).getGeneric(new int[0]).toClass();
            }
        }
        String name2 = ClassUtils.getShortNameAsProperty(valueClass);
        return pluralize ? Conventions.pluralize(name2) : name2 + reactiveSuffix;
    }

    public static String attributeNameToPropertyName(String attributeName) {
        Assert.notNull((Object)attributeName, "'attributeName' must not be null");
        if (!attributeName.contains("-")) {
            return attributeName;
        }
        char[] result2 = new char[attributeName.length() - 1];
        int currPos = 0;
        boolean upperCaseNext = false;
        for (int i2 = 0; i2 < attributeName.length(); ++i2) {
            char c = attributeName.charAt(i2);
            if (c == '-') {
                upperCaseNext = true;
                continue;
            }
            if (upperCaseNext) {
                result2[currPos++] = Character.toUpperCase(c);
                upperCaseNext = false;
                continue;
            }
            result2[currPos++] = c;
        }
        return new String(result2, 0, currPos);
    }

    public static String getQualifiedAttributeName(Class<?> enclosingClass, String attributeName) {
        Assert.notNull(enclosingClass, "'enclosingClass' must not be null");
        Assert.notNull((Object)attributeName, "'attributeName' must not be null");
        return enclosingClass.getName() + "." + attributeName;
    }

    private static Class<?> getClassForValue(Object value2) {
        Class<?> valueClass = value2.getClass();
        if (Proxy.isProxyClass(valueClass)) {
            Class<?>[] ifcs;
            for (Class<?> ifc : ifcs = valueClass.getInterfaces()) {
                if (ClassUtils.isJavaLanguageInterface(ifc)) continue;
                return ifc;
            }
        } else if (valueClass.getName().lastIndexOf(36) != -1 && valueClass.getDeclaringClass() == null) {
            valueClass = valueClass.getSuperclass();
        }
        return valueClass;
    }

    private static String pluralize(String name2) {
        return name2 + PLURAL_SUFFIX;
    }

    private static <E> E peekAhead(Collection<E> collection) {
        Iterator<E> it = collection.iterator();
        if (!it.hasNext()) {
            throw new IllegalStateException("Unable to peek ahead in non-empty collection - no element found");
        }
        E value2 = it.next();
        if (value2 == null) {
            throw new IllegalStateException("Unable to peek ahead in non-empty collection - only null element found");
        }
        return value2;
    }
}

